<?php global $rola_opt;
/**
 * The single template file
 * @package Rola
*/

get_header();

$title      = get_the_title();
$categories = get_the_category();

// Blog sidebar
if( isset( $rola_opt['rola_blog_sidebar'] ) ) {
    if( $rola_opt['rola_blog_sidebar'] == 'rola_without_sidebar_center' ) :
        $rola_sidebar_class = 'col-lg-8 col-md-12 offset-lg-2';
    elseif( $rola_opt['rola_blog_sidebar'] == 'rola_without_sidebar' ) :
        $rola_sidebar_class = 'col-lg-12 col-md-12';
    else:
        if( is_active_sidebar( 'article-sidebar' ) ):
            $rola_sidebar_class = 'col-lg-8 col-md-12';
        else:
            $rola_sidebar_class = 'col-lg-8 col-md-12 offset-lg-2';
        endif;
    endif;
    $sidebar_hide = $rola_opt['rola_blog_sidebar'];
} else {
    if( is_active_sidebar( 'article-sidebar' ) ):
        $rola_sidebar_class = 'col-lg-8 col-md-12';
        $sidebar_hide = 'rola_with_sidebar_right';
    else:
        $rola_sidebar_class = 'col-lg-8 col-md-12 offset-lg-2';
        $sidebar_hide = 'rola_without_sidebar';
    endif;
} 

// Blog breadcrumb
$post_page_id       = get_option( 'page_for_posts' );
if( function_exists('acf_add_options_page') ) {
	$hide_blog_banner 	= get_field( 'enable_page_banner');
	$hide_breadcrumb 	= get_field( 'hide_breadcrumb');
	$custom_title 	    = get_field( 'enable_cus_pagetitle');
	$banner_style 	    = get_field( 'choose_banner_style' );
}else {
	$hide_blog_banner 	= false;
	$hide_breadcrumb 	= false;
	$custom_title 	    = false;
	$banner_style 	    = 1;
}

// Blog page link
if ( $post_page_id ) {
	$blog_link = get_permalink( $post_page_id );
}else{
	$blog_link = home_url( '/' );
}
// After Hiding Banner add spacing
if( $hide_blog_banner == true ) {
    $page_spac = 'mt-80';
} else {
    $page_spac = '';
}

$is_post_date   = isset( $rola_opt['is_post_date']) ? $rola_opt['is_post_date'] : true;

if( function_exists('acf_add_options_page') ) {
	$bg_img = get_field( 'post_banner_background_image' );
}else {
	$bg_img = '';
}

$page_shape1         = !empty($rola_opt['page_shape1']['url']) ? $rola_opt['page_shape1']['url'] : '';
$page_shape2         = !empty($rola_opt['page_shape2']['url']) ? $rola_opt['page_shape2']['url'] : '';
?>
	<?php if( $hide_blog_banner == false ) : ?>
		<div class="page-banner-area">
			<div class="container">
				<?php if($banner_style == 1) : ?>
					<div class="row align-items-center">
						<?php if( $bg_img  != '') : ?>
						<div class="col-lg-6 col-md-6">
						<?php else: ?>
						<div class="col-lg-12 col-md-12">
						<?php endif; ?>
							<div class="page-banner-content">
								<?php if( $custom_title == true && get_field( 'cus_pagetitle') != '' ) : ?>
									<h2><?php echo esc_html( get_field( 'cus_pagetitle' ) ); ?></h2>
								<?php elseif( $title != '' ): ?>
									<h2><?php the_title(); ?></h2>
								<?php else: ?>
									<h2><?php esc_html_e('No Title', 'rola'); ?></h2>
								<?php endif; ?>

								<?php if( $hide_breadcrumb == false ) : ?>
									<ul class="pages-list">
										<li><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'rola' ); ?></a></li>
										
										<?php if( $custom_title == true && get_field( 'cus_pagetitle') != '' ) { ?>
											<li><?php echo esc_html( get_field( 'cus_pagetitle') ); ?></li>
										<?php } elseif ( $title != '' ){ ?>
											<li><?php the_title(); ?></li>
										<?php } else { ?>
											<li><?php esc_html_e('No Title', 'rola'); ?></li>
										<?php } ?>
									</ul>
								<?php endif; ?>
							</div>
						</div>

						<?php if( $bg_img  != '') : ?>
							<div class="col-lg-6 col-md-6">
								<div class="page-banner-image text-end">
									<img src="<?php echo esc_url( $bg_img  ); ?>" alt="<?php esc_attr_e( 'Image', 'rola' ); ?>">
								</div>
							</div>
						<?php endif; ?>
					</div>
				<?php else: ?>
					<div class="page-banner-content text-center">
						<?php if( $custom_title == true && get_field( 'cus_pagetitle') != '' ) : ?>
							<h2><?php echo esc_html( get_field( 'cus_pagetitle' ) ); ?></h2>
						<?php elseif( $title != '' ): ?>
							<h2><?php the_title(); ?></h2>
						<?php else: ?>
							<h2><?php esc_html_e('No Title', 'rola'); ?></h2>
						<?php endif; ?>

						<?php if( $hide_breadcrumb == false ) : ?>
							<ul class="pages-list">
								<li><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'rola' ); ?></a></li>
								
								<?php if( $custom_title == true && get_field( 'cus_pagetitle') != '' ) { ?>
									<li><?php echo esc_html( get_field( 'cus_pagetitle') ); ?></li>
								<?php } elseif ( $title != '' ){ ?>
									<li><?php the_title(); ?></li>
								<?php } else { ?>
									<li><?php esc_html_e('No Title', 'rola'); ?></li>
								<?php } ?>
							</ul>
						<?php endif; ?>
					</div>
				<?php endif; ?>
			</div>

			<?php if( $page_shape1 != '') : ?>
				<div class="page-banner-shape-1">
					<img src="<?php echo esc_url( $page_shape1 ); ?> " alt="<?php esc_attr_e( 'Shape1', 'rola' ); ?>">
				</div>
			<?php endif; ?>
			<?php if( $page_shape2 != '') : ?>
				<div class="page-banner-shape-2">
					<img src="<?php echo esc_url( $page_shape2 ); ?> " alt="<?php esc_attr_e( 'Shape2', 'rola' ); ?>">
				</div>
			<?php endif; ?>
        </div>
	<?php endif; ?>

	<!-- Start Blog Area -->
	<div class="blog-details-area ptb-100 <?php echo esc_attr( $page_spac ); ?>">
		<div class="container">
			<div class="row">
				<?php if( $sidebar_hide == 'rola_with_sidebar_left' ): ?>
                    <?php get_sidebar(); ?>
                <?php endif; ?>

				<?php while ( have_posts() ) : the_post(); 
					$categories = get_the_category();
				
				?>
					<div class="<?php echo esc_attr( $rola_sidebar_class ); ?>">
						<div class="blog-details">
							<?php if( has_post_thumbnail() ) { ?>
								<div class="article-image">
									<img src="<?php the_post_thumbnail_url('full') ?>" alt="<?php the_title_attribute(); ?>">
								</div>
							<?php } ?>

							<div class="blog-details-content">
								<?php if( isset( $rola_opt['is_post_meta'] ) && $rola_opt['is_post_meta']  == false ) { ?>

									<div class="entry-meta-info d-flex justify-content-between align-items-center">
										<?php if ( $categories ) :  ?>
											<?php foreach( $categories as $category){ ?>
												<span> <a href="<?php echo esc_url( get_category_link( $category->term_id ) ) ?>"><?php echo esc_html($category->name)?></a></span>
											<?php } ?>
										<?php endif; ?>

										<ul>
											<li><?php echo esc_html_e('BY:', 'rola') ?> <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ) ) ?>">
												<?php the_author() ?>
											</a></li>
											<?php if( $is_post_date  == false ) : ?>
												<li><?php echo esc_html(get_the_date()) ?></li>
											<?php endif; ?>
											<li><?php comments_number(); ?></li>
										</ul>
									</div>
								<?php } ?>

								<?php the_content(); ?>
								
								<?php wp_link_pages( array(
									'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'rola' ),
									'after'  => '</div>',
								) );
								?>
							
								<?php if ( get_the_tags() ) :  ?>
									<div class="post-tag-media">
										<ul class="tag">
											<li><span><?php echo esc_html_e('Tags:', 'rola') ?></span></li>
											<?php $tags = get_the_tags();
											foreach ($tags as $tag ) {  ?>
													<li><a href="<?php echo esc_url(get_tag_link($tag->term_id)); ?>">
														<?php echo esc_html($tag->name) ?></a>
													</li>
												<?php
											} ?>
										</ul>
									</div>
								<?php endif; ?>
							</div>
						</div>
					
						<?php
						// If comments are open or we have at least one comment, load up the comment template.
						if ( comments_open() || get_comments_number() ) :
							comments_template();
						endif;
						?>
					</div> <?php 
				endwhile; // End of the loop.
				?>
				
				<?php if( $sidebar_hide == 'rola_with_sidebar_right' ): ?>
					<?php get_sidebar(); ?>
				<?php endif; ?>

			</div>
		</div>
	</div>

<?php
get_footer();
