<?php global $rola_opt;
/**
 * The sidebar containing the main widget area
 * @package Rola
 */
if ( class_exists( 'WooCommerce' ) ) {
	if( is_woocommerce() ) {
		$sidebar = 'shop';
	} elseif ( is_product() ) {
		$sidebar = 'shop';
	} else {
		$sidebar = 'article-sidebar';
	}
} else {
	$sidebar = 'article-sidebar';
}

if ( ! is_active_sidebar( $sidebar ) ) { 
	return;
}

$rola_blog_sidebar = isset( $rola_opt['rola_blog_sidebar']) ? $rola_opt['rola_blog_sidebar'] : 'rola_with_sidebar_right';

if( $rola_blog_sidebar == 'rola_with_sidebar_right'):
	$sidebar_pos = "right-pos";
else:
	$sidebar_pos = "left-pos";
endif;

?>
<div class="col-lg-4 col-md-12">
	<?php if ( class_exists( 'WooCommerce' ) ) {
		if( is_woocommerce() ) { ?>
			<div id="secondary" class="shop-sidebar blog-sidebar <?php echo esc_attr($sidebar_pos); ?>">
			<?php
		} elseif ( is_product() ) { ?>
			<div id="secondary" class="sidebar shop-sidebar blog-sidebar <?php echo esc_attr($sidebar_pos); ?>">
		<?php
		} else { ?>
			<div id="secondary" class="title blog-sidebar <?php echo esc_attr($sidebar_pos); ?>">
		<?php
		}
	} else { ?>
		<div id="secondary" class="title blog-sidebar <?php echo esc_attr($sidebar_pos); ?>">
	<?php } ?>
		<?php dynamic_sidebar( $sidebar );?>
	</div>
</div><!-- #secondary -->
