<?php
/**
 * Include the TGM_Plugin_Activation class.
 */

$pcs = trim( get_option( 'rola_purchase_code_status' ) );

require_once dirname( __FILE__ ) . '/class-tgm-plugin-activation.php';

if ( $pcs == 'valid' ) {
	add_action( 'tgmpa_register', 'rola_register_required_plugins' );
}

if ( ! function_exists( 'rola_register_required_plugins' ) ) {
	function rola_register_required_plugins() {

		$plugins = array(
			
			// Rola Toolkit
			array(
				'name'               => esc_html__('Rola Toolkit', 'rola'),
				'slug'               => 'rola-toolkit',
				'source'             => get_template_directory() . '/lib/plugins/rola-toolkit.zip', 
				'required'           => true,
			),

			// Elemantor Page Builder
			array(
				'name'               => esc_html__('Elementor Page Builder', 'rola'),
				'slug'               => 'elementor',
				'required'           => true,
			),

			// Advanced Custom Fields Pro
			array(
				'name'               => esc_html__('Advanced Custom Fields Pro', 'rola'),
				'slug'               => 'advanced-custom-fields-pro',
				'source'             => get_template_directory() . '/lib/plugins/advanced-custom-fields-pro.zip', 
				'required'           => true,
			),

			array(
				'name'      => esc_html__('WooCommerce', 'rola'),
				'slug'      => 'woocommerce',
				'required'  => false,
			),

			array(
				'name'      => esc_html__('Contact Form 7', 'rola'),
				'slug'      => 'contact-form-7',
				'required'  => false,
			),
			array(
				'name'		 => esc_html__( 'Unyson', 'rola' ),
				'slug'		 => 'unyson',
				'source'     => get_template_directory() . '/lib/plugins/unyson.zip',
				'required'	 => true,
			),
		);

		$config = array(
			'id'           => 'tgmpa',
			'default_path' => '',
			'menu'         => 'tgmpa-install-plugins',
			'parent_slug'  => 'themes.php',
			'capability'   => 'edit_theme_options',
			'has_notices'  => true, 
			'dismissable'  => true, 
			'dismiss_msg'  => '',   
			'is_automatic' => false, 
			'message'      => '',                      
		);
		tgmpa( $plugins, $config );
	}
}