<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 * @package Rola
 */

/**
 * Filter the categories archive widget to add a span around post count
 */
if ( ! function_exists( 'rola_cat_count_span' ) ) {
	function rola_cat_count_span( $links ) {
		$links = str_replace( '</a> (', '</a><span class="post-count">(', $links );
		$links = str_replace( ')', ')</span>', $links );
		return $links;
	}
}
add_filter( 'wp_list_categories', 'rola_cat_count_span' );

/**
 * Filter the archives widget to add a span around post count
 */
if ( ! function_exists( 'rola_archive_count_span' ) ) {
	function rola_archive_count_span( $links ) {
		$links = str_replace( '</a>&nbsp;(', '</a><span class="post-count">(', $links );
		$links = str_replace( ')', ')</span>', $links );
		return $links;
	}
}
add_filter( 'get_archives_link', 'rola_archive_count_span' );

/**
 * Excerpt more text
 */
if ( ! function_exists( 'rola_excerpt_more' ) ) :
	function rola_excerpt_more( $more ) {
		return ' ';
	}
endif;
add_filter('excerpt_more', 'rola_excerpt_more');

/**
 * Remove pages from search result
*/
if ( ! function_exists( 'rola_remove_pages_from_search' ) ) :
	function rola_remove_pages_from_search() {
		global $rola_opt;
		global $wp_post_types;

		if( isset( $rola_opt['rola_search_page'] ) ) {
			if( $rola_opt['rola_search_page'] != true ) {
				$wp_post_types['page']->exclude_from_search = true;
				if ( post_type_exists( 'service' ) ) {
					$wp_post_types['service']->exclude_from_search = true;
				}
			} else {
				$wp_post_types['page']->exclude_from_search = false;
			}
		} else {
			$wp_post_types['page']->exclude_from_search = false;
			if ( post_type_exists( 'service' ) ) {
				$wp_post_types['service']->exclude_from_search = true;
			}
		}
	}
endif;
add_action('init', 'rola_remove_pages_from_search');

/**
 * Menu Registration
*/
if ( ! function_exists( 'rola_register_primary_menus' ) ) :
	function rola_register_primary_menus(){
		register_nav_menus(
			array(
				'primary' 		=> esc_html__('Primary Menu', 'rola'),
			)
		);
	}
endif;
add_action('init', 'rola_register_primary_menus');

// Remove auto p from Contact Form 7 shortcode output
if ( ! function_exists( 'rola_remove_wpcf7_extra_p' ) ) {
	function rola_remove_wpcf7_extra_p() {
		return false;
	}
}
add_filter('wpcf7_autop_or_not', 'rola_remove_wpcf7_extra_p');