<?php
/**
 * Enqueue scripts and styles.
 */
if ( ! function_exists( 'rola_scripts' ) ) :

	function rola_scripts() {

		wp_enqueue_style( 'rola-style', get_stylesheet_uri() );

		wp_style_add_data( 'rola-style', 'rtl', 'replace' );
		
		wp_enqueue_style( 'bootstrap', 			    ROLA_CSS . '/bootstrap.min.css', null, ROLA_VERSION );
		wp_enqueue_style( 'animate', 			    ROLA_CSS . '/animate.min.css', null, ROLA_VERSION );
		wp_enqueue_style( 'meanmenu', 			    ROLA_CSS . '/meanmenu.css', null, ROLA_VERSION );
		wp_enqueue_style( 'boxicons', 			    ROLA_CSS . '/boxicons.min.css', null, ROLA_VERSION );
		wp_enqueue_style( 'flaticon', 			    ROLA_CSS . '/flaticon.css', null, ROLA_VERSION );
		// wp_enqueue_style( 'flaticon-two', 			ROLA_CSS . '/flaticon-two.css', null, ROLA_VERSION );
		wp_enqueue_style( 'odometer', 			    ROLA_CSS . '/odometer.min.css', null, ROLA_VERSION );
		wp_enqueue_style( 'nice-select', 			ROLA_CSS . '/nice-select.min.css', null, ROLA_VERSION );
		wp_enqueue_style( 'progresscircle', 		ROLA_CSS . '/progresscircle.min.css', null, ROLA_VERSION );
		wp_enqueue_style( 'owl-carousel', 		    ROLA_CSS . '/owl.carousel.min.css', null, ROLA_VERSION );
		wp_enqueue_style( 'owl-theme-default', 		ROLA_CSS . '/owl.theme.default.min.css', null, ROLA_VERSION );
		wp_enqueue_style( 'magnific-popup', 	    ROLA_CSS . '/magnific-popup.min.css', null, ROLA_VERSION );
		wp_enqueue_style( 'twentytwenty', 		    ROLA_CSS . '/twentytwenty.min.css', null, ROLA_VERSION );
		wp_enqueue_style( 'slick', 		            ROLA_CSS . '/slick.min.css', null, ROLA_VERSION );
		wp_enqueue_style( 'datepicker', 	        ROLA_CSS . '/datepicker.css', null, ROLA_VERSION );

		// WooCommerce CSS
		if ( class_exists( 'WooCommerce' ) ):
			wp_enqueue_style( 'rola-woocommerce',   ROLA_CSS  . '/woocommerce.css', null, ROLA_VERSION );
		endif;

		wp_enqueue_style( 'rola-main-style', 	    ROLA_CSS . '/style.css', null, ROLA_VERSION );
		wp_enqueue_style( 'rola-blog', 	            ROLA_CSS . '/blog.css', null, ROLA_VERSION );
		wp_enqueue_style( 'rola-responsive', 	    ROLA_CSS . '/responsive.css', null, ROLA_VERSION );

		//RTL
		if( rola_rtl() == true ):
			wp_enqueue_style( 'rola-rtl', get_template_directory_uri() . '/style-rtl.css' );
		endif;
		
		/**
         * Enqueueing JavaScript Files
        */
		wp_enqueue_script( 'bootstrap', 		    ROLA_JS . '/bootstrap.min.js', array('jquery'), ROLA_VERSION );
		wp_enqueue_script( 'jquery-magnific-popup', ROLA_JS . '/jquery.magnific-popup.min.js', array('jquery'), ROLA_VERSION );
		wp_enqueue_script( 'jquery-meanmenu', 		ROLA_JS . '/jquery.meanmenu.js', array('jquery'), ROLA_VERSION );
		wp_enqueue_script( 'nice-select', 		    ROLA_JS . '/nice-select.min.js', array('jquery'), ROLA_VERSION );
		wp_enqueue_script( 'event-move', 		    ROLA_JS . '/event.move.min.js', array('jquery'), ROLA_VERSION );
		wp_enqueue_script( 'odometer', 			    ROLA_JS . '/odometer.min.js', array('jquery'), ROLA_VERSION );
		wp_enqueue_script( 'owl-carousel', 			ROLA_JS . '/owl.carousel.min.js', array('jquery'), ROLA_VERSION );
		wp_enqueue_script( 'jquery-appear', 		ROLA_JS . '/jquery.appear.js', array('jquery'), ROLA_VERSION );
		wp_enqueue_script( 'popper', 			    ROLA_JS . '/popper.min.js', array('jquery'), ROLA_VERSION );
		wp_enqueue_script( 'progresscircle', 		ROLA_JS . '/progresscircle.min.js', array('jquery'), ROLA_VERSION );
		wp_enqueue_script( 'twentytwenty', 		    ROLA_JS . '/twentytwenty.min.js', array('jquery'), ROLA_VERSION );
		wp_enqueue_script( 'slick', 		        ROLA_JS . '/slick.min.js', array('jquery'), ROLA_VERSION );
		wp_enqueue_script( 'datepicker', 			ROLA_JS . '/datepicker.js', array('jquery'), ROLA_VERSION );
		wp_enqueue_script( 'wow', 			        ROLA_JS . '/wow.min.js', array('jquery'), ROLA_VERSION );
		wp_enqueue_script( 'jquery-ajaxchimp', 	    ROLA_JS . '/jquery.ajaxchimp.min.js', array('jquery'),ROLA_JS );
		wp_enqueue_script( 'rola-main', 			ROLA_JS . '/main.js', array('jquery'), ROLA_VERSION );
		
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
	}
	
endif;
add_action( 'wp_enqueue_scripts', 'rola_scripts' );
