<?php
/**
 * Register custom style.
 */

if ( ! function_exists( 'rola_custom_style' ) ) {
    function rola_custom_style(){
        
        $custom_style ='';
        global $rola_opt;

        // Disable Sticky Header
        if( isset ($rola_opt['disable_sticky_header']) ):
            if( $rola_opt['disable_sticky_header'] == true ):
                $custom_style .='
                .navbar-area.is-sticky {
                    display: none;
                }
                ';
            endif;
        endif;

        // Navbar Style 2
        if( isset ($rola_opt['nav_s2_bg']['url']) ):
            if( $rola_opt['nav_s2_bg']['url'] != '' ):
                $custom_style .="
                .dental-tourism-navbar .main-navbar .navbar .navbar-brand::before {
                    background-image: url(" . esc_url( $rola_opt['nav_s2_bg']['url'] ) . ");
                }
                ";
            else :
                $custom_style .="
                .dental-tourism-navbar .main-navbar .navbar .navbar-brand {
                    color: #000;
                }
                .top-dental-tourism-information.with-left {
                    margin-left: 0;
                }
                ";
            endif;
        endif;

        // Service details
        if( isset ($rola_opt['rola_service_details_order']) ):

            if( $rola_opt['rola_service_details_order'] == 'rola_sidebar_hide'){
                $custom_style .="
                @media only screen and (max-width: 767px) {
                    .services-details-area .row .col-md-12:nth-child(1) {
                        display: none;
                    }
                    .services-details-desc {
                        margin-top: 0 !important;
                        margin-bottom: 0;
                    }
                }
                ";
            } elseif( $rola_opt['rola_service_details_order'] == 'rola_top'){
                $custom_style .="
                @media only screen and (max-width: 767px) {

                    .services-details-area .row .col-md-12:nth-child(1) {
                        -webkit-box-ordinal-group: 3;
                        -ms-flex-order: 2;
                        order: 2;
                    }
                    .services-details-area .row .col-md-12:nth-child(2) {
                        -webkit-box-ordinal-group: 2;
                        -ms-flex-order: 1;
                        order: 1;
                    }
                    .services-details-desc {
                        margin-top: 0 !important;
                        margin-bottom: 30px;
                    }
                }
                ";
            }else {

            }
        endif;

        // Custom Css
        if( isset($rola_opt['css_code'] ) && !empty($rola_opt['css_code']) ):
            $custom_style .= $rola_opt['css_code'];
        endif;

        if( !is_user_logged_in() ){ 
            $custom_style .=' #wpadminbar {
                display: none;
            }';
        }

        wp_add_inline_style('rola-main-style', $custom_style);

        // Custom Js
        $custom_script ='';
        if( isset($rola_opt['js_code'] )){
            $custom_script .= $rola_opt['js_code'];
        }
        
        wp_add_inline_script( 'rola-main', $custom_script );
    }
}
add_action( 'wp_enqueue_scripts', 'rola_custom_style' );