<?php
/**
 * Overview Area Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Rola_Overview_Area extends Widget_Base {

	public function get_name() {
        return 'Rola_Overview_Area';
    }

	public function get_title() {
        return esc_html__( 'Overview Area', 'rola-toolkit' );
    }

	public function get_icon() {
        return 'eicon-info-box';
    }

	public function get_categories() {
        return [ 'rolacategory' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'rola_About_Area',
			[
				'label' => esc_html__( 'Overview Area', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );
            
            $this->add_control(
                'bg_image',
                [
                    'label'  => esc_html__( 'Image', 'rola-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'title',
                [
                    'label'   => esc_html__( 'Title', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXTAREA,
                ]
            );
            // Button One
            $this->add_control(
                'button_one_text',
                [
                    'label' => __('Button One Text', 'rola-toolkit'),
                    'type'  => Controls_Manager:: TEXT,
                ]
            );
            $this->add_control(
                'link_type',
                [
                    'label' => __( 'Link Type', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        '1'   => __( 'Link To Page', 'rola-toolkit' ),
                        '2'   => __( 'External Link', 'rola-toolkit' ),
                    ],
                ]
            );
            $this->add_control(
                'link_to_page',
                [
                    'label' => __( 'Link Page', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options'     => rola_toolkit_get_page_as_list(),
                    'condition'   => [
                        'link_type' => '1',
                    ]
                ]
            );
            $this->add_control(
                'external_link',
                [
                    'label' => __('External Link', 'rola-toolkit'),
                    'type'  => Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type' => '2',
                    ]
                ]
            );
            // Button Two
            $this->add_control(
                'button_two_text',
                [
                    'label' => __('Button Two Text', 'rola-toolkit'),
                    'type'  => Controls_Manager:: TEXT,
                ]
            );
            $this->add_control(
                'link_type2',
                [
                    'label' => __( 'Link Type', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        '1'   => __( 'Link To Page', 'rola-toolkit' ),
                        '2'   => __( 'External Link', 'rola-toolkit' ),
                    ],
                ]
            );
            $this->add_control(
                'link_to_page2',
                [
                    'label' => __( 'Link Page', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => rola_toolkit_get_page_as_list(),
                    'condition' => [
                        'link_type2' => '1',
                    ]
                ]
            );
            $this->add_control(
                'external_link2',
                [
                    'label' => __('External Link', 'rola-toolkit'),
                    'type'  => Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type2' => '2',
                    ]
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'rola-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );
            $this->add_control(
                'title_color',
                [
                    'label'     => __( 'Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .overview-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .overview-content h3',
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Button link
        $btn1_text  = $settings['button_one_text'];
        $btn2_text  = $settings['button_two_text'];

        $link_one = '';
        if( $settings['link_type'] == 1 ){
            $link_one = get_page_link($settings['link_to_page']); 
        } else {
            $link_one = $settings['external_link'];
        } 
        
        $link_two = '';
        if( $settings['link_type2'] == 1 ){
            $link_two = get_page_link($settings['link_to_page2']); 
        } else {
            $link_two = $settings['external_link2'];
        }

        ?>

        <div class="overview-area ptb-100" style="background-image: url(<?php echo esc_url( $settings['bg_image']['url']); ?> )">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-7 col-md-12">
                        <?php if($settings['title'] != '') : ?>
                            <div class="overview-content">
                                <h3><?php echo wp_kses_post( $settings['title'] ); ?></h3>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="col-lg-5 col-md-12">
                        <?php if( $btn1_text != '' || $btn2_text != '') : ?>
                            <ul class="overview-btn-list text-end">
                                <?php if( $btn1_text != '' ): ?>
                                    <li><a href="<?php echo esc_url($link_one); ?>" class="default-btn"> <?php echo esc_html( $btn1_text ); ?></a></li>
                                <?php endif; ?>
                                
                                <?php if( $btn2_text != '' ): ?>
                                    <li><a href="<?php echo esc_url($link_two); ?>" class="optional-btn"><?php echo esc_html( $btn2_text ); ?></a></li>
                                <?php endif; ?>
                            </ul>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <?php
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Rola_Overview_Area );