<?php
/**
 * Core Feature Widget
 */

namespace Elementor;
class Rola_Core_Features extends Widget_Base {

	public function get_name() {
        return 'Rola_Core_Services';
    }

	public function get_title() {
        return __( 'Core Service Feature', 'rola-toolkit' );
    }

	public function get_icon() {
        return 'eicon-tools';
    }

	public function get_categories() {
        return [ 'rolacategory' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'services_section',
			[
				'label' => __( 'Core Features', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'choose_type',
                [
                    'label' => esc_html__( 'Choose Style', 'baike-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        '1'  => esc_html__( 'Style 1', 'baike-toolkit' ),
                        '2'  => esc_html__( 'Style 2', 'baike-toolkit' ),
                    ], 
                    'default' => '1'
                ]
            );

            $this->add_control(
                'columns',
                [
                    'label' => __( 'Choose Columns', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'options' => [
                        '2'   => __( '2', 'rola-toolkit' ),
                        '3'   => __( '3', 'rola-toolkit' ),
                        '4'   => __( '4', 'rola-toolkit' ),
                    ],
                    'default' => '4',
                ]
            );

            $this->add_control(
                'header_size',
                [
                    'label' => __( 'Title Heading Tag', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                    'default' => 'h3',
                ]
            );

            $this->add_control(
                'order',
                [
                    'label'   => __( 'Services Order By', 'rola-toolkit' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'DESC'      => __( 'DESC', 'rola-toolkit' ),
                        'ASC'       => __( 'ASC', 'rola-toolkit' ),
                    ],
                    'default' => 'DESC',
                ]
            );

            $this->add_control(
                'count',
                [
                    'label'   => __( 'Post Per Page', 'rola-toolkit' ),
                    'type'    => Controls_Manager::NUMBER,
                    'default' => 4,
                ]
            );

            $this->add_control(
                'excerpt_num',
                [
                    'label'   => __( 'Post Per Page', 'rola-toolkit' ),
                    'type'    => Controls_Manager::NUMBER,
                    'default' => 12,
                ]
            );

            $this->add_control(
                'cat_name',
                [
                    'label' => __( 'Choose Category', 'rola-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => rola_toolkit_get_page_services_cat_el(),
                ]
            );

        $this->end_controls_section();
        
        // Style
        $this->start_controls_section(
			'service_style',
			[
				'label' => __( 'Style', 'rola-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
			]
        );
            $this->add_control(
                'icon_color',
                [
                    'label'     => __( 'Icon Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-core-features .title i, .single-core-features-box .icon i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'icon_bgcolor',
                [
                    'label'     => __( 'Icon Background Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-core-features .title i, .single-core-features-box .icon i' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label'     => __( 'Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-core-features .title h3 a, .single-core-features .title h1 a, .single-core-features .title h2 a, .single-core-features .title h4 a, .single-core-features .title h5 a, .single-core-features .title h6 a, .single-core-features-box h3 a, .single-core-features-box h1 a, .single-core-features-box h2 a, .single-core-features-box h4 a, .single-core-features-box h5 a, .single-core-features-box h6 a' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-core-features .title h3 a, .single-core-features .title h1 a, .single-core-features .title h2 a, .single-core-features .title h4 a, .single-core-features .title h5 a, .single-core-features .title h6 a, .single-core-features-box h3 a, .single-core-features-box h1 a, .single-core-features-box h2 a, .single-core-features-box h4 a, .single-core-features-box h5 a, .single-core-features-box h6 a',
                ]
            );
            $this->add_control(
                'content_color',
                [
                    'label'     => __( 'Excerpt Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-core-features p, .single-core-features ul li, .single-core-features ol li, .single-core-features-box p, .single-core-features-box ol li, .single-core-features-box ul li' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-core-features p, .single-core-features ul li, .single-core-features ol li, .single-core-features-box p, .single-core-features-box ol li, .single-core-features-box ul li',
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {
        $settings = $this->get_settings_for_display();

        global $rola_opt;

        // Card Columns
        $columns = $settings['columns'];
        if ( $columns == '2' ) {
            $column = 'col-lg-6 col-sm-6';
        } elseif ( $columns == '3' ) {
            $column = 'col-lg-4 col-sm-6';
        } elseif ( $columns == '4' ) {
            $column = 'col-lg-3 col-sm-6';
        }
        
        // Services Query
        if( $settings['cat_name'] != '' ) {
            $args = array(
                'post_type'         => 'service',
                'posts_per_page'    => $settings['count'],
                'order'             => $settings['order'],
                'tax_query'         => array(
                    array(
                        'taxonomy'      => 'service_cat',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false,
                    )
                )
            );
        } else {
            $args = array(
                'post_type'           => 'service',
                'posts_per_page'      => $settings['count'],
                'order'               => $settings['order'],
            );
        }
        $services_array = new \WP_Query( $args );
        ?>

        <?php if( $settings['choose_type'] == '1' ): ?>
            <div class="container">
                <div class="row">
                    <?php while( $services_array->have_posts() ): 
                    $services_array->the_post();

                    if ( class_exists('ACF') ) {
                        if ( get_field('choose_link_type') == 1 ) {
                            $post_link = get_the_permalink();
                        } else {
                            $post_link = get_field('external_link');
                        }

                        $icon = get_field('service_icon');
                    } else {
                        $post_link = get_field('external_link');
                        $icon      = '';
                    }

                    ?>
                        <div class="<?php echo esc_attr(  $column ); ?>">
                            <div class="single-core-features">
                                <div class="title">
                                    <?php if( $icon != '' ) : ?>
                                        <i class="<?php echo esc_attr( $icon ); ?>"></i>
                                    <?php endif; ?>


                                    <<?php echo esc_attr( $settings['header_size'] ); ?>>
                                        <a href="<?php echo esc_url( $post_link ); ?>">
                                            <?php the_title(); ?>
                                        </a>
                                    </<?php echo esc_attr( $settings['header_size'] ); ?>>
                                </div>

                                <p><?php echo esc_html(wp_trim_words( get_the_excerpt(), $settings['excerpt_num'], '' )); ?></p>
                            </div>
                        </div>

                        <?php endwhile;
                    wp_reset_postdata(); ?>
                </div>
            </div>
        <?php else: ?>
            <div class="container">
                <div class="row">
                    <?php while( $services_array->have_posts() ): 
                    $services_array->the_post();

                    if ( class_exists('ACF') ) {
                        if ( get_field('choose_link_type') == 1 ) {
                            $post_link = get_the_permalink();
                        } else {
                            $post_link = get_field('external_link');
                        }

                        $icon = get_field('service_icon');
                    } else {
                        $post_link = get_field('external_link');
                        $icon      = '';
                    }

                    ?>
                        <div class="<?php echo esc_attr(  $column ); ?>">
                            <div class="single-core-features-box">
                                <div class="icon">
                                    <?php if( $icon != '' ) : ?>
                                        <i class="<?php echo esc_attr( $icon ); ?>"></i>
                                    <?php endif; ?>
                                </div>

                                <<?php echo esc_attr( $settings['header_size'] ); ?>>
                                    <a href="<?php echo esc_url( $post_link ); ?>">
                                        <?php the_title(); ?>
                                    </a>
                                </<?php echo esc_attr( $settings['header_size'] ); ?>>

                                <p><?php echo esc_html(wp_trim_words( get_the_excerpt(), $settings['excerpt_num'], '' )); ?></p>
                            </div>
                        </div>

                        <?php endwhile;
                    wp_reset_postdata(); ?>
                </div>
            </div>

        <?php endif; ?>
        <?php
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Rola_Core_Features );