<?php
/**
 * Posts Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Rola_Posts extends Widget_Base {

	public function get_name() {
        return 'Rola_Posts';
    }

	public function get_title() {
        return esc_html__( 'Posts', 'rola-toolkit' );
    }

	public function get_icon() {
        return 'eicon-post-slider';
    }

	public function get_categories() {
        return [ 'rolacategory' ];
	}
	protected function register_controls() {

        $this->start_controls_section(
			'rola_Posts',
			[
				'label' => esc_html__( 'Rola Posts', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );
            $this->add_control(
                'choose_style',
                [
                    'label' => __( 'Choose Style', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'options' => [
                        '1'   => __( 'Style one', 'rola-toolkit' ),
                        '2'   => __( 'Style two', 'rola-toolkit' ),
                        '3'   => __( 'Style three', 'rola-toolkit' ),
                        '4'   => __( 'Style four', 'rola-toolkit' ),
                        '5'   => __( 'Style five(without image)', 'rola-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );

            $this->add_control(
                'cat', [
                    'label'       => esc_html__( 'Category', 'rola-toolkit' ),
                    'description' => esc_html__( 'Enter the category slugs separated by commas (Eg. cat1, cat2)', 'rola-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );

            $this->add_control(
                'order',
                [
                    'label'   => esc_html__( 'Posts Order By', 'rola-toolkit' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'DESC'      => esc_html__( 'DESC', 'rola-toolkit' ),
                        'ASC'       => esc_html__( 'ASC', 'rola-toolkit' ),
                    ],
                    'default' => 'DESC',
                ]
            );

            $this->add_control(
                'columns',
                [
                    'label' => esc_html__( 'Choose Columns', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'options' => [
                        '1'   => esc_html__( '1', 'rola-toolkit' ),
                        '2'   => esc_html__( '2', 'rola-toolkit' ),
                        '3'   => esc_html__( '3', 'rola-toolkit' ),
                        '4'   => esc_html__( '4', 'rola-toolkit' ),
                    ],
                    'default' => '3',
                ]
            );

            $this->add_control(
                'count',
                [
                    'label'   => esc_html__( 'Posts', 'rola-toolkit' ),
                    'type'    => Controls_Manager::NUMBER,
                    'default' => 3,
                ]
            );
            $this->add_control(
                'excerpt_num',
                [
                    'label'   => esc_html__( 'Excerpt', 'rola-toolkit' ),
                    'type'    => Controls_Manager::NUMBER,
                    'default' => 11,
                ]
            );

            $this->add_control(
                'read_more',
                [
                    'label'       => __( 'Read More Text', 'rola-toolkit' ),
                    'default'     => __( 'Read More', 'rola-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'condition' => [
                        'choose_style!' => ['3','4','5'],
                    ]
                ]
            );
            $this->add_control(
                'by_text',
                [
                    'label'       => __( 'By Text', 'rola-toolkit' ),
                    'default'     => __( 'By: ', 'rola-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                ]
            );
        
        $this->end_controls_section();

        $this->start_controls_section(
			'blog_style',
			[
				'label' => esc_html__( 'Style Controls', 'rola-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );
            $this->add_control(
                'card_bgcolor',
                [
                    'label' => esc_html__( 'Card Background Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-blog-card' => 'background-color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_style' => '5',
                    ]
                ]
            );
            $this->add_control(
                'card_bghcolor',
                [
                    'label' => esc_html__( 'Card Background Hover Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-blog-card:hover' => 'background-color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_style' => '5',
                    ]
                ]
            );
            $this->add_control(
                'date_color',
                [
                    'label' => esc_html__( 'Date Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-blog-card .blog-image .tag, .single-blog-item .blog-image .tag' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_style!' => ['3','4','5'],
                    ]
                ]
            );
            $this->add_control(
                'date_bg_color',
                [
                    'label' => esc_html__( 'Date Background Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-blog-card .blog-image .tag, .single-blog-item .blog-image .tag' => 'background-color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_style!' => ['3','4','5'],
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'date_typography',
                    'label' => esc_html__( 'Date Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-blog .blog-image .tag, .single-blog-item .blog-image .tag',
                    'condition' => [
                        'choose_style!' => ['3','4','5'],
                    ]
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-blog-card .blog-content h3 a, .single-blog-item .blog-content h3 a, .dental-tourism-blog-card .blog-content h3 a, .skin-care-blog-card .blog-content h3 a, .eye-care-blog-card .blog-content h3 a' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'title_color_hover',
                [
                    'label' => esc_html__( 'Title Color Hover', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-blog-card .blog-content h3 a:hover, .single-blog-item .blog-content h3 a:hover, .dental-tourism-blog-card .blog-content h3 a:hover, .skin-care-blog-card .blog-content h3 a:hover, .eye-care-blog-card .blog-content h3 a:hover' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => esc_html__( 'Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-blog-card .blog-content h3 a, .single-blog-item .blog-content h3 a, .dental-tourism-blog-card .blog-content h3 a, .skin-care-blog-card .blog-content h3 a, .eye-care-blog-card .blog-content h3 a',
                ]
            );

            $this->add_control(
                'cat_color',
                [
                    'label' => esc_html__( 'Category Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-blog-item .blog-image .tag-two a, .dental-tourism-blog-card .blog-image .tag a, .skin-care-blog-card .blog-image .tag a, .eye-care-blog-card .blog-content .tag a' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_style' => ['2','3','4','5'],
                    ]
                ]
            );
            $this->add_control(
                'cat_bgcolor',
                [
                    'label' => esc_html__( 'Category Background Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dental-tourism-blog-card .blog-image .tag a, .skin-care-blog-card .blog-image .tag a, .eye-care-blog-card .blog-content .tag a' => 'background-color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_style' => ['3','4','5'],
                    ]
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'cat_typography',
                    'label' => esc_html__( 'Category Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-blog-item .blog-image .tag-two a, .dental-tourism-blog-card .blog-image .tag a, .skin-care-blog-card .blog-image .tag a, .eye-care-blog-card .blog-content .tag a',
                    'condition' => [
                        'choose_style' => ['2','3','4','5'],
                    ]
                ]
            );
            $this->add_control(
                'ex_color',
                [
                    'label' => esc_html__( 'Excerpt Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-blog-item .blog-content p, .eye-care-blog-card .blog-content p' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_style' => ['2','5'],
                    ]
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'ex_typography',
                    'label' => esc_html__( 'Excerpt Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-blog-item .blog-content p, .eye-care-blog-card .blog-content p',
                    'condition' => [
                        'choose_style' => ['2','5'],
                    ]
                ]
            );

            $this->add_control(
                'read_color',
                [
                    'label' => esc_html__( 'Read More Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-blog-card .blog-content .blog-btn, .single-blog-item .blog-content .blog-btn' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_style!' => ['3','4','5'],
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'read_typography',
                    'label' => esc_html__( 'Read More Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-blog-card .blog-content .blog-btn, .single-blog-item .blog-content .blog-btn',
                    'condition' => [
                        'choose_style!' => ['3','4','5'],
                    ]
                ]
            );
            $this->add_control(
                'meta_color',
                [
                    'label' => esc_html__( 'Meta Info Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-blog-item .blog-content .entry-meta li, .single-blog-item .blog-content .entry-meta li a, .dental-tourism-blog-card .blog-content .entry-meta li, .dental-tourism-blog-card .blog-content .entry-meta li a, .skin-care-blog-card .blog-content .entry-meta li, .skin-care-blog-card .blog-content .entry-meta li a, .eye-care-blog-card .blog-content .entry-meta li, .eye-care-blog-card .blog-content .entry-meta li a' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_style' => ['2','3','4','5'],
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'meta_info_typography',
                    'label' => esc_html__( 'Meta Info Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-blog-item .blog-content .entry-meta li, .single-blog-item .blog-content .entry-meta li a, .dental-tourism-blog-card .blog-content .entry-meta li, .dental-tourism-blog-card .blog-content .entry-meta li a, .skin-care-blog-card .blog-content .entry-meta li, .skin-care-blog-card .blog-content .entry-meta li a, .eye-care-blog-card .blog-content .entry-meta li, .eye-care-blog-card .blog-content .entry-meta li a',
                    'condition' => [
                        'choose_style' => ['2','3','4','5'],
                    ]
                ]
            );
            $this->add_control(
                'icon_color',
                [
                    'label' => esc_html__( 'Meta Icon Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dental-tourism-blog-card .blog-content .entry-meta li i, .skin-care-blog-card .blog-content .entry-meta li i, .eye-care-blog-card .blog-content .entry-meta li i' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_style' => ['3','4','5'],
                    ]
                ]
            );
        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Card Columns
        $columns = $settings['columns'];
        if ($columns == '1') {
            $column = 'col-lg-12 col-md-6';
        }elseif ($columns == '2') {
            $column = 'col-lg-6 col-md-6';
        }elseif ($columns == '3') {
            $column = 'col-lg-4 col-md-6';
        }elseif ($columns == '4') {
            $column = 'col-lg-3 col-md-6';
        }
        
        // Post Query
        if( $settings['cat'] != '' ) {
            $args = array(
                'post_type'     => 'post',
                'posts_per_page'=> $settings['count'],
                'order'         => $settings['order'],
                'ignore_sticky_posts' => 1,
                'meta_key' => '_thumbnail_id',
                'tax_query'     => array(
                    array(
                        'taxonomy'      => 'category',
                        'field'         => 'slug',
                        'terms'         => $settings['cat'],
                        'hide_empty'    => false
                    )
                )
            );
        } else {
            $args = array(
                'post_type'         => 'post',
                'posts_per_page'    => $settings['count'],
                'order'             => $settings['order'],
                'ignore_sticky_posts' => 1,
                'meta_key' => '_thumbnail_id'
            );
        }
        $post_array = new \WP_Query( $args );
        
		?>

    <?php if ( $settings['choose_style'] == '1' ) : ?>
        <div class="container">
            <div class="row justify-content-center">
                <?php while($post_array->have_posts()): $post_array->the_post(); 
                $categories = get_the_category();
                ?>
                <div class="<?php echo esc_attr( $column );?>">

                    <div class="single-blog-card">
                        <?php if(get_the_post_thumbnail_url() != ''): ?>
                            <div class="blog-image">
                                <a href="<?php the_permalink(); ?>">
                                    <img src="<?php echo get_the_post_thumbnail_url( get_the_ID(), 'rola_standard_card' ); ?>" alt="<?php the_post_thumbnail_caption();  ?>">
                                </a>
                            </div>
                        <?php endif; ?>

                        <div class="blog-content">
                            <ul class="entry-meta d-flex justify-content-between align-items-center">
                                <?php if ( ! empty( $categories ) ) { ?>
                                    <li><a href="<?php echo esc_url( get_category_link( $categories[0]->term_id ) ) ?>"> <?php echo esc_html( $categories[0]->name ) ?></a></li>
                                <?php } ?>

                                <li><i class='bx bx-calendar'></i> <?php echo esc_html(get_the_date()) ?> </li>
                            </ul>

                            <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>

                            <a href="<?php the_permalink(); ?>" class="blog-btn"><?php echo esc_html( $settings['read_more'] ); ?></a>
                        </div>
                    </div>

                </div>
                <?php endwhile; ?>
                <?php wp_reset_query(); ?>
            </div>
        </div>
    <?php elseif ( $settings['choose_style'] == '2' ) : ?>
        <div class="container">
            <div class="row">
                <?php while($post_array->have_posts()): $post_array->the_post(); 
                $categories = get_the_category();
                ?>
                <div class="<?php echo esc_attr( $column );?>">

                    <div class="single-blog-item">
                        <?php if(get_the_post_thumbnail_url() != ''): ?>
                            <div class="blog-image">
                                <a href="<?php the_permalink(); ?>">
                                    <img src="<?php echo get_the_post_thumbnail_url( get_the_ID(), 'rola_standard_card' ); ?>" alt="<?php the_post_thumbnail_caption();  ?>">
                                </a>

                                <div class="tag"> 	<?php echo esc_html(get_the_date('M d')) ?></div>
                                <?php if ( ! empty( $categories ) ) { ?>
                                    <div class="tag-two"><a href="<?php echo esc_url( get_category_link( $categories[0]->term_id ) ) ?>"> <?php echo esc_html( $categories[0]->name ) ?></a></div>
                                <?php } ?>
                            </div>
                        <?php endif; ?>

                        <div class="blog-content">

                            <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                            <p><?php echo esc_html(wp_trim_words( get_the_excerpt(), $settings['excerpt_num'], '' )); ?></p>

                            <a href="<?php the_permalink(); ?>" class="blog-btn"><?php echo esc_html( $settings['read_more'] ); ?></a>

                            <ul class="entry-meta">
                                <li> <i class='bx bxs-user'></i> <?php echo esc_html( $settings['by_text'] ); ?> <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ) ) ?>">
                                    <?php the_author() ?>
                                </a></li>

                                <li> <i class='bx bxs-comment'></i><?php comments_number(); ?> </li>
                            </ul>
                        </div>
                    </div>

                </div>
                <?php endwhile; ?>
                <?php wp_reset_query(); ?>
            </div>
        </div>
    <?php elseif ( $settings['choose_style'] == '3' ) : ?>
        <div class="container">
            <div class="row justify-content-center">
                <?php while($post_array->have_posts()): $post_array->the_post(); 
                $categories = get_the_category();
                ?>
                <div class="<?php echo esc_attr( $column );?>">
                    <div class="dental-tourism-blog-card">
                        <?php if(get_the_post_thumbnail_url() != ''): ?>
                            <div class="blog-image">
                                <a href="<?php the_permalink(); ?>">
                                    <img src="<?php echo get_the_post_thumbnail_url( get_the_ID(), 'rola_standard_card' ); ?>" alt="<?php the_post_thumbnail_caption();  ?>">
                                </a>
                                <?php if ( ! empty( $categories ) ) { ?>
                                    <div class="tag"><a href="<?php echo esc_url( get_category_link( $categories[0]->term_id ) ) ?>"> <?php echo esc_html( $categories[0]->name ) ?></a></div>
                                <?php } ?>
                            </div>
                        <?php endif; ?>

                        <div class="blog-content">
                            <ul class="entry-meta">
                                <li> <i class='bx bx-user'></i> <?php echo esc_html( $settings['by_text'] ); ?> <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ) ) ?>">
                                    <?php the_author() ?>
                                </a></li>
                                <li><i class='bx bx-time'></i> <?php echo esc_html(get_the_date()) ?></li>
                                <li> <i class='bx bx-message-dots'></i><?php comments_number(); ?> </li>
                            </ul>
                            <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                        </div>
                    </div>
                </div>
                <?php endwhile; ?>
                <?php wp_reset_query(); ?>
            </div>
        </div>
    <?php elseif ( $settings['choose_style'] == '4' ) : ?>
        <div class="container">
            <div class="row justify-content-center">
                <?php while($post_array->have_posts()): $post_array->the_post(); 
                $categories = get_the_category();
                ?>
                <div class="<?php echo esc_attr( $column );?>">
                    <div class="skin-care-blog-card">
                        <?php if(get_the_post_thumbnail_url() != ''): ?>
                            <div class="blog-image">
                                <a href="<?php the_permalink(); ?>">
                                    <img src="<?php echo get_the_post_thumbnail_url( get_the_ID(), 'rola_standard_card' ); ?>" alt="<?php the_post_thumbnail_caption();  ?>">
                                </a>
                                <?php if ( ! empty( $categories ) ) { ?>
                                    <div class="tag"><a href="<?php echo esc_url( get_category_link( $categories[0]->term_id ) ) ?>"> <?php echo esc_html( $categories[0]->name ) ?></a></div>
                                <?php } ?>
                            </div>
                        <?php endif; ?>

                        <div class="blog-content">
                            <ul class="entry-meta">
                                <li> <i class='bx bx-user'></i> <?php echo esc_html( $settings['by_text'] ); ?> <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ) ) ?>">
                                    <?php the_author() ?>
                                </a></li>
                                <li><i class='bx bx-time'></i> <?php echo esc_html(get_the_date()) ?></li>
                                <li> <i class='bx bx-message-dots'></i><?php comments_number(); ?> </li>
                            </ul>
                            <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                        </div>
                    </div>
                </div>
                <?php endwhile; ?>
                <?php wp_reset_query(); ?>
            </div>
        </div>
    <?php else: ?>
        <div class="container">
            <div class="row justify-content-center">
                <?php while($post_array->have_posts()): $post_array->the_post(); 
                $categories = get_the_category();
                ?>
                <div class="<?php echo esc_attr( $column );?>">
                    <div class="eye-care-blog-card">
                        <div class="blog-content">
                            <?php if ( ! empty( $categories ) ) { ?>
                                <div class="tag"><a href="<?php echo esc_url( get_category_link( $categories[0]->term_id ) ) ?>"> <?php echo esc_html( $categories[0]->name ) ?></a></div>
                            <?php } ?>
                            <ul class="entry-meta">
                                <li> <i class='bx bx-user'></i> <?php echo esc_html( $settings['by_text'] ); ?> <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ) ) ?>">
                                    <?php the_author() ?>
                                </a></li>
                                <li><i class='bx bx-time'></i> <?php echo esc_html(get_the_date()) ?></li>
                                <li> <i class='bx bx-message-dots'></i><?php comments_number(); ?> </li>
                            </ul>
                            <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                            <p><?php echo esc_html(wp_trim_words( get_the_excerpt(), $settings['excerpt_num'], '' )); ?></p>
                        </div>
                    </div>
                </div>
                <?php endwhile; ?>
                <?php wp_reset_query(); ?>
            </div>
        </div>
    <?php endif; ?>

        <?php
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Rola_Posts );