<?php
 /**
 * About Us Widget
 */
class Rola_about_info extends WP_Widget{

    function __construct(){
        $widget_ops = array('description' => esc_html__('Display About Info', 'rola-toolkit'));
        parent::__construct( false, esc_html__('Rola Footer About', 'rola-toolkit'), $widget_ops);
    }

    function widget($args, $instance){
        extract($args);
        global $rola_theme;

        $title  = apply_filters('widget_title', $instance['title']);

        echo wp_kses_post($before_widget);
        if($title) echo wp_kses_post($before_title.$title.$after_title);
        ?>
            <?php if( $instance['logo_info'] != '' ): ?>
                <p><?php echo esc_html($instance['logo_info']); ?></p>
            <?php endif; ?>

            <div class="share-link">
                <?php if( $instance['facebook_url'] != '' ): ?>
                <a href="<?php echo esc_url($instance['facebook_url']); ?>" target="_blank"><i class='bx bxl-facebook'></i></a>
                <?php endif; ?>

                <?php if( $instance['twitter_url'] != '' ): ?>
                <a href="<?php echo esc_url($instance['twitter_url']); ?>" target="_blank"><i class='bx bxl-twitter'></i></a>
                <?php endif; ?>

                <?php if( $instance['linkedin_url'] != '' ): ?>
                <a href="<?php echo esc_url($instance['linkedin_url']); ?>" target="_blank"><i class='bx bxl-linkedin'></i></a>
                <?php endif; ?>

                <?php if( $instance['instagram_url'] != '' ): ?>
                <a href="<?php echo esc_url($instance['instagram_url']); ?>" target="_blank"><i class='bx bxl-instagram'></i></a>
                <?php endif; ?>

                <?php if( $instance['youtube_url'] != '' ): ?>
                <a href="<?php echo esc_url($instance['youtube_url']); ?>" target="_blank"><i class='bx bxl-youtube'></i></a>
                <?php endif; ?>
            </div>


        <?php
        echo wp_kses_post($after_widget);
    }

    function update($new_instance, $old_instance){
        $instance                          = $old_instance;
        $instance['title']                 = strip_tags($new_instance['title']);
        $instance['logo_info']             = $new_instance['logo_info'];
        $instance['facebook_url']          = $new_instance['facebook_url'];
        $instance['twitter_url']           = $new_instance['twitter_url'];
        $instance['linkedin_url']          = $new_instance['linkedin_url'];
        $instance['instagram_url']         = $new_instance['instagram_url'];
        $instance['youtube_url']           = $new_instance['youtube_url'];

        return $instance;
    }

    function form($instance){
        $defaults = array(
            'title'             => esc_html__('Rola', 'rola-toolkit'),
            'logo_info'         => esc_html__('Lorem Ipsum has be industry standard dummy text ever since 1500s, when an unknown printer took a galley type and scrambled it to make a type specimen'),
            'facebook_url'            => '#',
            'twitter_url'             => '#',
            'linkedin_url'            => '#',
            'instagram_url'           => '#',
            'youtube_url'             => '#',
        );
        $instance = wp_parse_args((array)$instance, $defaults);
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
                <?php esc_html_e('Title:', 'rola-toolkit'); ?>
                <input class="widget" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo wp_kses_post($instance['title']); ?>" />
            </label>
        </p>
        
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('logo_info')); ?>">
                <?php esc_html_e('Logo Info:', 'rola-toolkit'); ?>
                <input class="widget" id="<?php echo esc_attr($this->get_field_id('logo_info')); ?>" name="<?php echo esc_attr($this->get_field_name('logo_info')); ?>" type="text" value="<?php echo wp_kses_post($instance['logo_info']); ?>" />
            </label>
        </p>

        <p>
            <label for="<?php echo esc_attr($this->get_field_id('facebook_url')); ?>">
                <?php esc_html_e('Facebook URL:', 'rola-toolkit'); ?>
                <input class="widget" id="<?php echo esc_attr($this->get_field_id('facebook_url')); ?>" name="<?php echo esc_attr($this->get_field_name('facebook_url')); ?>" type="text" value="<?php echo wp_kses_post($instance['facebook_url']); ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('twitter_url')); ?>">
                <?php esc_html_e('Twitter URL:', 'rola-toolkit'); ?>
                <input class="widget" id="<?php echo esc_attr($this->get_field_id('twitter_url')); ?>" name="<?php echo esc_attr($this->get_field_name('twitter_url')); ?>" type="text" value="<?php echo wp_kses_post($instance['twitter_url']); ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('linkedin_url')); ?>">
                <?php esc_html_e('Linkedin URL:', 'rola-toolkit'); ?>
                <input class="widget" id="<?php echo esc_attr($this->get_field_id('linkedin_url')); ?>" name="<?php echo esc_attr($this->get_field_name('linkedin_url')); ?>" type="text" value="<?php echo wp_kses_post($instance['linkedin_url']); ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('instagram_url')); ?>">
                <?php esc_html_e('Instagram URL:', 'rola-toolkit'); ?>
                <input class="widget" id="<?php echo esc_attr($this->get_field_id('instagram_url')); ?>" name="<?php echo esc_attr($this->get_field_name('instagram_url')); ?>" type="text" value="<?php echo wp_kses_post($instance['instagram_url']); ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('youtube_url')); ?>">
                <?php esc_html_e('Youtube URL:', 'rola-toolkit'); ?>
                <input class="widget" id="<?php echo esc_attr($this->get_field_id('youtube_url')); ?>" name="<?php echo esc_attr($this->get_field_name('youtube_url')); ?>" type="text" value="<?php echo wp_kses_post($instance['youtube_url']); ?>" />
            </label>
        </p>
        <?php
    }

}

function rola_register_about_info() {
    register_widget('Rola_about_info');
}

add_action('widgets_init', 'rola_register_about_info');