<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to rola/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

get_header( 'shop' );

global $rola_opt;

/**
 * Hook: woocommerce_before_main_content.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked woocommerce_breadcrumb - 20
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );

do_action( 'woocommerce_before_main_content' );

$post_page_id       = get_option( 'woocommerce_shop_page_id' );
$product_sidebar    = isset( $rola_opt['product_sidebar']) ? $rola_opt['product_sidebar'] : '';

if( function_exists('acf_add_options_page') ) {
	$hide_banner 		= get_field( 'enable_page_banner', $post_page_id);
	$hide_breadcrumb 	= get_field( 'hide_breadcrumb' , $post_page_id);
	$custom_title 	    = get_field( 'enable_cus_pagetitle' , $post_page_id);
    $banner_style 	    = get_field( 'choose_banner_style' , $post_page_id);
}else {
	$hide_banner 		= false;
	$hide_breadcrumb 	= false;
	$custom_title 	    = false;
    $banner_style 	    = 1;
}

if( $hide_banner == false ) {
    $page_spac = 'mt-80';
} else {
    $page_spac = '';
}

$page_shape1         = !empty($rola_opt['page_shape1']['url']) ? $rola_opt['page_shape1']['url'] : '';
$page_shape2         = !empty($rola_opt['page_shape2']['url']) ? $rola_opt['page_shape2']['url'] : '';
?> 

<?php if( $hide_banner == false ) { ?>
    <div class="page-banner-area">
        <div class="container">
            <?php if($banner_style == 1) : ?>
                <div class="row align-items-center">
                    <?php if ( apply_filters( 'woocommerce_show_page_title', true ) ) : ?>
                    <div class="col-lg-6 col-md-6">
                        <div class="page-banner-content">
                            <?php if( $custom_title == true && get_field( 'cus_pagetitle' , $post_page_id) != '' ) { ?>
                                <h2><?php echo esc_html( get_field( 'cus_pagetitle' , $post_page_id ) ); ?></h2>
                            <?php } else { ?>
                                <h2> <?php woocommerce_page_title(); ?> </h2>
                            <?php } ?>

                            <?php if( $hide_breadcrumb == false ) : ?>
                                <ul class="pages-list">
                                    <li><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'rola' ); ?></a></li>
                                    <li><?php woocommerce_page_title(); ?></li>
                                </ul>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endif; ?>

                    <?php if( get_the_post_thumbnail_url() != '') : ?>
                        <div class="col-lg-6 col-md-6">
                            <div class="page-banner-image text-end">
                                <img src="<?php echo esc_url( get_the_post_thumbnail_url() ); ?>" alt="<?php esc_attr_e( 'Image', 'rola' ); ?>">
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            <?php else: ?>
                <div class="page-banner-content text-center">
                    <?php if ( apply_filters( 'woocommerce_show_page_title', true ) ) : ?>
                        <?php if( $custom_title == true && get_field( 'cus_pagetitle' , $post_page_id) != '' ) { ?>
                            <h2><?php echo esc_html( get_field( 'cus_pagetitle' , $post_page_id ) ); ?></h2>
                        <?php } else { ?>
                            <h2> <?php woocommerce_page_title(); ?> </h2>
                        <?php } ?>

                        <?php if( $hide_breadcrumb == false ) : ?>
                            <ul class="pages-list">
                                <li><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'rola' ); ?></a></li>
                                <li><?php woocommerce_page_title(); ?></li>
                            </ul>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>

        <?php if( $page_shape1 != '') : ?>
            <div class="page-banner-shape-1">
                <img src="<?php echo esc_url( $page_shape1 ); ?> " alt="<?php esc_attr_e( 'Shape1', 'rola' ); ?>">
            </div>
        <?php endif; ?>
        <?php if( $page_shape2 != '') : ?>
            <div class="page-banner-shape-2">
                <img src="<?php echo esc_url( $page_shape2 ); ?> " alt="<?php esc_attr_e( 'Shape2', 'rola' ); ?>">
            </div>
        <?php endif; ?>
    </div>
<?php } ?>
  
<div class="special-products-area pt-100 pb-100 <?php echo esc_attr( $page_spac ); ?>">
    <div class="container">
        <div class="row">
        <?php
            if ( is_active_sidebar( 'shop' ) ) {
                if ( isset( $_GET['shop'] ) ) {
                    $rola_shop_cat_sidebar = $_GET['shop'];

                    if ( $rola_shop_cat_sidebar == 'none' ): ?>
                        <div class="col-lg-12 col-md-12">
                    <?php elseif ( $rola_shop_cat_sidebar == 'left' ): ?>
                        <?php do_action( 'woocommerce_sidebar' ); ?>
                        <div class="col-lg-8 col-md-12">
                    <?php elseif ( $rola_shop_cat_sidebar == 'right' ): ?>
                        <div class="col-lg-8 col-md-12">
                    <?php endif;

                } else {
                    if( $product_sidebar == 'left-sidebar' ): ?>
                        <?php do_action( 'woocommerce_sidebar' ); ?>
                        <div class="col-lg-8 col-md-12">
                    <?php elseif ( $product_sidebar == 'right-sidebar' ): ?>
                        <div class="col-lg-8 col-md-12">
                    <?php elseif ( $product_sidebar == 'rola_product_no_sidebar' ): ?>
                        <div class="col-lg-12 col-md-12">
                    <?php else: ?>
                        <?php do_action( 'woocommerce_sidebar' ); ?>
                        <div class="col-lg-8 col-md-12">
                    <?php endif;
                }
            } else { ?>
                <div class="col-lg-12 col-md-12">
            <?php } ?>
                <?php if ( woocommerce_product_loop() ) { ?>

                    <div class="woocommerce-topbar">
                        <?php do_action( 'woocommerce_before_shop_loop' ); ?>
                    </div>

                    <?Php
                    woocommerce_product_loop_start();

                    if ( wc_get_loop_prop( 'total' ) ) {
                        while ( have_posts() ) {
                            the_post();

                            /**
                             * Hook: woocommerce_shop_loop.
                             *
                             * @hooked WC_Structured_Data::generate_product_data() - 10
                             */
                            do_action( 'woocommerce_shop_loop' );

                            wc_get_template_part( 'content', 'product' );
                        }
                    }

                    woocommerce_product_loop_end();

                    /**
                     * Hook: woocommerce_after_shop_loop.
                     *
                     * @hooked woocommerce_pagination - 10
                     */
                    do_action( 'woocommerce_after_shop_loop' );
                } else {
                    /**
                     * Hook: woocommerce_no_products_found.
                     *
                     * @hooked wc_no_products_found - 10
                     */
                    do_action( 'woocommerce_no_products_found' );
                } ?>
            </div> <!-- end clo-8 -->
            
            <?php 
            if ( isset( $_GET['shop'] ) ) {
                if ( $rola_shop_cat_sidebar == 'right' ) { 
                    do_action( 'woocommerce_sidebar' );
                }
            } else {
                if ( $product_sidebar == 'right-sidebar' ) { 
                    do_action( 'woocommerce_sidebar' );
                }
            } ?>
        </div>
    </div>
</div>
<?php
/**
 * Hook: woocommerce_after_main_content.
 *
 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
 */
do_action( 'woocommerce_after_main_content' );

/**
 * Hook: woocommerce_sidebar.
 *
 * @hooked woocommerce_get_sidebar - 10
 */

get_footer( 'shop' ); ?>