<?php global $rola_opt;
/**
 * The template for displaying all pages
 */

get_header();

/**
 * Page Control
 */
if( function_exists('acf_add_options_page') ) {
	$hide_banner 		= get_field( 'enable_page_banner' );
	$hide_breadcrumb 	= get_field( 'hide_breadcrumb' );
	$custom_title 	    = get_field( 'enable_cus_pagetitle' );
	$banner_style 	    = get_field( 'choose_banner_style' );
}else {
	$hide_banner 		= false;
	$hide_breadcrumb 	= false;
	$custom_title 	    = false;
	$banner_style 	    = 1;
}
// After Hiding Banner add spacing
if( $hide_banner == true ) {
    $page_spac = 'mt-80';
} else {
    $page_spac = '';
}

$page_shape1         = !empty($rola_opt['page_shape1']['url']) ? $rola_opt['page_shape1']['url'] : '';
$page_shape2         = !empty($rola_opt['page_shape2']['url']) ? $rola_opt['page_shape2']['url'] : '';
?>
	<?php if( $hide_banner == false ) { ?><!-- Start Page Title Area -->
		<div class="page-banner-area">
            <div class="container">
				<?php if($banner_style == 1) : ?>
					<div class="row align-items-center">
						<div class="col-lg-6 col-md-6">
							<div class="page-banner-content">
								<?php if( $custom_title == true && get_field( 'cus_pagetitle' ) != '' ) { ?>
									<h2><?php echo esc_html( get_field( 'cus_pagetitle' ) ); ?></h2>
								<?php } else { ?>
									<h2><?php the_title(); ?></h2>
								<?php } ?>

								<?php if( $hide_breadcrumb == false ) : ?>
									<?php if ( function_exists('yoast_breadcrumb') ) {
										yoast_breadcrumb( '<p class="rola-seo-breadcrumbs" id="breadcrumbs">','</p>' );
									} else { ?>
									<ul class="pages-list">
										<li><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'rola' ); ?></a></li>
										<li><?php the_title(); ?></li>
									</ul>
								<?php } endif; ?>
							</div>
						</div>

						<?php if( get_the_post_thumbnail_url() != '') : ?>
							<div class="col-lg-6 col-md-6">
								<div class="page-banner-image text-end">
									<img src="<?php echo esc_url( get_the_post_thumbnail_url() ); ?>" alt="<?php esc_attr_e( 'Image', 'rola' ); ?>">
								</div>
							</div>
						<?php endif; ?>

					</div>
				<?php else: ?>
					<div class="page-banner-content text-center">
						<?php if( $custom_title == true && get_field( 'cus_pagetitle' ) != '' ) { ?>
							<h2><?php echo esc_html( get_field( 'cus_pagetitle' ) ); ?></h2>
						<?php } else { ?>
							<h2><?php the_title(); ?></h2>
						<?php } ?>

						<?php if( $hide_breadcrumb == false ) : ?>
							<?php if ( function_exists('yoast_breadcrumb') ) {
								yoast_breadcrumb( '<p class="rola-seo-breadcrumbs" id="breadcrumbs">','</p>' );
							} else { ?>
							<ul class="pages-list">
								<li><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'rola' ); ?></a></li>
								<li><?php the_title(); ?></li>
							</ul>
						<?php } endif; ?>
					</div>
				<?php endif; ?>

            </div>
			<?php if( $page_shape1 != '') : ?>
				<div class="page-banner-shape-1">
					<img src="<?php echo esc_url( $page_shape1 ); ?> " alt="<?php esc_attr_e( 'Shape1', 'rola' ); ?>">
				</div>
			<?php endif; ?>
			<?php if( $page_shape2 != '') : ?>
				<div class="page-banner-shape-2">
					<img src="<?php echo esc_url( $page_shape2 ); ?> " alt="<?php esc_attr_e( 'Shape2', 'rola' ); ?>">
				</div>
			<?php endif; ?>
        </div>
	<?php } ?>

	<?php if( !rola_is_elementor() && 'product' != get_post_type() ): ?><div class="page-main-content"><?php endif; ?>
		<div class="page-area <?php echo esc_attr( $page_spac ); ?>">
			<?php if( !rola_is_elementor() && 'product' != get_post_type() ): ?><div class="container"><?php endif; ?>
				<?php while ( have_posts() ) : the_post(); ?>
					<?php $thecontent = get_the_content(); // If no content ?>
					<?php if(empty( $thecontent )) { ?> <div class="rola-single-blank-page"></div><?php } ?>
					<?php get_template_part( 'template-parts/content', 'page' ); ?>
					<?php if ( comments_open() || get_comments_number() ) : comments_template(); endif; // If comments are open or we have at least one comment, load up the comment template. ?>
				<?php endwhile; // End of the loop. ?>
			<?php if( !rola_is_elementor() && 'product' != get_post_type() ): ?></div><?php endif; ?>
		</div>
	<?php if( !rola_is_elementor() && 'product' != get_post_type() ): ?></div><?php endif; ?>

<?php get_footer();