<?php
/**
 * Rola functions and definitions
 * @package Rola
 */


/**
 * Shorthand contents for theme assets url
 */
define('ROLA_VERSION', time());
define('ROLA_THEME_URI', get_template_directory_uri());
define('ROLA_THEME_DIR', get_template_directory());
define('ROLA_IMG',ROLA_THEME_URI . '/assets/img');
define('ROLA_CSS',ROLA_THEME_URI . '/assets/css');
define('ROLA_JS',ROLA_THEME_URI . '/assets/js');
if( !defined('ROLA_FRAMEWORK_VAR') ) define('ROLA_FRAMEWORK_VAR', 'rola_opt');

/**
 * Sets up theme defaults and registers support for various WordPress features.
*/
if ( ! function_exists( 'rola_setup' ) ) :

	function rola_setup() {

		// Make theme available for translation.
		load_theme_textdomain( 'rola', ROLA_THEME_DIR. '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		// Let WordPress manage the document title.
		add_theme_support( 'title-tag' );

		// Enable support for Post Thumbnails on posts and pages.
		add_theme_support( 'post-thumbnails' );

		// Rola custom image size
		add_image_size( 'rola_standard_card', 860, 649, true );
		add_image_size( 'rola_services_card', 550, 500, true );
		add_image_size( 'rola_product_card', 670, 800, true );
		add_image_size( 'rola_services_card_two', 650, 650, true );
		add_image_size( 'rola_services_card_three', 195, 175, true );

		// WooCommerce support
		add_theme_support( 'woocommerce' );
		add_theme_support( 'wc-product-gallery-lightbox' );
		add_theme_support( 'wc-product-gallery-slider' );

		// Switch default core markup for search form, comment form, and comments
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		remove_theme_support( 'widgets-block-editor' );
	}
endif;
add_action( 'after_setup_theme', 'rola_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
*/
function rola_content_width() {
	// This variable is intended to be overruled from themes.
	$GLOBALS['content_width'] = apply_filters( 'rola_content_width', 640 );
}
add_action( 'after_setup_theme', 'rola_content_width', 0 );

/**
 * Enqueue scripts and styles.
 */
require ROLA_THEME_DIR . '/inc/enqueue.php';

if ( ! function_exists( 'rola_fonts' ) ) {
	function rola_fonts() {
		wp_enqueue_style( 'rola-fonts', "https://fonts.googleapis.com/css?family=Nunito+Sans:ital,wght@0,200;0,300;0,400;0,600;0,700;0,800;0,900;1,200;1,300;1,400;1,600;1,700;1,800;1,900|Heebo:wght@100,200,300,400,500,600,700,800,900&display=swap", '', '1.0.0', 'screen' );
	}
}
add_action( 'wp_enqueue_scripts', 'rola_fonts' );

/**
 * Custom template tags for this theme.
 */
require ROLA_THEME_DIR. '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require ROLA_THEME_DIR. '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require ROLA_THEME_DIR. '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require ROLA_THEME_DIR. '/inc/jetpack.php';
}

/**
 * Load bootstrap navwalker 
 */
require ROLA_THEME_DIR. '/inc/bootstrap-navwalker.php';

/**
 * Load theme widgets
 */
require ROLA_THEME_DIR. '/inc/widget.php';

/**
 * Custom style
 */
require ROLA_THEME_DIR. '/inc/custom-style.php';

/**
 * Social link
*/
require ROLA_THEME_DIR. '/inc/social-link.php';

/**
 * Theme Demo
 */
$pcs = trim( get_option( 'rola_purchase_code_status' ) );
if ( $pcs == 'valid' ) {
	require ROLA_THEME_DIR. '/inc/theme-demos.php';
}

/**
 * Recommended plugin
*/
require ROLA_THEME_DIR. '/lib/recommended-plugin.php';

/**
 * Theme's filters and actions
*/
require ROLA_THEME_DIR . '/inc/filter_actions.php';

// Load WooCommerce compatibility file.
if ( class_exists( 'WooCommerce' ) ) {
	require get_template_directory() . '/inc/woocommerce.php';
}


/**
 * Classes
 */
require get_template_directory() . '/inc/classes/Rola_base.php';
require get_template_directory() . '/inc/classes/Rola_rt.php';
require get_template_directory() . '/inc/classes/Rola_admin_page.php';
require get_template_directory() . '/inc/admin/dashboard/Rola_admin_dashboard.php';

/**
 * Admin dashboard style and scripts
 */
add_action( 'admin_enqueue_scripts', function() {
    global $pagenow;
    wp_enqueue_script( 'rola-admin', ROLA_JS .'/rola-admin.js', array('jquery'), '1.0.0', true );
    if ( $pagenow == 'admin.php' ) {
		wp_enqueue_style( 'rola-admin-dashboard', ROLA_CSS .'/admin-dashboard.min.css' );
    }
});

/**
 * Redirect after theme activation
 */
add_action( 'after_switch_theme', function() {
    if ( isset( $_GET['activated'] ) ) {
		wp_safe_redirect( admin_url('admin.php?page=rola') );
		update_option( 'rola_purchase_code_status', '', 'yes' );
		update_option( 'rola_purchase_code', '', 'yes' );
        exit;
	}
	update_option('notice_dismissed', '0');
});

/**
 * Notice dismiss handle
 */
add_action( 'admin_init', function() {
    if ( isset($_GET['dismissed']) && $_GET['dismissed'] == 1 ) {
        update_option('notice_dismissed', '1');
    }
});

add_action( 'admin_notices', 'rola_admin_notice' );
function rola_admin_notice() {
	$out = '<div class="notice notice-warning is-dismissible rola-plugin-purchase-notice"><p>'.esc_html( 'After importing demo data you need to register the theme again.' ).'</p></div>';
	if ( get_option('plugin_notice_dismissed') ) {
		return;
	}
	echo wp_kses_post($out);
}