<?php
/**
 * The archive file
 * @package rola
 */
get_header();

// Blog Sidebar
if( isset( $rola_opt['rola_blog_sidebar'] ) ) {
    if( $rola_opt['rola_blog_sidebar'] == 'rola_without_sidebar_center' ) :
        $rola_sidebar_class = 'col-lg-8 col-md-12 offset-lg-2';
    elseif( $rola_opt['rola_blog_sidebar'] == 'rola_without_sidebar' ) :
        $rola_sidebar_class = 'col-lg-12 col-md-12';
    else:
        if( is_active_sidebar( 'article-sidebar' ) ):
            $rola_sidebar_class = 'col-lg-8 col-md-12';
        else:
            $rola_sidebar_class = 'col-lg-8 col-md-12 offset-lg-2';
        endif;
    endif;
    $sidebar_hide           = $rola_opt['rola_blog_sidebar'];
    $hide_blog_banner       = $rola_opt['hide_blog_banner'];
    $hide_breadcrumb        = $rola_opt['hide_breadcrumb'];
} else {
    if( is_active_sidebar( 'article-sidebar' ) ):
        $rola_sidebar_class         = 'col-lg-8 col-md-12';
        $sidebar_hide = 'rola_with_sidebar_right';
    else:
        $rola_sidebar_class         = 'col-lg-8 col-md-12 offset-lg-2';
        $sidebar_hide                = 'rola_without_sidebar';
    endif;
    $hide_blog_banner = false;
    $hide_breadcrumb  = false;
}

// After Hiding Banner add spacing
if( $hide_blog_banner == true ) {
    $page_spac = 'mt-80';
} else {
    $page_spac = '';
}
$blog_link = get_permalink( get_option( 'page_for_posts' ));

$page_shape1         = !empty($rola_opt['page_shape1']['url']) ? $rola_opt['page_shape1']['url'] : '';
$page_shape2         = !empty($rola_opt['page_shape2']['url']) ? $rola_opt['page_shape2']['url'] : '';

?>

    <!-- Start Page Title Area -->
    <?php if( $hide_blog_banner == false ) : ?>
        <div class="page-banner-area">
            <div class="container">
                <div class="page-banner-content text-center">
                    <h2><?php the_archive_title(); ?></h2>
					<?php if( $hide_breadcrumb == false ) : ?>
						<ul class="pages-list">
                            <li><a href="<?php echo esc_url( $blog_link ); ?>"><?php esc_html_e( 'Blog', 'rola' ); ?></a></li>
                            <li><?php the_archive_title(); ?></li>
                            <?php if( get_the_archive_description() != '' ): ?>
                                <li><?php the_archive_description(); ?></li>
                            <?php endif; ?>
						</ul>
					<?php endif; ?>
                </div>
            </div>
            <?php if( $page_shape1 != '') : ?>
				<div class="page-banner-shape-1">
					<img src="<?php echo esc_url( $page_shape1 ); ?> " alt="<?php esc_attr_e( 'Shape1', 'rola' ); ?>">
				</div>
			<?php endif; ?>
			<?php if( $page_shape2 != '') : ?>
				<div class="page-banner-shape-2">
					<img src="<?php echo esc_url( $page_shape2 ); ?> " alt="<?php esc_attr_e( 'Shape2', 'rola' ); ?>">
				</div>
			<?php endif; ?>
        </div>
    <?php endif; ?>
    <!-- End Page Title Area -->

    <!-- Start Blog Area -->
    <div class="blog-area ptb-100 <?php echo esc_attr( $page_spac ); ?>">
        <div class="container">
            <div class="row">
                <?php if( $sidebar_hide == 'rola_with_sidebar_left' ): ?>
                    <?php get_sidebar(); ?>
                <?php endif; ?>
                <!-- Start Blog Content -->
                <div class="<?php echo esc_attr( $rola_sidebar_class ); ?>">
                    <?php
                    if ( have_posts() ) :
                        while ( have_posts() ) :
                            the_post();
                            get_template_part( 'template-parts/content', get_post_format());
                        endwhile;
                    else :
                        get_template_part( 'template-parts/content', 'none' );
                    endif;
                    ?>
                    <!-- Start Pagination -->
                    <?php rola_pagination(); ?>
                </div>
                
                <?php if( $sidebar_hide == 'rola_with_sidebar_right' ) : ?>
                    <?php get_sidebar(); ?>
                <?php endif; ?>
            </div>   
        </div>
    </div>
    <!-- End Blog Area -->
<?php
get_footer();
