<?php
/**
 * Skin Partner Area Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Rola_SkinPartner_Area extends Widget_Base {

	public function get_name() {
        return 'Rola_SkinPartner_Area';
    }

	public function get_title() {
        return esc_html__( 'Skin Partner Area', 'rola-toolkit' );
    }

	public function get_icon() {
        return 'eicon-info-box';
    }

	public function get_categories() {
        return [ 'rolacategory' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'rola_About_Area',
			[
				'label' => esc_html__( 'Partner Area', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );
            // Left Content
            $repeater_items = new Repeater();
            $repeater_items->add_control(
                'image',
                [
                    'label'  => esc_html__( 'Image', 'rola-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                ]
            );
            $repeater_items->add_control(
                'link',
                [
                    'label'  => esc_html__( 'Link URL', 'rola-toolkit' ),
                    'type'	 => Controls_Manager::TEXT,
                ]
            );
            $this->add_control(
                'rola_partner_items',
                [
                    'label'  => __( 'Add Partner Image', 'parco-toolkit' ),
                    'type'   => Controls_Manager::REPEATER,
                    'fields' => $repeater_items->get_controls(),
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Style', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
        );
            $this->add_control(
                'sec_bgcolor',
                [
                    'label'     => __( 'Section Background Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-partner-inner-box' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {

        $settings        = $this->get_settings_for_display();
        $partner_items   = $settings['rola_partner_items'];
    ?>
        <div class="skin-care-partner-area">
            <div class="container">
                <div class="skin-care-partner-inner-box">
                    <div class="skin-care-partner-slides owl-carousel owl-theme">
                    <?php foreach ( $partner_items as $item ) : ?>
                        <?php if( $item['image']['url'] != '' ) : ?>
                        <div class="skin-care-partner-card">
                            <a href="<?php echo esc_url( $item['link']); ?>">
                                <img src="<?php echo esc_url( $item['image']['url']); ?>" alt="<?php echo esc_attr__('image','rola-toolkit'); ?>">
                            </a>
                        </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
        <?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Rola_SkinPartner_Area );