<?php
/**
 * Services Widget
 */

namespace Elementor;
class Rola_Services extends Widget_Base {

	public function get_name() {
        return 'rolaServices_Area';
    }

	public function get_title() {
        return __( 'Services', 'rola-toolkit' );
    }

	public function get_icon() {
        return 'eicon-tools';
    }

	public function get_categories() {
        return [ 'rolacategory' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'services_section',
			[
				'label' => __( 'Services', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'choose_style',
                [
                    'label' => __( 'Choose Style', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'options' => [
                        '1'   => __( 'Style 1', 'rola-toolkit' ),
                        '2'   => __( 'Style 2', 'rola-toolkit' ),
                        '3'   => __( 'Style 3', 'rola-toolkit' ),
                        '4'   => __( 'Style 4', 'rola-toolkit' ),
                        '5'   => __( 'Style 5', 'rola-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );

            $this->add_control(
                'columns',
                [
                    'label' => __( 'Choose Columns', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'options' => [
                        '2'   => __( '2', 'rola-toolkit' ),
                        '3'   => __( '3', 'rola-toolkit' ),
                        '4'   => __( '4', 'rola-toolkit' ),
                    ],
                    'default' => '3',
                ]
            );

            $this->add_control(
                'header_size',
                [
                    'label' => __( 'Title Heading Tag', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                    'default' => 'h3',
                ]
            );

            $this->add_control(
                'order',
                [
                    'label'   => __( 'Services Order By', 'rola-toolkit' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'DESC'      => __( 'DESC', 'rola-toolkit' ),
                        'ASC'       => __( 'ASC', 'rola-toolkit' ),
                    ],
                    'default' => 'DESC',
                ]
            );

            $this->add_control(
                'count',
                [
                    'label'   => __( 'Post Per Page', 'rola-toolkit' ),
                    'type'    => Controls_Manager::NUMBER,
                    'default' => 6,
                ]
            );
            $this->add_control(
                'excerpt_num',
                [
                    'label'   => __( 'Excerpt', 'rola-toolkit' ),
                    'type'    => Controls_Manager::NUMBER,
                    'default' => 14,
                ]
            );

            $this->add_control(
                'cat_name',
                [
                    'label' => __( 'Choose Category', 'rola-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => rola_toolkit_get_page_services_cat_el(),
                ]
            );

            $this->add_control(
                'short_title',
                [
                    'label'   => __( 'Sub Title', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                    'condition' => [
                        'choose_style' => '4'
                    ]
                ]
            );
            $this->add_control(
				'pagination_show',
				[
					'label'        => __( 'Show Pagination?', 'rola-toolkit' ),
					'type'         => Controls_Manager::SWITCHER,
					'label_on'     => __( 'Show', 'rola-toolkit' ),
					'label_off'    => __( 'Hide', 'rola-toolkit' ),
					'return_value' => 'yes',
                    'default'      => 'no',
				]
            );

            $this->add_control(
                'read_more',
                [
                    'label'       => __( 'Read More Text', 'rola-toolkit' ),
                    'default'     => __( 'Read More', 'rola-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'condition' => [
                        'choose_style' => ['1','3','5'],
                    ]
                ]
            );
        $this->end_controls_section();
        
        // Style
        $this->start_controls_section(
			'service_style',
			[
				'label' => __( 'Style', 'rola-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
			]
        );
            $this->add_control(
                'title_color',
                [
                    'label'     => __( 'Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-services .services-content h3 a, .single-services .services-content h1 a, .single-services .services-content h2 a, .single-services .services-content h4 a, .single-services .services-content h5 a, .single-services .services-content h6 a, .single-gallery .content h3 a, .single-gallery .content h1 a, .single-gallery .content h2 a, .single-gallery .content h4 a, .single-gallery .content h5 a, .single-gallery .content h6 a, .single-services-with-image .services-content h3 a, .single-services-with-image .services-content h2 a, .single-services-with-image .services-content h1 a, .single-services-with-image .services-content h4 a, .single-services-with-image .services-content h5 a, .single-services-with-image .services-content h6 a, .single-services-box h3 a, .single-services-box h1 a, .single-services-box h2 a, .single-services-box h4 a, .single-services-box h5 a, .single-services-box h6 a, .single-services-item .services-content h3 a, .single-services-item .services-content h1 a, .single-services-item .services-content h2 a, .single-services-item .services-content h4 a, .single-services-item .services-content h5 a, .single-services-item .services-content h6 a' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'title_hcolor',
                [
                    'label'     => __( 'Title Hover Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-services:hover .services-content h3 a, .single-services:hover .services-content h1 a, .single-services:hover .services-content h2 a, .single-services:hover .services-content h4 a, .single-services:hover .services-content h5 a, .single-services:hover .services-content h6 a, .single-services-with-image:hover .services-content h3 a, .single-services-with-image:hover .services-content h1 a, .single-services-with-image:hover .services-content h2 a, .single-services-with-image:hover .services-content h4 a, .single-services-with-image:hover .services-content h5 a, .single-services-with-image:hover .services-content h6 a' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_style' => ['1','2'],
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'rola-toolkit' ),
                     
                    'selector' => '{{WRAPPER}} .single-services .services-content h3 a, .single-services .services-content h1 a, .single-services .services-content h2 a, .single-services .services-content h4 a, .single-services .services-content h5 a, .single-services .services-content h6 a, .single-gallery .content h3 a, .single-gallery .content h1 a, .single-gallery .content h2 a, .single-gallery .content h4 a, .single-gallery .content h5 a, .single-gallery .content h6 a, .single-services-with-image .services-content h3 a, .single-services-with-image .services-content h2 a, .single-services-with-image .services-content h1 a, .single-services-with-image .services-content h4 a, .single-services-with-image .services-content h5 a, .single-services-with-image .services-content h6 a, .single-services-box h3 a, .single-services-box h1 a, .single-services-box h2 a, .single-services-box h4 a, .single-services-box h5 a, .single-services-box h6 a, .single-services-item .services-content h3 a, .single-services-item .services-content h1 a, .single-services-item .services-content h2 a, .single-services-item .services-content h4 a, .single-services-item .services-content h5 a, .single-services-item .services-content h6 a',
                ]
            );
            $this->add_control(
                'content_color',
                [
                    'label'     => __( 'Excerpt Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-services .services-content p, .single-services .services-content ul li, .single-services .services-content ol li, .single-gallery .content span, .single-services-with-image .services-content p, .single-services-with-image .services-content ol li, .single-services-with-image .services-content ul li, .single-services-box p, .single-services-item .services-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'content_hcolor',
                [
                    'label'     => __( 'Excerpt Hover Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-services:hover .services-content p, .single-services:hover .services-content p ul li, .single-services:hover .services-content ol li, .single-services-with-image:hover .services-content p, .single-services-with-image:hover .services-content ol li, .single-services-with-image:hover .services-content ul li' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_style' => ['1','2'],
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-services .services-content p, .single-services .services-content ul li, .single-services .services-content ol li, .single-gallery .content span, .single-services-with-image .services-content p, .single-services-with-image .services-content ol li, .single-services-with-image .services-content ul li, .single-services-box p, .single-services-item .services-content p',
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {
        $settings = $this->get_settings_for_display();

        global $rola_opt;

        // Card Columns
        $columns = $settings['columns'];
        if ( $columns == '2' ) {
            $column = 'col-lg-6 col-sm-6';
        } elseif ( $columns == '3' ) {
            $column = 'col-lg-4 col-sm-6';
        } elseif ( $columns == '4' ) {
            $column = 'col-lg-3 col-sm-6';
        }
        
        // Services Query
        if( $settings['cat_name'] != '' ) {
            $args = array(
                'post_type'         => 'service',
                'posts_per_page'    => $settings['count'],
                'order'             => $settings['order'],
                'paged'             => get_query_var('paged') ? get_query_var('paged') : 1,
                'tax_query'         => array(
                    array(
                        'taxonomy'      => 'service_cat',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false,
                    )
                )
            );
        } else {
            $args = array(
                'post_type'           => 'service',
                'posts_per_page'      => $settings['count'],
                'order'               => $settings['order'],
                'paged'               => get_query_var('paged') ? get_query_var('paged') : 1
            );
        }
        $services_array = new \WP_Query( $args );
        ?>

        <?php if ( $settings['choose_style'] == '1' ) : ?>
            <div class="container">
                <div class="row">
                    <?php while( $services_array->have_posts() ): 
                    $services_array->the_post();
                    if ( class_exists('ACF') ) {
                        if ( get_field('choose_link_type') == 1 ) {
                            $post_link = get_the_permalink();
                        } else {
                            $post_link = get_field('external_link');
                        }
                        $icon = get_field('service_icon');
                    } else {
                        $post_link = get_field('external_link');
                        $icon      = '';
                    } ?>

                        <div class="<?php echo esc_attr( $column ); ?>">
                            <div class="single-services">
                                <?php if( get_the_post_thumbnail_url() != '') : ?>
                                    <div class="services-image">
                                        <a href="<?php echo esc_url( $post_link ); ?>">
                                            <img src="<?php the_post_thumbnail_url('rola_services_card') ?>" alt="<?php the_title_attribute(); ?>">
                                        </a>

                                        <?php if($icon != '') : ?>
                                            <div class="icon">
                                                <a href="<?php echo esc_url( $post_link ); ?>"><i class="<?php echo esc_attr( $icon ); ?>"></i></a>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>

                                <div class="services-content">
                                    <<?php echo esc_attr( $settings['header_size'] ); ?>>
                                        <a href="<?php echo esc_url( $post_link ); ?>">
                                            <?php the_title(); ?>
                                        </a>
                                    </<?php echo esc_attr( $settings['header_size'] ); ?>>

                                    <p><?php echo esc_html(wp_trim_words( get_the_excerpt(), $settings['excerpt_num'], '' )); ?></p>

                                    <?php if( $settings['read_more'] != '' ) : ?>
                                    <a href="<?php the_permalink(); ?>" class="services-btn"><?php echo esc_html( $settings['read_more'] ); ?></a>
                                    <?php endif; ?>

                                </div>
                            </div>

                        </div>

                    <?php endwhile;
                    wp_reset_postdata(); ?>

                    <?php if ( $settings['pagination_show'] == 'yes' ) { ?>
                        <div class="col-lg-12 col-md-12">
                            <div class="pagination-area">
                                <nav aria-label="navigation" class="nav-links">
                                <?php 
                                $big = 999999999; // need an unlikely integer
                                echo paginate_links( array(
                                    'base' => str_replace( $big, '%#%', get_pagenum_link( $big ) ),
                                    'format' => '?paged=%#%',
                                    'current' => max(1, get_query_var('paged') ),
                                    'total' => $services_array->max_num_pages,
                                    'prev_text' => '<i class="bx bx-left-arrow-alt"></i>',
                                    'next_text' => '<i class="bx bx-right-arrow-alt"></i>',
                                ) ); ?>  
                                </nav>
                            </div>
                        </div>
                    <?php } ?>

                </div>
            </div>
        <?php elseif ( $settings['choose_style'] == '2' ) : ?>
            <div class="container">
                <div class="row">
                    <?php while( $services_array->have_posts() ): 
                    $services_array->the_post();
                    if ( class_exists('ACF') ) {
                        if ( get_field('choose_link_type') == 1 ) {
                            $post_link = get_the_permalink();
                        } else {
                            $post_link = get_field('external_link');
                        }
                        $icon = get_field('service_icon');
                    } else {
                        $post_link = get_field('external_link');
                        $icon      = '';
                    } ?>

                        <div class="<?php echo esc_attr( $column ); ?>">
                            <div class="single-services-with-image">
                                <div class="services-image">
                                    <a href="<?php echo esc_url( $post_link ); ?>">
                                        <img src="<?php the_post_thumbnail_url('rola_services_card') ?>" alt="<?php the_title_attribute(); ?>">
                                    </a>
                                  
                                    <?php if($icon != '') : ?>
                                        <div class="icon">
                                            <a href="<?php echo esc_url( $post_link ); ?>"><i class="<?php echo esc_attr( $icon ); ?>"></i></a>
                                        </div>
                                    <?php endif; ?>
                                </div>

                                <div class="services-content">
                                    <<?php echo esc_attr( $settings['header_size'] ); ?>>
                                        <a href="<?php echo esc_url( $post_link ); ?>">
                                            <?php the_title(); ?>
                                        </a>
                                    </<?php echo esc_attr( $settings['header_size'] ); ?>>

                                    <p><?php echo esc_html(wp_trim_words( get_the_excerpt(), $settings['excerpt_num'], '' )); ?></p>
                                </div>
                            </div>
                        </div>
                    <?php endwhile;
                    wp_reset_postdata(); ?>

                    <?php if ( $settings['pagination_show'] == 'yes' ) { ?>
                        <div class="col-lg-12 col-md-12">
                            <div class="pagination-area">
                                <nav aria-label="navigation" class="nav-links">
                                <?php 
                                $big = 999999999; // need an unlikely integer
                                echo paginate_links( array(
                                    'base' => str_replace( $big, '%#%', get_pagenum_link( $big ) ),
                                    'format' => '?paged=%#%',
                                    'current' => max(1, get_query_var('paged') ),
                                    'total' => $services_array->max_num_pages,
                                    'prev_text' => '<i class="bx bx-left-arrow-alt"></i>',
                                    'next_text' => '<i class="bx bx-right-arrow-alt"></i>',
                                ) ); ?>  
                                </nav>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        <?php elseif ( $settings['choose_style'] == '3' ) : ?>
            <div class="container">
                <div class="row">
                    <?php while( $services_array->have_posts() ): 
                    $services_array->the_post();
                    if ( class_exists('ACF') ) {
                        if ( get_field('choose_link_type') == 1 ) {
                            $post_link = get_the_permalink();
                        } else {
                            $post_link = get_field('external_link');
                        }
                        $icon = get_field('service_icon');
                    } else {
                        $post_link = get_field('external_link');
                        $icon      = '';
                    } ?>

                        <div class="<?php echo esc_attr( $column ); ?>">
                            <div class="single-services-box">
                                <?php if($icon != '') : ?>
                                    <div class="icon">
                                        <a href="<?php echo esc_url( $post_link ); ?>"><i class="<?php echo esc_attr( $icon ); ?>"></i></a>
                                    </div>
                                <?php endif; ?>
                                <<?php echo esc_attr( $settings['header_size'] ); ?>>
                                    <a href="<?php echo esc_url( $post_link ); ?>">
                                        <?php the_title(); ?>
                                    </a>
                                </<?php echo esc_attr( $settings['header_size'] ); ?>>
                                <p><?php echo esc_html(wp_trim_words( get_the_excerpt(), $settings['excerpt_num'], '' )); ?></p>

                                <?php if( $settings['read_more'] != '' ) : ?>
                                    <a href="<?php the_permalink(); ?>" class="services-btn"><?php echo esc_html( $settings['read_more'] ); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endwhile;
                    wp_reset_postdata(); ?>
                </div>
            </div>
        <?php elseif ( $settings['choose_style'] == '4' ) : ?>
            <div class="container">
                <div class="row justify-content-center">
                    <?php while( $services_array->have_posts() ): 
                        $services_array->the_post();

                        if ( class_exists('ACF') ) {
                            if ( get_field('choose_link_type') == 1 ) {
                                $post_link = get_the_permalink();
                            } else {
                                $post_link = get_field('external_link');
                            }

                            $icon = get_field('service_icon');
                        } else {
                            $post_link = get_field('external_link');
                            $icon      = '';
                        }
                    ?>
                    <div class="<?php echo esc_attr( $column ); ?>">
                        <div class="single-gallery">
                            <img src="<?php the_post_thumbnail_url('rola_services_card') ?>" alt="<?php the_title_attribute(); ?>">

                            <div class="content">

                                <<?php echo esc_attr( $settings['header_size'] ); ?>>
                                    <a href="<?php echo esc_url( $post_link ); ?>">
                                        <?php the_title(); ?>
                                    </a>
                                </<?php echo esc_attr( $settings['header_size'] ); ?>>

                                <?php if($settings['short_title'] != ''): ?>
                                    <span><?php echo esc_html($settings['short_title']); ?></span>
                                <?php else: ?>
                                    <span><?php echo esc_html(wp_trim_words( get_the_excerpt(), $settings['excerpt_num'], '' )); ?></span>
                                <?php endif; ?>

                                <?php //if($icon != '') : ?>
                                    <!--
                                    <div class="icon">
                                        <a href="<?php //echo esc_url( $post_link ); ?>"><i class="<?php //echo esc_attr( $icon ); ?>"></i></a>
                                    </div>
                                    -->
                                <?php //endif; ?>

                                <div class="icon">
                                    <a href="<?php echo esc_url( $post_link ); ?>"><i class="bx bx-right-arrow-alt"></i></a>
                                </div>


                            </div>
                        </div>
                    </div>
                    <?php endwhile;
                    wp_reset_postdata(); ?>

                </div>
            </div>
        <?php elseif ( $settings['choose_style'] == '5' ) : ?>
            <div class="container">
                <div class="row">
                    <?php while( $services_array->have_posts() ): 
                    $services_array->the_post();
                    if ( class_exists('ACF') ) {
                        if ( get_field('choose_link_type') == 1 ) {
                            $post_link = get_the_permalink();
                        } else {
                            $post_link = get_field('external_link');
                        }
                        $icon = get_field('service_icon');
                    } else {
                        $post_link = get_field('external_link');
                        $icon      = '';
                    } ?>
                        <div class="<?php echo esc_attr( $column ); ?>">
                            <div class="single-services-item">
                                <div class="services-image">
                                    <a href="<?php echo esc_url( $post_link ); ?>">
                                        <img src="<?php the_post_thumbnail_url('rola_services_card') ?>" alt="<?php the_title_attribute(); ?>">
                                    </a>

                                    <?php if($icon != '') : ?>
                                        <div class="icon">
                                            <a href="<?php echo esc_url( $post_link ); ?>"><i class="<?php echo esc_attr( $icon ); ?>"></i></a>
                                        </div>
                                    <?php endif; ?>
                                </div>

                                <div class="services-content">
                                    <<?php echo esc_attr( $settings['header_size'] ); ?>>
                                        <a href="<?php echo esc_url( $post_link ); ?>">
                                            <?php the_title(); ?>
                                        </a>
                                    </<?php echo esc_attr( $settings['header_size'] ); ?>>

                                   <p><?php echo esc_html(wp_trim_words( get_the_excerpt(), $settings['excerpt_num'], '' )); ?></p>

                                   <?php if( $settings['read_more'] != '' ) : ?>
                                        <a href="<?php the_permalink(); ?>" class="default-btn"><?php echo esc_html( $settings['read_more'] ); ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endwhile;
                    wp_reset_postdata(); ?>

                </div>
            </div>

        <?php endif; ?>   
        <?php
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Rola_Services );