<?php namespace Elementor;

class RolaEyeCareFeature extends Widget_Base{
    public function get_name(){
        return "rola_EyeCare_Feature";
    }
    public function get_title(){
        return "Eye Care Feature";
    }
    public function get_icon(){
        return "eicon-plus-square";
    }
    public function get_categories(){
        return ['rolacategory'];
    }

    protected function register_controls(){

        $this-> start_controls_section(
            'tfeature_content',
            [
                'label' => esc_html__('Eye Care Feature', 'rola-toolkit'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'columns',
            [
                'label' => __( 'Choose Columns', 'rola-toolkit' ),
                'type'  => Controls_Manager::SELECT,
                'options' => [
                    '2'   => __( '2', 'rola-toolkit' ),
                    '3'   => __( '3', 'rola-toolkit' ),
                    '4'   => __( '4', 'rola-toolkit' ),
                ],
                'default' => '3',
            ]
        );
        $repeater = new Repeater();
        $repeater->add_control(
            'image',
            [
                'label'  => esc_html__( 'Image', 'rola-toolkit' ),
                'type'	 => Controls_Manager::MEDIA,
            ]
        );
        $repeater->add_control(
            'info_title',
            [
                'label' => esc_html__( 'Title', 'rola-toolkit' ),
                'type'  => Controls_Manager::TEXT,
            ]
        );
        $repeater->add_control(
            'info_content',
            [
                'label' => esc_html__( 'Content', 'rola-toolkit' ),
                'type'  => Controls_Manager::TEXTAREA,
            ]
        );
        $this->add_control(
            'tfeature_list',
            [
                'label'  => esc_html__( 'Add Feature', 'rola-toolkit' ),
                'type'   => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );
        $this-> end_controls_section();

        // Start Feature Style
        $this-> start_controls_section(
            'contact_style',
            [
                'label' => esc_html__('Content', 'rola-toolkit'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'info_title_color',
                [
                    'label' => esc_html__( 'Title Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-features-card .features-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'info_title_typography',
                    'label'    => esc_html__( 'Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .eye-care-features-card .features-content h3',
                ]
            );
            $this->add_control(
                'info_con_color',
                [
                    'label' => esc_html__( 'Content Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-features-card .features-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'info_con_typography',
                    'label'    => esc_html__( 'Content Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .eye-care-features-card .features-content p',
                ]
            );
        $this-> end_controls_section();
        
    }

    protected function render() 
    {
        $settings = $this->get_settings_for_display();

        // Card Columns
        $columns = $settings['columns'];
        if ( $columns == '2' ) {
            $column = 'col-lg-6 col-md-6';
        } elseif ( $columns == '3' ) {
            $column = 'col-lg-4 col-md-4';
        } elseif ( $columns == '4' ) {
            $column = 'col-lg-3 col-md-4';
        }
        ?>
        <div class="eye-care-features-area pt-100 pb-75">
            <div class="container">
                <div class="row justify-content-center">
                    <?php foreach( $settings['tfeature_list'] as $item ) : ?>
                        <div class="<?php echo $column; ?>">
                            <div class="eye-care-features-card">
                                <?php if($item['image']['url'] !='') : ?>
                                    <div class="features-image">
                                        <img src="<?php echo esc_url( $item['image']['url'] ); ?>" alt="<?php echo esc_attr__('image', 'rola-toolkit'); ?>">
                                    </div>
                                <?php endif; ?>

                                <div class="features-content">
                                    <h3> <?php echo esc_html($item['info_title']); ?> </h3>
                                    <p><?php echo wp_kses_post($item['info_content']); ?></p>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    <?php    
    }

}
Plugin::instance()->widgets_manager->register_widget_type( new RolaEyeCareFeature );