<?php
/**
 * Skin Care About Area Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Rola_SkinCareAbout_Area extends Widget_Base {

	public function get_name() {
        return 'Rola_SC_About_Area';
    }

	public function get_title() {
        return esc_html__( 'Skin Care About Area', 'rola-toolkit' );
    }

	public function get_icon() {
        return 'eicon-info-box';
    }

	public function get_categories() {
        return [ 'rolacategory' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'rola_About_Area',
			[
				'label' => esc_html__( 'About Area', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'image',
                [
                    'label'  => esc_html__( 'Image', 'rola-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                ]
            );
            // Right Content
            $repeater_items = new Repeater();
            $repeater_items->add_control(
                'ff_number',
                [
                    'label'       => __(' Funfact Number', 'rola-toolkit'),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => '20',
                    'label_block' => true,
                ]
            );
            $repeater_items->add_control(
                'ff_symbol',
                [
                    'label'       => __(' Funfact Symbol', 'rola-toolkit'),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => '+',
                    'label_block' => true,
                ]
            );
            $repeater_items->add_control(
                'ff_title',
                [
                    'label'       => __(' Funfact Title', 'rola-toolkit'),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => __('Free Shipping', 'rola-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'rola_left_items',
                [
                    'label'  => __( 'Add Left Funfact', 'rola-toolkit' ),
                    'type'   => Controls_Manager::REPEATER,
                    'fields' => $repeater_items->get_controls(),
                ]
            );

            $this->add_control(
                'top_icon',
                [
                    'label'      => __( 'Icon', 'rola-toolkit' ),
                    'type' 	     => Controls_Manager::SELECT,
                    'options'    => rola_icons(),
                ]
            );
            $this->add_control(
                'top_title',
                [
                    'label'   => esc_html__( 'Top Title', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                ]
            );
            $this->add_control(
                'title',
                [
                    'label'   => esc_html__( 'Title', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXTAREA,
                ]
            );
            $this->add_control(
                'sec_desc',
                [
                    'label' => esc_html__( 'Description', 'rola-toolkit' ),
                    'type'  => Controls_Manager::TEXTAREA,
                ]
            );

            // Style 4 Button
            $this->add_control(
                'button_one_text',
                [
                    'label' => __('Button Text', 'rola-toolkit'),
                    'type'  => Controls_Manager:: TEXT,
                ]
            );
            $this->add_control(
                'link_type',
                [
                    'label' => __( 'Link Type', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        '1'   => __( 'Link To Page', 'rola-toolkit' ),
                        '2'   => __( 'External Link', 'rola-toolkit' ),
                    ],
                ]
            );
            $this->add_control(
                'link_to_page',
                [
                    'label' => __( 'Link Page', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options'     => rola_toolkit_get_page_as_list(),
                    'condition'   => [
                        'link_type'   => '1',
                    ]
                ]
            );
            $this->add_control(
                'external_link',
                [
                    'label' => __('External Link', 'rola-toolkit'),
                    'type'  => Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type'   => '2',
                    ]
                ]
            );
            // Contact Number
            $this->add_control(
                'con_num',
                [
                    'label' => __('Contact Number', 'rola-toolkit'),
                    'type'  => Controls_Manager:: TEXT,
                ]
            );
            $this->add_control(
                'con_link',
                [
                    'label' => __('Contact Link', 'rola-toolkit'),
                    'type'  => Controls_Manager:: TEXT,
                ]
            );
            $this->add_control(
                'con_icon',
                [
                    'label'      => __( 'Contact Icon', 'rola-toolkit' ),
                    'type' 	     => Controls_Manager::SELECT,
                    'options'    => rola_icons(),
                ]
            );
        $this->end_controls_section();

        // Style
        $this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'rola-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_control(
                'faq_bg_color',
                [
                    'label'     => __( 'FAQ Background Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-about-image .skin-care-fun-fact' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'faq_num_color',
                [
                    'label'     => __( 'FAQ Number Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-about-image .skin-care-fun-fact .fun-fact h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'faq_title_color',
                [
                    'label'     => __( 'FAQ Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-about-image .skin-care-fun-fact .fun-fact p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'top_title_color',
                [
                    'label'     => __( 'Top Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-about-content span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'top_title_icolor',
                [
                    'label'     => __( 'Top Title Icon Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-about-content span i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'top_title_typography',
                    'label'    => __( 'Top Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .skin-care-about-content span',
                ]
            );

            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-about-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => esc_html__( 'Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .skin-care-about-content h3',
                ]
            );

            $this->add_control(
                'desc_color',
                [
                    'label' => esc_html__( 'Description Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-about-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'desc_typography',
                    'label'    => esc_html__( 'Description Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .skin-care-about-content p',
                ]
            );
            
            $this->add_control(
                'button_color',
                [
                    'label' => esc_html__( 'Button Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-about-content .about-btn-with-info li .default-btn' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_bgcolor',
                [
                    'label' => esc_html__( 'Button Background Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-about-content .about-btn-with-info li .default-btn' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => esc_html__( 'Button Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}}  .skin-care-about-content .about-btn-with-info li .default-btn',
                ]
            );

            $this->add_control(
                'con_numcolor',
                [
                    'label' => esc_html__( 'Contact Number Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-about-content .about-btn-with-info li a' => 'color: {{VALUE}}',
                    ],
                ]
            );
           
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'num_typography',
                    'label'    => esc_html__( 'Number Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .skin-care-about-content .about-btn-with-info li a',
                ]
            );
            $this->add_control(
                'con_numicolor',
                [
                    'label' => esc_html__( 'Contact Icon Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-about-content .about-btn-with-info li i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'con_numibgcolor',
                [
                    'label' => esc_html__( 'Contact Icon Background Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-about-content .about-btn-with-info li i' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {

        $settings    = $this->get_settings_for_display();
        $left_items  = $settings['rola_left_items'];

        // Button link
        $con_num    = $settings['con_num'];
        $con_link   = $settings['con_link'];
        $con_icon   = $settings['con_icon'];

        $btn1_text  = $settings['button_one_text'];

        $link_one = '';
        if( $settings['link_type'] == 1 ){
            $link_one = get_page_link($settings['link_to_page']); 
        } else {
            $link_one = $settings['external_link'];
        }
    ?>
        <div class="skin-care-about-area pb-100">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6 col-md-12">
                        <div class="skin-care-about-image">
                            <?php if( $settings['image']['url'] != '' ) : ?>
                                <img src="<?php echo esc_url( $settings['image']['url'] ); ?>" alt="<?php echo esc_attr__('image', 'rola-toolkit'); ?>">
                            <?php endif; ?>

                            <?php if( $left_items): ?>
                            <div class="skin-care-fun-fact">
                                <div class="row justify-content-center">
                                    <?php foreach ( $left_items as $item ) : ?>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-6">
                                        <div class="fun-fact">
                                            <h3>
                                                <span class="odometer" data-count="<?php echo esc_attr( $item['ff_number'] ); ?>">00</span>
                                                <span class="small-text"><?php echo esc_html( $item['ff_symbol'] ); ?></span>
                                            </h3>
                                            <p><?php echo esc_html( $item['ff_title'] ); ?></p>
                                        </div>
                                    </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="col-lg-6 col-md-12">
                        <div class="skin-care-about-content">
                            <?php if( $settings['top_title'] != '' ) : ?>
                                <span class="sub-title">
                                    <i class="<?php echo esc_attr( $settings['top_icon'] ); ?>"></i>
                                    <?php echo esc_html( $settings['top_title'] ); ?>
                                </span>
                            <?php endif; ?>
                            <?php if( $settings['title'] != '' ) : ?>
                                <h3><?php echo wp_kses_post( $settings['title'] ); ?></h3>
                            <?php endif; ?>
                            <p><?php echo wp_kses_post( $settings['sec_desc'] ); ?></p>

                            <ul class="about-btn-with-info">
                                <?php if($btn1_text != ''): ?>
                                <li>
                                    <a href="<?php echo esc_url(  $link_one ); ?>" class="default-btn"><?php echo esc_html(  $btn1_text ); ?></a>
                                </li>
                                <?php endif; ?>

                                <?php if($con_num != ''): ?>
                                <li>
                                    <i class='<?php echo esc_attr(  $con_icon ); ?>'></i>
                                    <a href="<?php echo esc_url(  $con_link ); ?>"><?php echo esc_html(  $con_num ); ?></a>
                                </li>
                                <?php endif; ?>
                            </ul>

                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Rola_SkinCareAbout_Area );