<?php
/**
 * FAQ Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Rola_Faq extends Widget_Base {

	public function get_name() {
        return 'Rola_Faq';
    }

	public function get_title() {
        return __( 'FAQ', 'rola-toolkit' );
    }

	public function get_icon() {
        return 'eicon-help-o';
    }

	public function get_categories() {
        return [ 'rolacategory' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Rola_Faq',
			[
				'label' => __( 'FAQ Control', 'rola-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

            $repeater = new Repeater();
            $repeater->add_control(
                'faq_title', [
                    'label' => __( 'FAQ Title', 'rola-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                ]
            );
            $repeater->add_control(
                'faq_desc',
                [
                    'label'=>__('FAQ Description', 'rola-toolkit'),
                    'type'=>Controls_Manager:: TEXTAREA,
                ]
            );
            $this->add_control(
                'faq_items',
                [
                    'label' => esc_html__('FAQ Items', 'rola-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                ]
            );
       
        $this->end_controls_section();

        $this->start_controls_section(
			'faq_style',
			[
				'label' => __( 'Style', 'rola-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
            'f_title_color',
            [
                'label' => __( 'FAQ Title Color', 'rola-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-accordion .accordion .accordion-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'f_title_typography',
				'label' => __( 'FAQ Title Typography', 'rola-toolkit' ),
                'selector' => '{{WRAPPER}} .faq-accordion .accordion .accordion-title',
			]
        );

        $this->add_control(
            'f_desc_color',
            [
                'label' => __( 'FAQ Description Color', 'rola-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-accordion .accordion .accordion-content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'f_desc_typography',
				'label' => __( 'FAQ Description Typography', 'rola-toolkit' ),
                'selector' => '{{WRAPPER}} .faq-accordion .accordion .accordion-content p',
			]
        );

        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        ?>
        <div class="container">
            <div class="faq-accordion">
                <div class="accordion">
                    <?php $i = 1;
                        foreach( $settings['faq_items'] as $item ): 
                            // Active Class
                            if($i == 1) {
                                $show   = 'show';
                                $act = 'active';
                            } else {
                                $show   = '';
                                $act = '';
                            }
                        ?>
                        <div class="accordion-item">
                            <div class="accordion-title <?php echo esc_attr($act); ?>">
                                <i class='bx bx-plus'></i>
                                <?php echo esc_html( $item['faq_title'] ); ?>
                            </div>

                            <div class="accordion-content <?php echo esc_attr($show); ?>">
                                <p> <?php echo wp_kses_post( $item['faq_desc'] ); ?></p>
                            </div>
                        </div>
                    <?php $i++; endforeach; ?>
                </div>
            </div>
        </div>

        <?php
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Rola_Faq );