<?php
/**
 * Eye Care About Area Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Rola_eyeCareAbout_Area extends Widget_Base {

	public function get_name() {
        return 'Rola_EC_About_Area';
    }

	public function get_title() {
        return esc_html__( 'Eye Care About Area', 'rola-toolkit' );
    }

	public function get_icon() {
        return 'eicon-info-box';
    }

	public function get_categories() {
        return [ 'rolacategory' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'rola_About_Area',
			[
				'label' => esc_html__( 'About Area', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'image',
                [
                    'label'  => esc_html__( 'Image', 'rola-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'top_icon',
                [
                    'label'      => __( 'Icon', 'rola-toolkit' ),
                    'type' 	     => Controls_Manager::SELECT,
                    'options'    => rola_icons(),
                ]
            );
            $this->add_control(
                'top_title',
                [
                    'label'   => esc_html__( 'Top Title', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                ]
            );
            $this->add_control(
                'title',
                [
                    'label'   => esc_html__( 'Title', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXTAREA,
                ]
            );
            $this->add_control(
                'sec_desc',
                [
                    'label' => esc_html__( 'Description', 'rola-toolkit' ),
                    'type'  => Controls_Manager::TEXTAREA,
                ]
            );
            // Right Content
            $repeater_items = new Repeater();
            $repeater_items->add_control(
                'fea_icon',
                [
                    'label'      => __( 'Icon', 'rola-toolkit' ),
                    'type' 	     => Controls_Manager::SELECT,
                    'options'    => rola_icons(),
                ]
            );
            $repeater_items->add_control(
                'fea_title',
                [
                    'label'       => __('Feature Title', 'rola-toolkit'),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => __('Free Shipping', 'rola-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'rola_fea_items',
                [
                    'label'  => __( 'Add Feature Lists', 'rola-toolkit' ),
                    'type'   => Controls_Manager::REPEATER,
                    'fields' => $repeater_items->get_controls(),
                ]
            );

            // Style 4 Button
            $this->add_control(
                'button_one_text',
                [
                    'label' => __('Button Text', 'rola-toolkit'),
                    'type'  => Controls_Manager:: TEXT,
                ]
            );
            $this->add_control(
                'link_type',
                [
                    'label' => __( 'Link Type', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        '1'   => __( 'Link To Page', 'rola-toolkit' ),
                        '2'   => __( 'External Link', 'rola-toolkit' ),
                    ],
                ]
            );
            $this->add_control(
                'link_to_page',
                [
                    'label' => __( 'Link Page', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options'     => rola_toolkit_get_page_as_list(),
                    'condition'   => [
                        'link_type'   => '1',
                    ]
                ]
            );
            $this->add_control(
                'external_link',
                [
                    'label' => __('External Link', 'rola-toolkit'),
                    'type'  => Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type'   => '2',
                    ]
                ]
            );
        $this->end_controls_section();

        // Style
        $this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'rola-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );
            $this->add_control(
                'top_title_color',
                [
                    'label'     => __( 'Top Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-about-content span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'top_title_icolor',
                [
                    'label'     => __( 'Top Title Icon Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-about-content span i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'top_title_typography',
                    'label'    => __( 'Top Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .eye-care-about-content span',
                ]
            );

            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-about-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => esc_html__( 'Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .eye-care-about-content h3',
                ]
            );

            $this->add_control(
                'desc_color',
                [
                    'label' => esc_html__( 'Description Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-about-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'desc_typography',
                    'label'    => esc_html__( 'Description Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .eye-care-about-content p',
                ]
            );
            $this->add_control(
                'list_icolor',
                [
                    'label' => esc_html__( 'List icon Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-about-content .list li i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'list_ibgcolor',
                [
                    'label' => esc_html__( 'List icon Background Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-about-content .list li i' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'list_titlecolor',
                [
                    'label' => esc_html__( 'List Title Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-about-content .list li' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'listt_typography',
                    'label'    => esc_html__( 'List Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .eye-care-about-content .list li',
                ]
            );
            
            $this->add_control(
                'button_color',
                [
                    'label' => esc_html__( 'Button Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}}  .default-btn' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_bgcolor',
                [
                    'label' => esc_html__( 'Button Background Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-about-content .about-btn .default-btn' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_hcolor',
                [
                    'label' => esc_html__( 'Button Hover Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}}  .default-btn:hover' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_hbgcolor',
                [
                    'label' => esc_html__( 'Button Hover Background Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .default-btn:hover:before, .eye-care-about-content .about-btn .default-btn:hover' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => esc_html__( 'Button Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .default-btn',
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {

        $settings    = $this->get_settings_for_display();
        $fea_items  = $settings['rola_fea_items'];

        $btn1_text  = $settings['button_one_text'];

        $link_one = '';
        if( $settings['link_type'] == 1 ){
            $link_one = get_page_link($settings['link_to_page']); 
        } else {
            $link_one = $settings['external_link'];
        }
    ?>
        <div class="eye-care-about-area pb-100">
            <div class="container">
                <div class="row align-items-center">
                    <?php if( $settings['image']['url'] != '' ) : ?>
                    <div class="col-lg-6 col-md-12">
                        <div class="eye-care-about-image">
                            <img src="<?php echo esc_url( $settings['image']['url'] ); ?>" alt="<?php echo esc_attr__('image', 'rola-toolkit'); ?>">
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-12">
                    <?php else: ?>
                    <div class="col-lg-12 col-md-12">
                    <?php endif; ?>
                        <div class="eye-care-about-content">
                            <?php if( $settings['top_title'] != '' ) : ?>
                                <span class="sub-title">
                                    <i class="<?php echo esc_attr( $settings['top_icon'] ); ?>"></i>
                                    <?php echo esc_html( $settings['top_title'] ); ?>
                                </span>
                            <?php endif; ?>
                            <?php if( $settings['title'] != '' ) : ?>
                                <h3><?php echo wp_kses_post( $settings['title'] ); ?></h3>
                            <?php endif; ?>
                            <p><?php echo wp_kses_post( $settings['sec_desc'] ); ?></p>

                            <ul class="list">
                                <?php foreach ( $fea_items as $item ) : ?>
                                    <li><i class='<?php echo esc_attr( $item['fea_icon'] ); ?>'></i> <?php echo esc_html( $item['fea_title'] ); ?></li>
                                <?php endforeach; ?>
                            </ul>
                            <?php if($btn1_text != ''): ?>
                                <div class="about-btn">
                                    <a href="<?php echo esc_url(  $link_one ); ?>" class="default-btn"><?php echo esc_html(  $btn1_text ); ?></a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Rola_eyeCareAbout_Area );