<?php namespace Elementor;

class RolaContactInfo extends Widget_Base{
    public function get_name(){
        return "rolacontactInfo";
    }
    public function get_title(){
        return "Contact Info";
    }
    public function get_icon(){
        return "eicon-form-horizontal";
    }
    public function get_categories(){
        return ['rolacategory'];
    }

    protected function register_controls(){

        $this-> start_controls_section(
            'contact_info_content',
            [
                'label' => esc_html__('Contact Information', 'rola-toolkit'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'columns',
            [
                'label' => __( 'Choose Columns', 'rola-toolkit' ),
                'type'  => Controls_Manager::SELECT,
                'options' => [
                    '2'   => __( '2', 'rola-toolkit' ),
                    '3'   => __( '3', 'rola-toolkit' ),
                    '4'   => __( '4', 'rola-toolkit' ),
                ],
                'default' => '4',
            ]
        );
        $repeater = new Repeater();
        $repeater->add_control(
            'icon',
            [
                'label'      => __( 'Icon', 'teciva-toolkit' ),
                'type' 	     => Controls_Manager::SELECT,
                'options'    => rola_icons(),
            ]
        );
        $repeater->add_control(
            'info_title',
            [
                'label' => esc_html__( 'Title', 'rola-toolkit' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $repeater->add_control(
            'info_content',
            [
                'label' => esc_html__( 'Content', 'rola-toolkit' ),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
        $this->add_control(
            'contact_item_list',
            [
                'label' => esc_html__( 'Add Contact Info', 'rola-toolkit' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this-> end_controls_section();
        // End Contact Controls

        // Start Contact Style
        $this-> start_controls_section(
            'contact_style',
            [
                'label' => esc_html__('Content', 'rola-toolkit'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'info_title_color',
                [
                    'label' => esc_html__( 'Title Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-contact-info-card h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'info_title_typography',
                    'label'    => esc_html__( 'Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-contact-info-card h3',
                ]
            );
            $this->add_control(
                'info_con_color',
                [
                    'label' => esc_html__( 'Content Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-contact-info-card p, .single-contact-info-card p a' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'info_con_typography',
                    'label'    => esc_html__( 'Content Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-contact-info-card p, .single-contact-info-card p a',
                ]
            );

        $this-> end_controls_section();
        
    }
    // Register control section end here

    protected function render() 
    {
        $settings = $this->get_settings_for_display();

        // Card Columns
        $columns = $settings['columns'];
        if ( $columns == '2' ) {
            $column = 'col-lg-6 col-md-6';
        } elseif ( $columns == '3' ) {
            $column = 'col-lg-4 col-md-4';
        } elseif ( $columns == '4' ) {
            $column = 'col-lg-3 col-md-4';
        }
        ?>

        <div class="container">
            <div class="row justify-content-center">
                <?php foreach ( $settings['contact_item_list'] as $item ) : ?>
                    <div class="<?php echo $column; ?>">
                        <div class="single-contact-info-card">
                            <?php if($item['icon'] !='' ) : ?>
                                <div class="icon">
                                    <i class='<?php echo esc_attr($item['icon']); ?>'></i>
                                </div>
                            <?php endif; ?>

                            <h3><?php echo esc_html($item['info_title']); ?></h3>

                            <?php echo wp_kses_post($item['info_content']); ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

    <?php    
    }

}
Plugin::instance()->widgets_manager->register_widget_type( new RolaContactInfo );