<?php
/**
 * App Overview Area Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Rola_AppOverview_Area extends Widget_Base {

	public function get_name() {
        return 'Rola_App_Overview';
    }

	public function get_title() {
        return esc_html__( 'Appointment Overview', 'rola-toolkit' );
    }

	public function get_icon() {
        return 'eicon-info-box';
    }

	public function get_categories() {
        return [ 'rolacategory' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'rola_app_over_Area',
			[
				'label' => esc_html__( 'Appointment Overview Left', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );
            
            $this->add_control(
                'left_image',
                [
                    'label'  => esc_html__( 'Image', 'rola-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'icon',
                [
                    'label'      => __( 'Icon', 'rola-toolkit' ),
                    'type' 	     => Controls_Manager::SELECT,
                    'options'    => rola_icons(),
                ]
            );
            $this->add_control(
                'call_title',
                [
                    'label'   => esc_html__( 'Call Title', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                ]
            );
            $this->add_control(
                'call_num',
                [
                    'label'   => esc_html__( 'Call Number', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                ]
            );
            $this->add_control(
                'call_num_link',
                [
                    'label'   => esc_html__( 'Call Number Link', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                ]
            );
            $this->add_control(
                'desc',
                [
                    'label'   => esc_html__( 'Description', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXTAREA,
                ]
            );
            // Button One
            $this->add_control(
                'button_text',
                [
                    'label' => __('Button Text', 'rola-toolkit'),
                    'type'  => Controls_Manager:: TEXT,
                ]
            );
            $this->add_control(
                'link_type',
                [
                    'label' => __( 'Link Type', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        '1'   => __( 'Link To Page', 'rola-toolkit' ),
                        '2'   => __( 'External Link', 'rola-toolkit' ),
                    ],
                ]
            );
            $this->add_control(
                'link_to_page',
                [
                    'label' => __( 'Link Page', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options'     => rola_toolkit_get_page_as_list(),
                    'condition'   => [
                        'link_type' => '1',
                    ]
                ]
            );
            $this->add_control(
                'external_link',
                [
                    'label' => __('External Link', 'rola-toolkit'),
                    'type'  => Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type' => '2',
                    ]
                ]
            );
        $this->end_controls_section();

        // Right Content
        $this->start_controls_section(
			'rola_app_over_right',
			[
				'label' => esc_html__( 'Appointment Overview Right', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'sec_title',
                [
                    'label'   => esc_html__( 'Section Title', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXTAREA,
                ]
            );
            $this->add_control(
                'right_image',
                [
                    'label'  => esc_html__( 'Image', 'rola-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'video_icon',
                [
                    'label'      => __( 'video Icon', 'rola-toolkit' ),
                    'type' 	     => Controls_Manager::SELECT,
                    'options'    => rola_icons(),
                ]
            );
            $this->add_control(
                'video_url',
                [
                    'label'   => esc_html__( 'Video URL', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                ]
            );
            $this->add_control(
                'app_form_title',
                [
                    'label'   => __( 'Form Title', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                ]
            );
            $this->add_control(
                'app_form_shortcode',
                [
                    'label'   => __( 'Form Shortcode', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'rola-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );
            $this->add_control(
                'calicon_color',
                [
                    'label'     => __( 'Call Icon Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .appointment-overview-contact .appointment-info .call-info li i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'callicon_typography',
                    'label'    => __( 'Call Icon Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .appointment-overview-contact .appointment-info .call-info li i',
                ]
            );
            $this->add_control(
                'calltitle_color',
                [
                    'label'     => __( 'Call Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .appointment-overview-contact .appointment-info .call-info li' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'calltitle_typography',
                    'label'    => __( 'Call Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .appointment-overview-contact .appointment-info .call-info li',
                ]
            );
            $this->add_control(
                'callnum_color',
                [
                    'label'     => __( 'Call Number Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .appointment-overview-contact .appointment-info .call-info li span a' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'callnum_typography',
                    'label'    => __( 'Call Number Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .appointment-overview-contact .appointment-info .call-info li span a',
                ]
            );
            $this->add_control(
                'calldesc_color',
                [
                    'label'     => __( 'Call Description Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .appointment-overview-contact .appointment-info p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'calldesc_typography',
                    'label'    => __( 'Call Description Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .appointment-overview-contact .appointment-info p',
                ]
            );
            $this->add_control(
                'right_sec_color',
                [
                    'label'     => __( 'Right Section Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .appointment-overview-box .content h4' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'right_sec_typography',
                    'label'    => __( 'Right Section Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .appointment-overview-box .content h4',
                ]
            );
            $this->add_control(
                'right_formt_color',
                [
                    'label'     => __( 'Form Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .appointment-overview-box .make-appointment-content h4' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'form_title_typography',
                    'label'    => __( 'Form Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .appointment-overview-box .make-appointment-content h4',
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Button link
        $btn1_text  = $settings['button_text'];

        $link_one = '';
        if( $settings['link_type'] == 1 ){
            $link_one = get_page_link($settings['link_to_page']); 
        } else {
            $link_one = $settings['external_link'];
        } 

        $form     = $settings['app_form_shortcode'];

        ?>

        <section class="appointment-overview-area pb-100">
            <div class="container">
                <div class="row">
                    <div class="col-lg-4 col-md-12">
                        <div class="appointment-overview-contact">
                            <?php if( $settings['left_image']['url'] != '' ) : ?>
                                <img src="<?php echo esc_url( $settings['left_image']['url'] ); ?>" alt="<?php echo esc_attr__('image', 'rola-toolkit'); ?>">
                            <?php endif; ?>

                            <div class="appointment-info">
                                <?php if($settings['call_num'] != '' ||  $settings['call_title'] != '' ) : ?>
                                    <ul class="call-info">
                                        <li>
                                            <i class='<?php echo esc_attr( $settings['icon'] ); ?>'></i>
                                            <?php echo esc_html( $settings['call_title'] ); ?>
                                            <span><a href="<?php echo esc_url( $settings['call_num_link'] ); ?>"><?php echo esc_html( $settings['call_num'] ); ?></a></span>
                                        </li>
                                    </ul>
                                <?php endif; ?>

                                <p><?php echo esc_html( $settings['desc'] ); ?></p>

                                <?php if( $btn1_text != '' ) : ?>
                                   <a href="<?php echo esc_url($link_one); ?>" class="default-btn"> <?php echo esc_html( $btn1_text ); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-8">
                        <div class="appointment-overview-box">
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="content">
                                        <?php if($settings['sec_title'] != '') : ?>
                                            <h4><?php echo wp_kses_post( $settings['sec_title'] ); ?></h4>
                                        <?php endif; ?>
                                        
                                        <?php if( $settings['right_image']['url'] != '' ) : ?>
                                            <div class="box-image">
                                                <img src="<?php echo esc_url( $settings['right_image']['url'] ); ?>" alt="<?php echo esc_attr__('image', 'rola-toolkit'); ?>">

                                                <a href="<?php echo esc_url( $settings['video_url'] ); ?>" class="video-btn popup-youtube">
                                                    <i class='<?php echo esc_attr( $settings['video_icon'] ); ?>'></i>
                                                </a>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <div class="col-lg-6">
                                    <div class="make-appointment-content">
                                        <?php if($settings['app_form_title'] != '') : ?>
                                            <h4><i class='bx bx-calendar'></i><?php echo wp_kses_post( $settings['app_form_title'] ); ?></h4>
                                        <?php endif; ?>

                                        <?php echo do_shortcode( $form ); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <?php
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Rola_AppOverview_Area );