<?php
/**
 * About Area Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Rola_About_Area extends Widget_Base {

	public function get_name() {
        return 'Rola_About_Area';
    }

	public function get_title() {
        return esc_html__( 'About Area', 'rola-toolkit' );
    }

	public function get_icon() {
        return 'eicon-info-box';
    }

	public function get_categories() {
        return [ 'rolacategory' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'rola_About_Area',
			[
				'label' => esc_html__( 'About Area', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'choose_type',
                [
                    'label' => esc_html__( 'Choose Style', 'baike-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options'     => [
                        '1'  => esc_html__( 'Style 1', 'baike-toolkit' ),
                        '2'  => esc_html__( 'Style 2', 'baike-toolkit' ),
                        '3'  => esc_html__( 'Style 3', 'baike-toolkit' ),
                        '4'  => esc_html__( 'Style 4', 'baike-toolkit' ),
                    ], 
                    'default' => '1'
                ]
            );
            $this->add_control(
                'top_icon',
                [
                    'label'      => __( 'Icon', 'rola-toolkit' ),
                    'type' 	     => Controls_Manager::SELECT,
                    'options'    => rola_icons(),
                ]
            );
            $this->add_control(
                'top_title',
                [
                    'label'   => esc_html__( 'Top Title', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                ]
            );
            $this->add_control(
                'title',
                [
                    'label'   => esc_html__( 'Title', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXTAREA,
                ]
            );
            $this->add_control(
                'sec_desc',
                [
                    'label' => esc_html__( 'Description', 'rola-toolkit' ),
                    'type'  => Controls_Manager::TEXTAREA,
                ]
            );

            $this->add_control(
                'image',
                [
                    'label'  => esc_html__( 'Image', 'rola-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'image_left',
                [
                    'label'     => esc_html__( 'Image Inner Image', 'rola-toolkit' ),
                    'type'	    => Controls_Manager::MEDIA,
                    'condition' => [
                        'choose_type' => '4',
                    ]
                ]
            );

            $this->add_control(
                'img_icon',
                [
                    'label'      => __( 'Image Icon', 'rola-toolkit' ),
                    'type' 	     => Controls_Manager::SELECT,
                    'options'    => rola_icons(),

                    'condition' => [
                        'choose_type' => '3',
                    ]
                ]
            );
            $this->add_control(
                'img_title',
                [
                    'label'       => __(' Title', 'rola-toolkit'),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => __('Free Shipping', 'rola-toolkit'),
                    'label_block' => true,

                    'condition' => [
                        'choose_type' => '3',
                    ]
                ]
            );
            $this->add_control(
                'img_desc',
                [
                    'label'       => __('Description', 'rola-toolkit'),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => __('Free Shipping', 'rola-toolkit'),
                    'label_block' => true,

                    'condition' => [
                        'choose_type' => '3',
                    ]
                ]
            );

            // Left Content
            $repeater_items = new Repeater();
            $repeater_items->add_control(
                'icon',
                [
                    'label' => __( 'Icon', 'rola-toolkit' ),
                    'type' 	     => Controls_Manager::SELECT,
                    'options'    => rola_icons(),
                ]
            );
            $repeater_items->add_control(
                'fea_title',
                [
                    'label'       => __(' Title', 'rola-toolkit'),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => __('Free Shipping', 'rola-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'rola_left_items',
                [
                    'label'  => __( 'Add Left Feature', 'parco-toolkit' ),
                    'type'   => Controls_Manager::REPEATER,
                    'fields' => $repeater_items->get_controls(),
                    'condition' => [
                        'choose_type!' => '4',
                    ]
                ]
            );
            // Right Content
            $repeater_items2 = new Repeater();
            $repeater_items2->add_control(
                'icon',
                [
                    'label' => __( 'Icon', 'rola-toolkit' ),
                    'type' 	     => Controls_Manager::SELECT,
                    'options'    => rola_icons(),
                ]
            );
            $repeater_items2->add_control(
                'fea_title',
                [
                    'label'       => __(' Title', 'rola-toolkit'),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => __('Free Shipping', 'rola-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'rola_right_items',
                [
                    'label'  => __( 'Add Right Feature', 'parco-toolkit' ),
                    'type'   => Controls_Manager::REPEATER,
                    'fields' => $repeater_items2->get_controls(),
                ]
            );

            // Style 4 Button
            $this->add_control(
                'button_one_text',
                [
                    'label' => __('Button Text', 'rola-toolkit'),
                    'type'  => Controls_Manager:: TEXT,
                    'condition' => [
                        'choose_type' => '4',
                    ]
                ]
            );
            $this->add_control(
                'link_type',
                [
                    'label' => __( 'Link Type', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        '1'   => __( 'Link To Page', 'rola-toolkit' ),
                        '2'   => __( 'External Link', 'rola-toolkit' ),
                    ],
                    'condition' => [
                        'choose_type' => '4',
                    ]
                ]
            );
            $this->add_control(
                'link_to_page',
                [
                    'label' => __( 'Link Page', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options'     => rola_toolkit_get_page_as_list(),
                    'condition'   => [
                        'link_type'   => '1',
                        'choose_type' => '4',
                    ]
                ]
            );
            $this->add_control(
                'external_link',
                [
                    'label' => __('External Link', 'rola-toolkit'),
                    'type'  => Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type'   => '2',
                        'choose_type' => '4',
                    ]
                ]
            );

            // Bottom Info Title
            $repeater_items3 = new Repeater();
            $repeater_items3->add_control(
                'icon',
                [
                    'label'      => __( 'Icon', 'rola-toolkit' ),
                    'type' 	     => Controls_Manager::SELECT,
                    'options'    => rola_icons(),
                ]
            );
            $repeater_items3->add_control(
                'info_title',
                [
                    'label'       => __('Info Title', 'rola-toolkit'),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('Free Shipping', 'rola-toolkit'),
                    'label_block' => true,
                ]
            );
            $repeater_items3->add_control(
                'info_desc',
                [
                    'label'       => __('Info Description', 'rola-toolkit'),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => __('Free Shipping', 'rola-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'rola_bottom_items',
                [
                    'label'  => __( 'Add Bottom Info', 'parco-toolkit' ),
                    'type'   => Controls_Manager::REPEATER,
                    'fields' => $repeater_items3->get_controls(),
                    'condition' => [
                        'choose_type' => ['2','3'],
                    ]
                ]
            );
        $this->end_controls_section();

        // Style
        $this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'rola-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_control(
                'top_title_color',
                [
                    'label'     => __( 'Top Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-content .sub-title, .about-content-wrap .sub-title, .dental-tourism-about-content span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'top_title_icolor',
                [
                    'label'     => __( 'Top Title Icon Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-content .sub-title i, .about-content-wrap .sub-title i, .dental-tourism-about-content span i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'top_title_bgcolor',
                [
                    'label'     => __( 'Top Title Background Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-content .sub-title,.about-content-wrap .sub-title, .dental-tourism-about-content span' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'top_title_typography',
                    'label'    => __( 'Top Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .about-content .sub-title,.about-content-wrap .sub-title, .dental-tourism-about-content span',
                ]
            );

            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-content h3, .about-content-wrap h3, .dental-tourism-about-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'title_strong_color',
                [
                    'label' => esc_html__( 'Title Color Text Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-content h3 span, .about-content-wrap h3 span' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_type!' => '4',
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => esc_html__( 'Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .about-content h3, .about-content-wrap h3, .dental-tourism-about-content h3',
                ]
            );

            $this->add_control(
                'desc_color',
                [
                    'label' => esc_html__( 'Description Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-content p, .about-content-wrap p, .dental-tourism-about-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'desc_typography',
                    'label'    => esc_html__( 'Description Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .about-content p, .about-content-wrap p, .dental-tourism-about-content p',
                ]
            );
            $this->add_control(
                'icon_color',
                [
                    'label' => esc_html__( 'Icon Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-content .about-list li i, .about-content-wrap .about-list li i, .dental-tourism-about-content .list li i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'icon_bgcolor',
                [
                    'label' => esc_html__( 'Icon Background Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-content .about-list li i, .about-content-wrap .about-list li i' => 'background-color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_type!' => '4',
                    ]
                ]
            );
            $this->add_control(
                'feature_list_color',
                [
                    'label' => esc_html__( 'Feature Lists Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-content .about-list li, .about-content-wrap .about-list li, .dental-tourism-about-content .list li' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'feature_list_bgcolor',
                [
                    'label' => esc_html__( 'Feature Lists Background Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-content .about-list li' => 'background-color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_type' => '1',
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'fea_lists_typography',
                    'label'    => esc_html__( 'Feature Lists Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .about-content .about-list li, .about-content-wrap .about-list li, .dental-tourism-about-content .list li',
                ]
            );

            $this->add_control(
                'bottom_infocolor',
                [
                    'label' => esc_html__( 'Bottom Info Title Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-content-wrap .about-info h4' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_type' => ['2','3'],
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'bottom_info_typography',
                    'label'    => esc_html__( 'Bottom Info Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .about-content-wrap .about-info h4',
                    'condition' => [
                        'choose_type' => ['2','3'],
                    ]
                ]
            );
            $this->add_control(
                'bottom_desccolor',
                [
                    'label' => esc_html__( 'Bottom Info Description Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-content-wrap .about-info span' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_type' => ['2','3'],
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'bottom_desc_typography',
                    'label'    => esc_html__( 'Bottom Info Description Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .about-content-wrap .about-info span',
                    'condition' => [
                        'choose_type' => ['2','3'],
                    ]
                ]
            );

            $this->add_control(
                'img_titcolor',
                [
                    'label' => esc_html__( 'Image Title Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-image-wrap .about-inner-box .content h3' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_type' => '3',
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'bimg_title_typography',
                    'label'    => esc_html__( 'Image Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}}  .about-image-wrap .about-inner-box .content h3',
                    'condition' => [
                        'choose_type' => '3',
                    ]
                ]
            );
            $this->add_control(
                'img_descolor',
                [
                    'label' => esc_html__( 'Image Desc Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-image-wrap .about-inner-box .content p' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_type' => '3',
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'bimg_des_typography',
                    'label'    => esc_html__( 'Image Desc Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}}  .about-image-wrap .about-inner-box .content p',
                    'condition' => [
                        'choose_type' => '3',
                    ]
                ]
            );
            $this->add_control(
                'img_iconcolor',
                [
                    'label' => esc_html__( 'Image Icon Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-image-wrap .about-inner-box .content .icon i' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_type' => '3',
                    ]
                ]
            );


            $this->add_control(
                'button_color',
                [
                    'label' => esc_html__( 'Button Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dental-tourism-about-content .about-btn .default-btn' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_type' => '4',
                    ]
                ]
            );
            $this->add_control(
                'button_bgcolor',
                [
                    'label' => esc_html__( 'Button Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dental-tourism-about-content .about-btn .default-btn' => 'background-color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_type' => '4',
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => esc_html__( 'Button Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}}  .dental-tourism-about-content .about-btn .default-btn',
                    'condition' => [
                        'choose_type' => '4',
                    ]
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {

        $settings    = $this->get_settings_for_display();
        $left_items  = $settings['rola_left_items'];
        $right_items = $settings['rola_right_items'];
        $bottom_items = $settings['rola_bottom_items'];

        // Button link
        $btn1_text  = $settings['button_one_text'];

        $link_one = '';
        if( $settings['link_type'] == 1 ){
            $link_one = get_page_link($settings['link_to_page']); 
        } else {
            $link_one = $settings['external_link'];
        }
    ?>

        <?php if( $settings['choose_type'] == '1' ) : ?>
            <div class="about-area">
                <div class="container">
                    <div class="row">
                        <?php if( $settings['image']['url'] != '' ): ?>
                        <div class="col-lg-6 col-md-12">
                            <div class="about-image" style="background-image: url(<?php echo esc_url( $settings['image']['url']); ?> )"></div>
                        </div>
                        <div class="col-lg-6 col-md-12">
                        <?php else: ?>
                        <div class="col-lg-12 col-md-12">
                        <?php endif; ?>
                            <div class="about-content">
                                <?php if( $settings['top_title'] != '' ) : ?>
                                    <span class="sub-title">
                                        <i class="<?php echo esc_attr( $settings['top_icon'] ); ?>"></i>
                                        <?php echo esc_html( $settings['top_title'] ); ?>
                                    </span>
                                <?php endif; ?>

                                <?php if( $settings['title'] != '' ) : ?>
                                    <h3><?php echo wp_kses_post( $settings['title'] ); ?></h3>
                                <?php endif; ?>

                                <p><?php echo wp_kses_post( $settings['sec_desc'] ); ?></p>

                                <div class="row">
                                    <div class="col-lg-6 col-md-6">
                                        <ul class="about-list">
                                            <?php foreach ( $left_items as $item ) : ?>
                                                <li>
                                                    <?php if( $item['icon'] != '') : ?>
                                                        <i class="<?php echo esc_attr( $item['icon'] ); ?>"></i>
                                                    <?php endif; ?>
                                                    <?php echo esc_html( $item['fea_title'] ); ?>
                                                </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    </div>

                                    <div class="col-lg-6 col-md-6">
                                        <ul class="about-list">
                                            <?php foreach ( $right_items as $item ) : ?>
                                                <li>
                                                    <?php if( $item['icon'] != '') : ?>
                                                        <i class="<?php echo esc_attr( $item['icon'] ); ?>"></i>
                                                    <?php endif; ?>

                                                    <?php echo esc_html( $item['fea_title'] ); ?>
                                                </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php elseif( $settings['choose_type'] == '2' ) : ?>
            <section class="about-area pb-100">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-7">
                            <div class="about-content-wrap">
                                <?php if( $settings['top_title'] != '' ) : ?>
                                    <span class="sub-title">
                                        <i class="<?php echo esc_attr( $settings['top_icon'] ); ?>"></i>
                                        <?php echo esc_html( $settings['top_title'] ); ?>
                                    </span>
                                <?php endif; ?>

                                <?php if( $settings['title'] != '' ) : ?>
                                    <h3><?php echo wp_kses_post( $settings['title'] ); ?></h3>
                                <?php endif; ?>

                                <p><?php echo wp_kses_post( $settings['sec_desc'] ); ?></p>

                                <div class="row">
                                    <div class="col-lg-6 col-md-6">
                                        <ul class="about-list">
                                            <?php foreach ( $left_items as $item ) : ?>
                                                <li>
                                                    <?php if( $item['icon'] != '') : ?>
                                                        <i class="<?php echo esc_attr( $item['icon'] ); ?>"></i>
                                                    <?php endif; ?>
                                                    <?php echo esc_html( $item['fea_title'] ); ?>
                                                </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    </div>

                                    <div class="col-lg-6 col-md-6">
                                        <ul class="about-list">
                                            <?php foreach ( $right_items as $item ) : ?>
                                                <li>
                                                    <?php if( $item['icon'] != '') : ?>
                                                        <i class="<?php echo esc_attr( $item['icon'] ); ?>"></i>
                                                    <?php endif; ?>

                                                    <?php echo esc_html( $item['fea_title'] ); ?>
                                                </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    </div>
                                </div>

                                <div class="row">
                                    <?php foreach ( $bottom_items as $item ) : ?>
                                        <div class="col-lg-6 col-md-6">
                                            <div class="about-info">
                                                <?php if( $item['icon'] != '' ) : ?>
                                                    <i class="<?php echo esc_attr( $item['icon'] ); ?>"></i>
                                                <?php endif; ?>
                                                <h4><?php echo esc_html( $item['info_title'] ); ?></h4>
                                                <span><?php echo esc_html( $item['info_desc'] ); ?></span>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>

                        <?php if( $settings['image']['url'] != '' ) : ?>
                            <div class="col-lg-5">
                                <div class="about-image-wrap">
                                    <img src="<?php echo esc_url( $settings['image']['url'] ); ?>" alt="<?php echo esc_attr__('image', 'rola-toolkit'); ?>">
                                </div>
                            </div>
                        <?php endif; ?>

                    </div>
                </div>
            </section>
        <?php elseif( $settings['choose_type'] == '3' ) : ?>
            <div class="about-area ptb-100">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-6">
                            <div class="about-content-wrap">
                                <?php if( $settings['top_title'] != '' ) : ?>
                                    <span class="sub-title">
                                        <i class="<?php echo esc_attr( $settings['top_icon'] ); ?>"></i>
                                        <?php echo esc_html( $settings['top_title'] ); ?>
                                    </span>
                                <?php endif; ?>

                                <?php if( $settings['title'] != '' ) : ?>
                                    <h3><?php echo wp_kses_post( $settings['title'] ); ?></h3>
                                <?php endif; ?>

                                <?php echo wp_kses_post( $settings['sec_desc'] ); ?>

                                <div class="row">
                                    <div class="col-lg-6 col-md-6">
                                        <ul class="about-list">
                                            <?php foreach ( $left_items as $item ) : ?>
                                                <li>
                                                    <?php if( $item['icon'] != '') : ?>
                                                        <i class="<?php echo esc_attr( $item['icon'] ); ?>"></i>
                                                    <?php endif; ?>
                                                    <?php echo esc_html( $item['fea_title'] ); ?>
                                                </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    </div>

                                    <div class="col-lg-6 col-md-6">
                                        <ul class="about-list">
                                            <?php foreach ( $right_items as $item ) : ?>
                                                <li>
                                                    <?php if( $item['icon'] != '') : ?>
                                                        <i class="<?php echo esc_attr( $item['icon'] ); ?>"></i>
                                                    <?php endif; ?>

                                                    <?php echo esc_html( $item['fea_title'] ); ?>
                                                </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    </div>
                                </div>

                                <div class="row">
                                    <?php foreach ( $bottom_items as $item ) : ?>
                                        <div class="col-lg-6 col-md-6">
                                            <div class="about-info">
                                                <?php if( $item['icon'] != '' ) : ?>
                                                    <i class="<?php echo esc_attr( $item['icon'] ); ?>"></i>
                                                <?php endif; ?>
                                                <h4><?php echo esc_html( $item['info_title'] ); ?></h4>
                                                <span><?php echo esc_html( $item['info_desc'] ); ?></span>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>

                        <?php if( $settings['image']['url'] != '' ) : ?>
                            <div class="col-lg-6">
                                <div class="about-image-wrap">
                                    <img src="<?php echo esc_url( $settings['image']['url'] ); ?>" alt="<?php echo esc_attr__('image', 'rola-toolkit'); ?>">

                                    <div class="about-inner-box">
                                        <div class="content">
                                            <?php if( $settings['img_icon'] != '' ) : ?>
                                                <div class="icon">
                                                    <i class="<?php echo esc_attr( $settings['img_icon'] ); ?>"></i>
                                                </div>
                                            <?php endif; ?>

                                            <?php if( $settings['img_title'] != '' ) : ?>
                                                <h3><?php echo wp_kses_post( $settings['img_title'] ); ?></h3>
                                            <?php endif; ?>
                                            <?php if( $settings['img_desc'] != '' ) : ?>
                                                <p><?php echo esc_html( $settings['img_desc'] ); ?></p>
                                            <?php endif; ?>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <div class="dental-tourism-about-area pb-100">
                <div class="container">
                    <div class="row align-items-center">
                        <?php if( $settings['image']['url'] != '' ): ?>
                        <div class="col-lg-5 col-md-12">
                            <div class="dental-tourism-about-image">
                                <img src="<?php echo esc_url( $settings['image']['url'] ); ?>" alt="<?php echo esc_attr__('image', 'rola-toolkit'); ?>">

                                <?php if( $settings['image_left']['url'] != '' ): ?>
                                <div class="certified">
                                    <img src="<?php echo esc_url( $settings['image_left']['url'] ); ?>" alt="<?php echo esc_attr__('image', 'rola-toolkit'); ?>">
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="col-lg-7 col-md-12">
                        <?php else: ?>
                        <div class="col-lg-12 col-md-12">
                        <?php endif; ?>
                            <div class="dental-tourism-about-content">
                                <?php if( $settings['top_title'] != '' ) : ?>
                                    <span class="sub-title">
                                        <i class="<?php echo esc_attr( $settings['top_icon'] ); ?>"></i>
                                        <?php echo esc_html( $settings['top_title'] ); ?>
                                    </span>
                                <?php endif; ?>
                                <?php if( $settings['title'] != '' ) : ?>
                                    <h3><?php echo wp_kses_post( $settings['title'] ); ?></h3>
                                <?php endif; ?>

                                <?php echo wp_kses_post( $settings['sec_desc'] ); ?>

                                <ul class="list">
                                    <?php foreach ( $right_items as $item ) : ?>
                                        <li>
                                            <?php if( $item['icon'] != '') : ?>
                                                <i class="<?php echo esc_attr( $item['icon'] ); ?>"></i>
                                            <?php endif; ?>

                                            <?php echo esc_html( $item['fea_title'] ); ?>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                                <?php if( $btn1_text != '' ): ?>
                                    <div class="about-btn">
                                        <a href="<?php echo esc_url($link_one); ?>" class="default-btn"> <?php echo esc_html( $btn1_text ); ?></a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Rola_About_Area );