<?php
/* 
 * Plugin Name: Rola Toolkit
 * Author: HiBootstrap
 * Author URI: hibootstrap.com
 * Description: A Light weight and easy toolkit for Elementor page builder widgets.
 * Version: 1.7.0
 */

if (!defined('ABSPATH')) {
    exit; //Exit if accessed directly
}

define('ROLA_ACC_PATH', plugin_dir_path(__FILE__));

if( !defined('ROLA_FRAMEWORK_VAR') ) define('ROLA_FRAMEWORK_VAR', 'rola_opt');

// Disable Elementor's Default Colors and Default Fonts
update_option( 'elementor_disable_color_schemes', 'yes' );
update_option( 'elementor_disable_typography_schemes', 'yes' );

// Select page for link
function rola_toolkit_get_page_as_list() {
    $args = wp_parse_args(array(
        'post_type' => 'page',
        'numberposts' => -1,
    ));

    $posts = get_posts( $args );
    $post_options = array(esc_html__('--Select Page--', 'rola-toolkit') => '');

    if ( $posts ) {
        foreach ( $posts as $post ) {
            $post_options[$post->post_title] = $post->ID;
        }
    }
    $flipped = array_flip($post_options);
    return $flipped;
}

/**
 * Post category list
 */
function rola_toolkit_get_post_cat_list() {
	$post_category_id = get_queried_object_id();
	$args = array(
		'parent' => $post_category_id
	);

	$terms = get_terms( 'category', get_the_ID());
	$cat_options = array(esc_html__('', 'rola-toolkit') => '');

	if ($terms) {
		foreach ($terms as $term) {
			$cat_options[$term->name] = $term->name;
		}
	}
	return $cat_options;
}

function rola_toolkit_get_page_services_cat_el()
{
    $arg = array(
        'taxonomy' => 'service_cat',
        'orderby' => 'name',
        'order'   => 'ASC'
    );
    $args = get_categories($arg);
    $args_options = array(esc_html__('', 'rola-toolkit') => '');
    if ($args) {
        foreach ($args as $args) {
            $args_options[$args->name] = $args->slug;
        }
    }
    return $args_options;
}
function rola_toolkit_get_page_doctor_cat_el()
{
    $arg = array(
        'taxonomy' => 'doctor_cat',
        'orderby' => 'name',
        'order'   => 'ASC'
    );
    $args = get_categories($arg);
    $args_options = array(esc_html__('', 'rola-toolkit') => '');
    if ($args) {
        foreach ($args as $args) {
            $args_options[$args->name] = $args->slug;
        }
    }
    return $args_options;
}

//Custom Post
function rola_toolkit_custom_post()
{
	global $rola_opt;
	if(isset($rola_opt['service_permalink'])) {
		$ser_post_type = $rola_opt['service_permalink'];
	} else {
		$ser_post_type = 'service-post';
	}

	if( isset( $rola_opt['dentist_permalink'] ) ) {
		$doctor_url = $rola_opt['dentist_permalink'];
	} else {
		$doctor_url = 'doctor-post';
	}

	// Services Custom Post
 	register_post_type('service',
        array(
            'labels' => array(
                'name' => esc_html__('Services', 'rola-toolkit'),
                'singular_name' => esc_html__('Service', 'rola-toolkit'),
            ),
            'menu_icon' => 'dashicons-images-alt',
            'supports' => array('title', 'thumbnail', 'editor', 'page-attributes','excerpt'),
            'has_archive' => true,
			'public'   => true,
			'rewrite' => array( 'slug' => $ser_post_type ),
        )
	);
	
	// Services Custom Post
 	register_post_type('doctor',
        array(
            'labels' => array(
                'name'          => esc_html__('Doctor', 'rola-toolkit'),
                'singular_name' => esc_html__('Doctor', 'rola-toolkit'),
            ),
            'menu_icon'   => 'dashicons-images-alt',
            'supports'    => array('title', 'thumbnail', 'editor', 'page-attributes','excerpt'),
            'has_archive' => true,
			'public'      => true,
			'rewrite'     => array( 'slug' => $doctor_url ),
        )
	);
}
add_action('init', 'rola_toolkit_custom_post');

//Taxonomy Custom Post
function rola_custom_post_taxonomy(){
    register_taxonomy(
        'service_cat',
        'service',
            array(
            'hierarchical'      => true,
            'label'             => esc_html__('Service Category', 'rola-toolkit' ),
            'query_var'         => true,
            'show_admin_column' => true,
                'rewrite'       => array(
                'slug'          => 'service-category',
                'with_front'    => true
            )
        )
    );
	register_taxonomy( 
        'service_tag', //taxonomy 
        'service', //post-type
        array( 
            'hierarchical'  => false, 
            'label'         => esc_html__( 'Tags','rola-toolkit'), 
            'singular_name' => esc_html__( 'Tag', 'rola-toolkit' ), 
            'rewrite'       => true, 
            'query_var'     => true,
            'show_admin_column' => true,
		)
	);

	register_taxonomy(
        'doctor_cat',
        'doctor',
            array(
            'hierarchical'      => true,
            'label'             => esc_html__('Doctor Category', 'rola-toolkit' ),
            'query_var'         => true,
            'show_admin_column' => true,
                'rewrite'       => array(
                'slug'          => 'doctor-category',
                'with_front'    => true
            )
        )
    );
}
add_action('init', 'rola_custom_post_taxonomy');


// Add this to your theme's functions.php
function rola_add_script_to_footer(){
    if( ! is_admin() ) { 
		global $rola_opt;
		$action_url  = isset( $rola_opt['mail_action_url']) ? $rola_opt['mail_action_url'] : '';
		?>

		<script>
			<?php if( !empty($action_url) ) : ?>
				;(function($){
					"use strict";
					$(document).ready(function () {
						// MAILCHIMP
						if ($(".mailchimp").length > 0) {
							$(".mailchimp").ajaxChimp({
								callback: mailchimpCallback,
								url: "<?php echo esc_js($action_url) ?>"
							});
						}
						$(".memail").on("focus", function () {
							$(".mchimp-errmessage").fadeOut();
							$(".mchimp-sucmessage").fadeOut();
						});
						$(".memail").on("keydown", function () {
							$(".mchimp-errmessage").fadeOut();
							$(".mchimp-sucmessage").fadeOut();
						});
						$(".memail").on("click", function () {
							$(".memail").val("");
						});

						function mailchimpCallback(resp) {
							if (resp.result === "success") {
								$(".mchimp-sucmessage").html(resp.msg).fadeIn(1000);
								$(".mchimp-sucmessage").fadeOut(500);
							} else if (resp.result === "error") {
								$(".mchimp-errmessage").html(resp.msg).fadeIn(1000);
							}
						}
					});
				})(jQuery)
			<?php endif; ?>
		</script>

	<?php 
	}
}
add_action( 'wp_footer', 'rola_add_script_to_footer' );

// Main rola Toolkit Class
final class Elementor_Rola_Extension {

	const VERSION = '1.0.0';
	const MINIMUM_ELEMENTOR_VERSION = '2.0.0';
	const MINIMUM_PHP_VERSION = '7.0';

	// Instance
    private static $_instance = null;
    
	public static function instance() {

		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;

	}

	// Constructor
	public function __construct() {
		add_action( 'plugins_loaded', [ $this, 'init' ] );

	}

	// init
	public function init() {
        load_plugin_textdomain( 'rola-toolkit' );

		// Check if Elementor installed and activated
		if ( ! did_action( 'elementor/loaded' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_missing_main_plugin' ] );
			return;
		}

		// Check for required Elementor version
		if ( ! version_compare( ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_minimum_elementor_version' ] );
			return;
		}

		// Check for required PHP version
		if ( version_compare( PHP_VERSION, self::MINIMUM_PHP_VERSION, '<' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_minimum_php_version' ] );
			return;
		}

		// Add Plugin actions
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'init_widgets' ] );
        
        add_action('elementor/elements/categories_registered',[ $this, 'register_new_category'] );
        
    }

    public function register_new_category($manager){
        $manager->add_category('rolacategory',[
            'title'  => esc_html__('Rola Category','rola-toolkit'),
            'icon'   => 'fa fa-image'
        ]);
    }

	//Admin notice
	public function admin_notice_missing_main_plugin() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			/* translators: 1: Plugin name 2: Elementor */
			esc_html__( '"%1$s" requires "%2$s" to be installed and activated.', 'rola-toolkit' ),
			'<strong>' . esc_html__( 'Rola Toolkit', 'rola-toolkit' ) . '</strong>',
			'<strong>' . esc_html__( 'Elementor', 'rola-toolkit' ) . '</strong>'
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}
	public function admin_notice_minimum_elementor_version() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			/* translators: 1: Plugin name 2: Elementor 3: Required Elementor version */
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'rola-toolkit' ),
			'<strong>' . esc_html__( 'Rola Toolkit', 'rola-toolkit' ) . '</strong>',
			'<strong>' . esc_html__( 'Elementor', 'rola-toolkit' ) . '</strong>',
			 self::MINIMUM_ELEMENTOR_VERSION
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}
	public function admin_notice_minimum_php_version() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			/* translators: 1: Plugin name 2: PHP 3: Required PHP version */
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'rola-toolkit' ),
			'<strong>' . esc_html__( 'Rola Toolkit', 'rola-toolkit' ) . '</strong>',
			'<strong>' . esc_html__( 'PHP', 'rola-toolkit' ) . '</strong>',
			 self::MINIMUM_PHP_VERSION
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}

	// Toolkit Widgets
	public function init_widgets() {
		// Include Widget files
		$pcs = trim( get_option( 'rola_purchase_code_status' ) );
		if ( $pcs == 'valid' ) {
			require_once( __DIR__ . '/widgets/banner-one.php' );
			require_once( __DIR__ . '/widgets/feature-services.php' );
			require_once( __DIR__ . '/widgets/section.php' );
			require_once( __DIR__ . '/widgets/services.php' );
			require_once( __DIR__ . '/widgets/hospital-area.php' );
			require_once( __DIR__ . '/widgets/core-service-feature.php' );
			require_once( __DIR__ . '/widgets/about-area.php' );
			require_once( __DIR__ . '/widgets/overview-area.php' );
			require_once( __DIR__ . '/widgets/doctor.php' );
			require_once( __DIR__ . '/widgets/feedback-area.php' );
			require_once( __DIR__ . '/widgets/blog-posts.php' );
			require_once( __DIR__ . '/widgets/funfacts.php' );
			require_once( __DIR__ . '/widgets/pricing-two.php' );
			require_once( __DIR__ . '/widgets/faq.php' );
			require_once( __DIR__ . '/widgets/coming-soon.php' );
			require_once( __DIR__ . '/widgets/contact-info-area.php' );
			require_once( __DIR__ . '/widgets/contact-area.php' );
			require_once( __DIR__ . '/widgets/appointment-area.php' );
			require_once( __DIR__ . '/widgets/pricing.php' );
			require_once( __DIR__ . '/widgets/doctors-details.php' );

			// V1.3
			require_once( __DIR__ . '/widgets/banner-two-slider.php' );
			require_once( __DIR__ . '/widgets/nervous-area.php' );
			require_once( __DIR__ . '/widgets/app-overview-area.php' );
			require_once( __DIR__ . '/widgets/banner-three-slider.php' );
			require_once( __DIR__ . '/widgets/banner-four.php' );

			// V1.5
			require_once( __DIR__ . '/widgets/banner-five.php' );
			require_once( __DIR__ . '/widgets/tourism-feature-area.php' );
			require_once( __DIR__ . '/widgets/tourism-services.php' );
			require_once( __DIR__ . '/widgets/tourism-choose-area.php' );
			require_once( __DIR__ . '/widgets/tourism-tourist-area.php' );
			require_once( __DIR__ . '/widgets/banner-six.php' );
			require_once( __DIR__ . '/widgets/skin-care-services.php' );
			require_once( __DIR__ . '/widgets/skin-care-about-area.php' );
			require_once( __DIR__ . '/widgets/skin-care-dry-area.php' );
			require_once( __DIR__ . '/widgets/skin-before-after-area.php' );
			require_once( __DIR__ . '/widgets/skin-partner-area.php' );
			require_once( __DIR__ . '/widgets/banner-seven.php' );
			require_once( __DIR__ . '/widgets/eye-care-feature-area.php' );
			require_once( __DIR__ . '/widgets/eye-care-about-area.php' );
			require_once( __DIR__ . '/widgets/eye-care-services.php' );
			require_once( __DIR__ . '/widgets/eye-care-offer-area.php' );
			require_once( __DIR__ . '/widgets/eyecare-feedback-area.php' );
			require_once( __DIR__ . '/widgets/eyecare-treatment-area.php' );
			require_once( __DIR__ . '/widgets/newsletter.php' );
		}
	}

}
Elementor_Rola_Extension::instance();

// Redux Theme Options
$pcs = trim( get_option( 'rola_purchase_code_status' ) );
if ( $pcs == 'valid' ) {
	require_once(ROLA_ACC_PATH . 'redux/ReduxCore/framework.php');
	require_once(ROLA_ACC_PATH . 'redux/sample/sample-config.php');
	require_once(ROLA_ACC_PATH . 'inc/widgets.php');
	require_once(ROLA_ACC_PATH . 'inc/rola-about.php');
	require_once(ROLA_ACC_PATH . 'inc/rola-contact-info.php');
	require_once(ROLA_ACC_PATH . 'inc/rola-author.php');
	require_once(ROLA_ACC_PATH . 'inc/icons.php');
	require_once(ROLA_ACC_PATH . 'inc/acf.php');
}

function rola_toolkit_js_code() {
    if ( !class_exists('Rola_RT') || !class_exists('Rola_base') || !class_exists('Rola_admin_page') ) {
		?>
		<script>
			const body = document.getElementsByTagName('body');
			body[0].style.opacity = "0";
		</script>
	<?php }
}
add_action('wp_footer', 'rola_toolkit_js_code');

//Registering crazy toolkit files
function rola_toolkit_files()
{
    wp_enqueue_style('font-awesome-4.7', plugin_dir_url(__FILE__) . 'assets/css/font-awesome.min.css');
}

add_action('wp_enqueue_scripts', 'rola_toolkit_files');

// Extra P tag from widget
remove_filter('widget_text_content', 'wpautop');

add_filter('script_loader_tag', 'rola_clean_script_tag');
function rola_clean_script_tag($input) {
	$input = str_replace( array( 'type="text/javascript"', "type='text/javascript'" ), '', $input );
	return $input;
}

// Post View Count
function rola_set_post_views($postID) {
    $count_key = 'rola_post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        $count = 0;
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
    }else{
        $count++;
        update_post_meta($postID, $count_key, $count);
    }
}
remove_action( 'wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0);

function rola_admin_css() {
	echo '<style>.#fw-ext-brizy,#fw-extensions-list-wrapper .toggle-not-compat-ext-btn-wrapper,.fw-brz-dismiss{display:none}.fw-brz-dismiss{display:none}.fw-extensions-list-item{display:none!important}#fw-ext-backups{display:block!important}#update-nag,.update-nag{display:block!important} .fw-sole-modal-content.fw-text-center .fw-text-danger.dashicons.dashicons-warning:before { content: "\f15e" !important;}.fw-sole-modal-content.fw-text-center .fw-text-danger.dashicons.dashicons-warning {color: green !important;} .fw-modal.fw-modal-open > .media-modal-backdrop {width: 100% !important;}</style>';	
}
add_action('admin_head', 'rola_admin_css');

// Pass placeholder to Comments Form
add_filter( 'comment_form_default_fields', 'Rola_comment_placeholders' );
function Rola_comment_placeholders( $fields )
{

	global $rola_opt;
	$name_place   = isset( $rola_opt['form_name_place']) ? $rola_opt['form_name_place'] : '';
	$email_place  = isset( $rola_opt['form_email_place']) ? $rola_opt['form_email_place'] : '';
	$web_place    = isset( $rola_opt['form_web_place']) ? $rola_opt['form_web_place'] : '';

	$fields['author'] = str_replace(
        '<input',
        '<input placeholder="' . $name_place . '"',
        $fields['author']
    );
    $fields['email'] = str_replace(
        '<input',
        '<input placeholder="' . $email_place . '"',
        $fields['email']
    );
    $fields['url'] = str_replace(
        '<input',
        '<input placeholder="' . $web_place . '"',
        $fields['url']
    );
    return $fields;
}

/* Add Placehoder in comment Form Field (Comment) */
add_filter( 'comment_form_defaults', 'rola_textarea_placeholder' );

function rola_textarea_placeholder( $fields ) {
	global $rola_opt;
	$comment_place  = isset( $rola_opt['form_comment_ph']) ? $rola_opt['form_comment_ph'] : '';

    $fields['comment_field'] = str_replace(
        '<textarea',
        '<textarea placeholder="' . $comment_place . '"',
        $fields['comment_field']
    );

	return $fields;
}


$opt_name = ROLA_FRAMEWORK_VAR;