<?php

class Rola_posts_thumbs extends WP_Widget{

    function __construct(){
        $widget_ops = array('description' => esc_html__('Display Random or Recent posts with a small image.', 'rola-toolkit'));
        parent::__construct( false, esc_html__('Rola Recent Posts With Image', 'rola-toolkit'), $widget_ops);
    }

    function widget($args, $instance){
        global $rola_theme, $rola_opt;
        $is_post_date   = isset( $rola_opt['is_post_date']) ? $rola_opt['is_post_date'] : false;
        extract($args); //it receives an associative array

        $title = apply_filters('widget_title', $instance['title']);
        $args = array(
            'posts_per_page' => $instance['number'],
            'post_type' => $instance['post_type'],
            'order' => 'DESC',
            'orderby' => $instance['orderby']
        );
       
        $query = new WP_Query($args);

        if( !$query->have_posts() ) return;
        echo $before_widget;
        if($title) echo $before_title.$title.$after_title;
        if(!$instance['number']) $instance['number'] = 4;

        if($query->have_posts()):
            $c = 0;
            
            while($query->have_posts()): $query->the_post(); ?>
                <?php
                $class = 'item';
                $post_id = get_the_ID();
                $thumb_size = 'rola_widget_thumb';
                ?>
                <?php if( !has_post_thumbnail() ) $class .= ' no-thumb'; ?>
                <article <?php post_class($class); ?>>

                    <?php if( has_post_thumbnail() ): ?>
                        <?php
                        $thumb_id   = get_post_thumbnail_id($post_id);
                        $thumb_type = get_post_mime_type($thumb_id);
                        $image_alt  = get_post_meta( $thumb_id, '_wp_attachment_image_alt', true);
                        if( !$image_alt ){
                            $image_alt = get_the_title($post_id);
                        }
                        if($thumb_type == 'image/gif'){
                            $thumb_size = '';
                        }
                        ?>
                        <a href="<?php the_permalink(); ?>" class="thumb hover-effect" aria-label="<?php the_title(); ?>">
                            <?php if( !empty($rola_theme) && $rola_theme['enable_lazyload'] == '1' ): ?>
                                <span class="fullimage cover lazy" role="img" aria-label="<?php echo esc_attr($image_alt); ?>" data-src="<?php the_post_thumbnail_url($thumb_size); ?>"></span>
                            <?php else: ?>
                                <span class="fullimage cover" role="img" aria-label="<?php echo esc_attr($image_alt); ?>" style="background: url('<?php the_post_thumbnail_url($thumb_size); ?>');"></span>
                            <?php endif; ?>
                        </a>
                    <?php endif; ?>

                    <div class="info gradient-effect">
                        <h4 class="title usmall"><a href="<?php the_permalink(); ?>"><?php echo get_the_title(); ?></a></h4>
                       
                        <?php if( $is_post_date  == false ) { ?>
                            <time datetime="<?php the_time('Y-m-d'); ?>"><?php the_time( get_option('date_format') ); ?></time>
                        <?php } ?>							
                    </div>

                    <div class="clear"></div>
                </article>
            <?php
            endwhile;
            wp_reset_postdata();
        endif;
        echo $after_widget;
    }

    function update($new_instance, $old_instance){
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['number'] = (int) $new_instance['number'];
        $instance['orderby'] = $new_instance['orderby'];
        $instance['post_type'] = $new_instance['post_type'];
        return $instance;
    }

    function form($instance){
        $defaults = array(
            'title' => 'Recent posts',
            'number' => 4,
            'orderby' => 'date',
            'post_type' => 'post'
        );
        $instance = wp_parse_args((array)$instance, $defaults);
        $number = isset( $instance['number'] ) ? absint( $instance['number'] ) : 4;
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">
                <?php esc_html_e('Title:', 'rola-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $instance['title']; ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('number'); ?>"><?php esc_html_e( 'Number of posts to show:', 'rola-toolkit'); ?></label>
            <input id="<?php echo $this->get_field_id('number'); ?>" name="<?php echo $this->get_field_name('number'); ?>" type="text" value="<?php echo $number; ?>" size="3" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('orderby'); ?>"><?php esc_html_e('Mode:', 'rola-toolkit') ?> </label>
            <select id="<?php echo $this->get_field_id('orderby'); ?>" name="<?php echo $this->get_field_name('orderby'); ?>">
                <option <?php if ($instance['orderby'] == 'date') echo 'selected="selected"'; ?> value="date"><?php esc_html_e('Recent Posts', 'rola-toolkit'); ?></option>
                <option <?php if ($instance['orderby'] == 'rand') echo 'selected="selected"'; ?> value="rand"><?php esc_html_e('Random Posts', 'rola-toolkit'); ?></option>
                <?php if( function_exists('get_field') ): // By views ?>
                    <option <?php if ($instance['orderby'] == 'views') echo 'selected="selected"'; ?> value="views"><?php esc_html_e('Post views', 'rola-toolkit'); ?></option>
                <?php endif; ?>
            </select>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('post_type'); ?>"><?php esc_html_e('Post Type:', 'rola-toolkit') ?> </label>
            <select id="<?php echo $this->get_field_id('post_type'); ?>" name="<?php echo $this->get_field_name('post_type'); ?>">
                <option <?php if ($instance['post_type'] == 'post') echo 'selected="selected"'; ?> value="post"><?php esc_html_e('Blog Posts', 'rola-toolkit'); ?></option>
                <option <?php if ($instance['post_type'] == 'service') echo 'selected="selected"'; ?> value="service"><?php esc_html_e('Service Posts', 'rola-toolkit'); ?></option>
                <option <?php if ($instance['post_type'] == 'project') echo 'selected="selected"'; ?> value="project"><?php esc_html_e('Projects Posts', 'rola-toolkit'); ?></option>
            </select>
        </p>
        <?php
    }

}

function rola_register_posts_thumbs() {
    register_widget('Rola_posts_thumbs');
}

add_action('widgets_init', 'rola_register_posts_thumbs');



/**
 * Newsletter Widget
 */
class rola_newsletter extends WP_Widget{

    function __construct(){
        $widget_ops = array('description' => esc_html__('Display Contact Info', 'rola-toolkit'));
        parent::__construct( false, esc_html__('Rola Footer Newsletter', 'rola-toolkit'), $widget_ops);
    }

    function widget($args, $instance){
        extract($args);

        $title  = apply_filters('widget_title', $instance['title']);

        echo $before_widget;
        if($title) echo $before_title.$title.$after_title;
        ?>
        <div class="widget-newsletter">
            <div class="newsletter-content">
                <?php if( $instance['content'] != '' ): ?>
                    <p><?php echo $instance['content']; ?></p>
                <?php endif; ?>
            </div>

            <?php if( $instance['email_url'] != '' ): ?>
                <form class="mailchimp newsletter-form" method="post">
                    <input type="email" class="input-newsletter memail" placeholder="<?php echo esc_attr($instance['email_placeholder']); ?>" name="EMAIL" required>

                    <button type="submit"><i class="bx bx-paper-plane"></i></button>
                    <div class="mchimp-errmessage alert alert-danger" style="display: none;"></div>
                    <div class="mchimp-sucmessage alert alert-primary" style="display: none;"></div>
                </form>
            <?php endif; ?>
        </div>

        <script>
        ;(function($){
            "use strict";
            $(document).ready(function () {
                // MAILCHIMP
                $(".mailchimp").ajaxChimp({
                    callback: mailchimpCallback,
                    url: "<?php echo esc_js($instance['email_url']) ?>"
                });
                $(".memail").on("focus", function () {
                    $(".mchimp-errmessage").fadeOut();
                    $(".mchimp-sucmessage").fadeOut();
                });
                $(".memail").on("keydown", function () {
                    $(".mchimp-errmessage").fadeOut();
                    $(".mchimp-sucmessage").fadeOut();
                });
                $(".memail").on("click", function () {
                    $(".memail").val("");
                });

                function mailchimpCallback(resp) {
                    if (resp.result === "success") {
                        $(".mchimp-sucmessage").html(resp.msg).fadeIn(1000);
                        $(".mchimp-sucmessage").fadeOut(3000);
                    } else if (resp.result === "error") {
                        $(".mchimp-errmessage").html(resp.msg).fadeIn(1000);
                    }
                }
            });
        })(jQuery)
    </script>
        <?php
        echo $after_widget;
    }

    function update($new_instance, $old_instance){
        $instance                    = $old_instance;
        $instance['title']           = strip_tags($new_instance['title']);
        $instance['content']        = $new_instance['content'];
        $instance['email_url']        = $new_instance['email_url'];
        $instance['email_placeholder']        = $new_instance['email_placeholder'];
        return $instance;
    }

    function form($instance){
        $defaults = array(
            'title'             => 'Newsletter',
            'content'          =>  'Best solution for your it startup business consecteturadipiscing elit.',
            'email_url'          => 'https://hibootstrap.us20.list-manage.com/subscribe/post?u=60e1ffe2e8a68ce1204cd39a5&amp;id=42d6d188d9',
            'email_placeholder'            => 'Enter email',
        );
        $instance = wp_parse_args((array)$instance, $defaults);
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">
                <?php esc_html_e('Title:', 'rola-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $instance['title']; ?>" />
            </label>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('content'); ?>">
                <?php esc_html_e('Content:', 'rola-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('content'); ?>" name="<?php echo $this->get_field_name('content'); ?>" type="text" value="<?php echo $instance['content']; ?>" />
            </label>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('email_url'); ?>">
                <?php esc_html_e('Action URL:', 'rola-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('email_url'); ?>" name="<?php echo $this->get_field_name('email_url'); ?>" type="text" value="<?php echo $instance['email_url']; ?>" />
            </label>
            <i>Enter here your MailChimp action URL. <a href="https://www.docs.hibootstrap.com/docs/rola-theme-documentation/tips-guides-troubleshoots/get-mailchimp-newsletter-form-action-url/" target="_blank"> How to </a></i>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('email_placeholder'); ?>">
                <?php esc_html_e('Placeholder Title:', 'rola-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('email_placeholder'); ?>" name="<?php echo $this->get_field_name('email_placeholder'); ?>" type="text" value="<?php echo $instance['email_placeholder']; ?>" />
            </label>
        </p>
        <?php
    }

}

function rola_register_newsletter() {
    register_widget('rola_newsletter');
}

add_action('widgets_init', 'rola_register_newsletter');


/**
 * Category Widget
 */
class Rola_cats extends WP_Widget{

    function __construct(){
        $widget_ops = array('description' => esc_html__('Display Category', 'rola-toolkit'));
        parent::__construct( false, esc_html__('Rola Sidebar Category', 'rola-toolkit'), $widget_ops);
    }

    function widget($args, $instance){

        extract($args);

        $title  = apply_filters('widget_title', $instance['title']);

        echo $before_widget;
        if($title) echo $before_title.$title.$after_title;
        ?>

            <?php $categories = get_terms( ['taxonomy' => 'category'] ); ?>

            <ul class="cus_widget_categories">
                <?php  $i = 1;
                foreach($categories as $key => $category) { ?>
                <li>
                    <div class="d-flex justify-content-between align-items-center">
                        <a href="<?php echo esc_url( get_term_link($category) ); ?>"><?php echo esc_html($category->name); ?></a>
                        <a href="<?php echo esc_url( get_term_link($category) ); ?>">(<?php echo esc_html($category->count); ?>)</a>
                    </div>
                </li>
                <?php if( $i == $instance['count_cat']  ){ break; }
                    $i++;
                } ?>
            </ul>

        <?php
        echo $after_widget;
    }

    function update($new_instance, $old_instance){
        $instance                       = $old_instance;
        $instance['title']              = strip_tags($new_instance['title']);
        $instance['count_cat']          = $new_instance['count_cat'];
        return $instance;
    }

    function form($instance){
        $defaults = array(
            'title'              => 'Category',
            'count_cat'          =>  '5',
        );
        $instance = wp_parse_args((array)$instance, $defaults);
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">
                <?php esc_html_e('Title:', 'rola-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $instance['title']; ?>" />
            </label>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('count_cat'); ?>">
                <?php esc_html_e('Category Count:', 'rola-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('count_cat'); ?>" name="<?php echo $this->get_field_name('count_cat'); ?>" type="text" value="<?php echo $instance['count_cat']; ?>" />
            </label>
        </p>
        <?php
    }

}

function Rola_register_cats() {
    register_widget('Rola_cats');
}

add_action('widgets_init', 'Rola_register_cats');