<?php
/**
 * The Template for displaying all single products
 *
 * This template can be overridden by copying it to rola/woocommerce/single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */
global $rola_opt;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

get_header( 'shop' );

if( function_exists('acf_add_options_page') ) {
	$hide_banner 		= get_field( 'enable_page_banner' );
	$hide_breadcrumb 	= get_field( 'hide_breadcrumb' );
	$custom_title 	    = get_field( 'enable_cus_pagetitle' );
    $banner_style 	    = get_field( 'choose_banner_style' );
    $bg_img             = get_field( 'post_banner_background_image' );
} else {
	$hide_banner 		= false;
	$hide_breadcrumb 	= false;
	$custom_title 	    = false;
    $banner_style 	    = 1;
    $bg_img             = '';
}

if( $hide_banner == false ){
    $page_spac = 'mt-80';
} else {
    $page_spac = '';
}

$page_shape1         = !empty($rola_opt['page_shape1']['url']) ? $rola_opt['page_shape1']['url'] : '';
$page_shape2         = !empty($rola_opt['page_shape2']['url']) ? $rola_opt['page_shape2']['url'] : '';

$product_sidebar    = isset( $rola_opt['product_sidebar']) ? $rola_opt['product_sidebar'] : '';

remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );
?>

    <?php if( $hide_banner == false ) { ?>
        <div class="page-banner-area">
            <div class="container">
				<?php if($banner_style == 1) : ?>
					<div class="row align-items-center">
						<div class="col-lg-6 col-md-6">
							<div class="page-banner-content">
								<?php if( $custom_title == true && get_field( 'cus_pagetitle' ) != '' ) { ?>
									<h2><?php echo esc_html( get_field( 'cus_pagetitle' ) ); ?></h2>
								<?php } else { ?>
									<h2><?php the_title(); ?></h2>
								<?php } ?>

								<?php if( $hide_breadcrumb == false ) : ?>
									<ul class="pages-list">
										<li><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'rola' ); ?></a></li>
										<li><?php the_title(); ?></li>
									</ul>
								<?php endif; ?>
							</div>
						</div>

						<?php if( $bg_img != '') : ?>
							<div class="col-lg-6 col-md-6">
								<div class="page-banner-image text-end">
									<img src="<?php echo esc_url( $bg_img ); ?>" alt="<?php esc_attr_e( 'Image', 'rola' ); ?>">
								</div>
							</div>
						<?php endif; ?>

					</div>
				<?php else: ?>
					<div class="page-banner-content text-center">
						<?php if( $custom_title == true && get_field( 'cus_pagetitle' ) != '' ) { ?>
							<h2><?php echo esc_html( get_field( 'cus_pagetitle' ) ); ?></h2>
						<?php } else { ?>
							<h2><?php the_title(); ?></h2>
						<?php } ?>

						<?php if( $hide_breadcrumb == false ) : ?>
							<ul class="pages-list">
								<li><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'rola' ); ?></a></li>
								<li><?php the_title(); ?></li>
							</ul>
						<?php endif; ?>
					</div>
				<?php endif; ?>

            </div>
			<?php if( $page_shape1 != '') : ?>
				<div class="page-banner-shape-1">
					<img src="<?php echo esc_url( $page_shape1 ); ?> " alt="<?php esc_attr_e( 'Shape1', 'rola' ); ?>">
				</div>
			<?php endif; ?>
			<?php if( $page_shape2 != '') : ?>
				<div class="page-banner-shape-2">
					<img src="<?php echo esc_url( $page_shape2 ); ?> " alt="<?php esc_attr_e( 'Shape2', 'rola' ); ?>">
				</div>
			<?php endif; ?>
        </div>
    <?php } ?>

    <div class="products_details ptb-100 <?php echo esc_attr( $page_spac ); ?>">
        <div class="container">
            <div class="row">                
                <?php if ( is_active_sidebar( 'shop' ) ): ?>
                    <?php if ( isset( $_GET['shop'] ) ): ?>
                        <?php  $rola_shop_cat_sidebar = $_GET['shop']; ?>
                        <?php if ( $rola_shop_cat_sidebar == 'none' ): ?>
                            <div class="col-lg-12 col-md-12">
                        <?php elseif ( $rola_shop_cat_sidebar == 'left' ): ?>
                            <?php do_action( 'woocommerce_sidebar' ); ?>
                            <div class="col-lg-8 col-md-12">
                        <?php elseif ( $rola_shop_cat_sidebar == 'right' ): ?>
                            <div class="col-lg-8 col-md-12">
                        <?php endif; ?>
                    <?php else: ?>
                        <?php if( $product_sidebar == 'left-sidebar' ): ?>
                            <?php do_action( 'woocommerce_sidebar' ); ?>
                            <div class="col-lg-8 col-md-12">
                        <?php elseif ( $product_sidebar == 'right-sidebar' ): ?>
                            <div class="col-lg-8 col-md-12">
                        <?php else: ?>
                            <div class="col-lg-12 col-md-12">
                        <?php endif; ?>
                    <?php endif; ?>
                <?php else: ?>
                    <div class="col-lg-12 col-md-12">
                <?php endif; ?>

                    <?php
                    /**
                     * woocommerce_before_main_content hook.
                     *
                     * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
                     * @hooked woocommerce_breadcrumb - 20
                     */

                    do_action( 'woocommerce_before_main_content' );

                        while ( have_posts() ) : the_post();

                            wc_get_template_part( 'content', 'single-product' );

                        endwhile;

                        /**
                         * woocommerce_after_main_content hook.
                         *
                         * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
                         */
                        do_action( 'woocommerce_after_main_content' );
                    ?>
                </div>
                <?php 
                if ( isset( $_GET['shop'] ) ):
                    if ( $rola_shop_cat_sidebar == 'right' ) :
                        do_action( 'woocommerce_sidebar' );
                    endif; 
                else:
                    if ( $product_sidebar == 'right-sidebar' ):
                        do_action( 'woocommerce_sidebar' );
                    endif; 
                endif; 
                ?>
            </div>
        </div>
    </div>
   
    <?php get_footer( 'shop' );
    /* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
    ?>
           
