<?php
$args = array(
    'post_type'           => 'product',
    'post_status'         => 'publish',
    'posts_per_page'      => '-1',
);
// Hide hidden items
$args['meta_query'][] = WC()->query->visibility_meta_query();

$product = new WP_Query( $args );

if ( $product->have_posts() ) :
    while ( $product->have_posts() ) :
        $product->the_post(); ?>
        <div class="modal productsQuickView fade" id="productsQuickView<?php echo esc_attr(get_the_ID());?>" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="products-image">
                            <?php the_post_thumbnail( 'full' ); ?>
                            </div>
                        </div>

                        <div class="col-lg-6">
                            <div class="content">
                                <h3><?php the_title(); ?></h3>
                                <?php woocommerce_template_loop_price(); ?>
                                <?php woocommerce_template_loop_rating(); ?>
                                <?php woocommerce_template_single_excerpt(); ?>

                                <div class="product_meta">
                                    <?php woocommerce_template_single_meta(); ?>
                                </div>

                                <a href="<?php the_permalink(); ?>" class="view-full-info"><?php esc_html_e( 'or View Full Info', 'rola' ); ?></a>

                                <?php  woocommerce_template_single_add_to_cart(); ?>

                                <?php if ( class_exists( 'YITH_WCWL' ) ) { ?>
                                    <a href="<?php echo esc_url( get_permalink( get_option( 'yith_wcwl_wishlist_page_id' ) ) ); ?>" class="add-to-wishlist-btn"><i class="bx bx-heart"></i></a>
                                <?php } ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    endwhile; 
endif;
wp_reset_query();