<?php
/**
 * Choose Area Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Rola_Choose_Area extends Widget_Base {

	public function get_name() {
        return 'RolaChooseArea';
    }

	public function get_title() {
        return esc_html__( 'Choose Area', 'rola-toolkit' );
    }

	public function get_icon() {
        return 'eicon-info-box';
    }

	public function get_categories() {
        return [ 'rolacategory' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'rola_choose_Area',
			[
				'label' => esc_html__( 'Choose Area', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );
            $this->add_control(
                'top_icon',
                [
                    'label'      => __( 'Icon', 'rola-toolkit' ),
                    'type' 	     => Controls_Manager::SELECT,
                    'options'    => rola_icons(),
                ]
            );
            $this->add_control(
                'top_title',
                [
                    'label'   => esc_html__( 'Top Title', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                ]
            );
            $this->add_control(
                'title',
                [
                    'label'   => esc_html__( 'Title', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXTAREA,
                ]
            );
            $this->add_control(
                'sec_desc',
                [
                    'label' => esc_html__( 'Description', 'rola-toolkit' ),
                    'type'  => Controls_Manager::TEXTAREA,
                ]
            );
            
            // Left Content
            $repeater_items = new Repeater();
            $repeater_items->add_control(
                'icon',
                [
                    'label' => __( 'Icon', 'rola-toolkit' ),
                    'type' 	     => Controls_Manager::SELECT,
                    'options'    => rola_icons(),
                ]
            );
            $repeater_items->add_control(
                'fea_title',
                [
                    'label'       => __(' Title', 'rola-toolkit'),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => __('Free Shipping', 'rola-toolkit'),
                    'label_block' => true,
                ]
            );
            $repeater_items->add_control(
                'fea_desc',
                [
                    'label'       => __('Description', 'rola-toolkit'),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => __('Free Shipping', 'rola-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'rola_left_items',
                [
                    'label'  => __( 'Add Feature Item', 'parco-toolkit' ),
                    'type'   => Controls_Manager::REPEATER,
                    'fields' => $repeater_items->get_controls(),
                ]
            );

            $this->add_control(
                'image',
                [
                    'label'  => esc_html__( 'Image', 'rola-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'video_icon',
                [
                    'label'      => __( 'Video Icon', 'rola-toolkit' ),
                    'type' 	     => Controls_Manager::SELECT,
                    'options'    => rola_icons(),
                ]
            );
            $this->add_control(
                'video_url',
                [
                    'label'       => __('Video URL', 'rola-toolkit'),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => 'https://www.youtube.com/watch?v=Buhosl-jJGA',
                    'label_block' => true,
                ]
            );
        $this->end_controls_section();

        // Style
        $this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_control(
                'top_title_color',
                [
                    'label'     => __( 'Top Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dental-tourism-choose-content span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'top_title_icolor',
                [
                    'label'     => __( 'Top Title Icon Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dental-tourism-choose-content span i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'top_title_bgcolor',
                [
                    'label'     => __( 'Top Title Background Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dental-tourism-choose-content span' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'top_title_typography',
                    'label'    => __( 'Top Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .dental-tourism-choose-content span',
                ]
            );

            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dental-tourism-choose-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => esc_html__( 'Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .dental-tourism-choose-content h3',
                ]
            );

            $this->add_control(
                'desc_color',
                [
                    'label' => esc_html__( 'Description Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dental-tourism-choose-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'desc_typography',
                    'label'    => esc_html__( 'Description Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .dental-tourism-choose-content p',
                ]
            );
            $this->add_control(
                'icon_color',
                [
                    'label' => esc_html__( 'Icon Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dental-tourism-choose-content .choose-inner-content i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'feature_list_color',
                [
                    'label' => esc_html__( 'Feature Title Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dental-tourism-choose-content .choose-inner-content h4' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'fea_lists_typography',
                    'label'    => esc_html__( 'Feature Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .dental-tourism-choose-content .choose-inner-content h4',
                ]
            );
            $this->add_control(
                'feature_desc_color',
                [
                    'label' => esc_html__( 'Feature Descriptino Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dental-tourism-choose-content .choose-inner-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'fea_desc_typography',
                    'label'    => esc_html__( 'Feature Descriptino Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .dental-tourism-choose-content .choose-inner-content p',
                ]
            );

            $this->add_control(
                'video_icon_color',
                [
                    'label' => esc_html__( 'Video Icon Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dental-tourism-choose-image .video-btn i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'video_icon_bgcolor',
                [
                    'label' => esc_html__( 'Video Icon Background Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dental-tourism-choose-image .video-btn i' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {

        $settings    = $this->get_settings_for_display();
        $left_items  = $settings['rola_left_items'];
    ?>
        <div class="dental-tourism-choose-area ptb-100">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6 col-md-12">
                        <div class="dental-tourism-choose-content">
                            <?php if( $settings['top_title'] != '' ) : ?>
                                <span>
                                    <i class="<?php echo esc_attr( $settings['top_icon'] ); ?>"></i>
                                    <?php echo esc_html( $settings['top_title'] ); ?>
                                </span>
                            <?php endif; ?>
                            <?php if( $settings['title'] != '' ) : ?>
                                <h3><?php echo wp_kses_post( $settings['title'] ); ?></h3>
                            <?php endif; ?>

                            <p><?php echo wp_kses_post( $settings['sec_desc'] ); ?></p>

                            <?php foreach ( $left_items as $item ) : ?>
                                <div class="choose-inner-content">
                                    <?php if( $item['icon'] != '') : ?>
                                        <i class="<?php echo esc_attr( $item['icon'] ); ?>"></i>
                                    <?php endif; ?>
                                    <h4><?php echo esc_html( $item['fea_title'] ); ?></h4>
                                    <p><?php echo esc_html( $item['fea_desc'] ); ?></p>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>

                    <div class="col-lg-6 col-md-12">
                        <div class="dental-tourism-choose-image">
                            <?php if( $settings['image']['url'] != '' ): ?>
                            <img src="<?php echo esc_url( $settings['image']['url'] ); ?>" alt="<?php  echo esc_attr__('image', 'rola-toolkit') ?>">
                            <?php endif; ?>

                            <?php if( $settings['video_url'] != '' ) : ?>
                            <a href="<?php echo esc_url( $settings['video_url'] ); ?>" class="video-btn popup-youtube">
                                <i class='<?php echo esc_attr( $settings['video_icon'] ); ?>' ></i>
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Rola_Choose_Area );