<?php
/**
 * Skin Care Dry Area Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Rola_SkinCareDry_Area extends Widget_Base {

	public function get_name() {
        return 'RolaSkinCareDry_Area';
    }

	public function get_title() {
        return esc_html__( 'Skin Care Dry Area', 'rola-toolkit' );
    }

	public function get_icon() {
        return 'eicon-info-box';
    }

	public function get_categories() {
        return [ 'rolacategory' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'rola_About_Area',
			[
				'label' => esc_html__( 'Skin Care Dry Area', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );
            $this->add_control(
                'top_icon',
                [
                    'label'      => __( 'Icon', 'rola-toolkit' ),
                    'type' 	     => Controls_Manager::SELECT,
                    'options'    => rola_icons(),
                ]
            );
            $this->add_control(
                'top_title',
                [
                    'label'   => esc_html__( 'Top Title', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                ]
            );
            $this->add_control(
                'title',
                [
                    'label'   => esc_html__( 'Title', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXTAREA,
                ]
            );
            $this->add_control(
                'sec_desc',
                [
                    'label' => esc_html__( 'Description', 'rola-toolkit' ),
                    'type'  => Controls_Manager::TEXTAREA,
                ]
            );

            // Left Content
            $repeater_items = new Repeater();
            $repeater_items->add_control(
                'icon',
                [
                    'label'      => __( 'Icon', 'rola-toolkit' ),
                    'type' 	     => Controls_Manager::SELECT,
                    'options'    => rola_icons(),
                ]
            );
            $repeater_items->add_control(
                'fea_title',
                [
                    'label'       => __(' Title', 'rola-toolkit'),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => __('Free Shipping', 'rola-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'rola_left_items',
                [
                    'label'  => __( 'Add Left Feature', 'parco-toolkit' ),
                    'type'   => Controls_Manager::REPEATER,
                    'fields' => $repeater_items->get_controls(),
                ]
            );
            // Right Content
            $repeater_items2 = new Repeater();
            $repeater_items2->add_control(
                'icon',
                [
                    'label'      => __( 'Icon', 'rola-toolkit' ),
                    'type' 	     => Controls_Manager::SELECT,
                    'options'    => rola_icons(),
                ]
            );
            $repeater_items2->add_control(
                'fea_title',
                [
                    'label'       => __(' Title', 'rola-toolkit'),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => __('Free Shipping', 'rola-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'rola_right_items',
                [
                    'label'  => __( 'Add Right Feature', 'parco-toolkit' ),
                    'type'   => Controls_Manager::REPEATER,
                    'fields' => $repeater_items2->get_controls(),
                ]
            );
            
            // Bottom Info Title
            $repeater_items3 = new Repeater();
            $repeater_items3->add_control(
                'btm_img',
                [
                    'label'  => __( 'Image', 'rola-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'rola_bottom_img',
                [
                    'label'  => __( 'Add Image', 'parco-toolkit' ),
                    'type'   => Controls_Manager::REPEATER,
                    'fields' => $repeater_items3->get_controls(),
                ]
            );
            $this->add_control(
                'review_text',
                [
                    'label' => __('Review Text', 'rola-toolkit'),
                    'type'  => Controls_Manager:: TEXT,
                ]
            );

            $this->add_control(
                'image',
                [
                    'label'  => esc_html__( 'Right Image', 'rola-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                ]
            );
        $this->end_controls_section();

        // Style
        $this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'rola-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_control(
                'top_title_color',
                [
                    'label'     => __( 'Top Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-dry-content span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'top_title_icolor',
                [
                    'label'     => __( 'Top Title Icon Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-dry-content span i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'top_title_typography',
                    'label'    => __( 'Top Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .skin-care-dry-content span',
                ]
            );

            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-dry-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => esc_html__( 'Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .skin-care-dry-content h3',
                ]
            );

            $this->add_control(
                'desc_color',
                [
                    'label' => esc_html__( 'Description Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-dry-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'desc_typography',
                    'label'    => esc_html__( 'Description Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .skin-care-dry-content p',
                ]
            );
            $this->add_control(
                'icon_color',
                [
                    'label' => esc_html__( 'List Icon Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-dry-content .list li i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'icon_bgcolor',
                [
                    'label' => esc_html__( 'Icon Background Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-dry-content .list li i' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'feature_list_color',
                [
                    'label' => esc_html__( 'Feature Lists Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-dry-content .list li' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'fea_lists_typography',
                    'label'    => esc_html__( 'Feature Lists Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .skin-care-dry-content .list li',
                ]
            );
            $this->add_control(
                'img_border_color',
                [
                    'label' => esc_html__( 'Image Border Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-dry-content .dry-list li img' => 'border-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'review_color',
                [
                    'label' => esc_html__( 'Review Text Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-dry-content .dry-list li.title' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'rt_typography',
                    'label'    => esc_html__( 'Review Text Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}}  .skin-care-dry-content .dry-list li.title',
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {

        $settings    = $this->get_settings_for_display();
        $left_items  = $settings['rola_left_items'];
        $right_items = $settings['rola_right_items'];
        $bottom_imgs = $settings['rola_bottom_img'];

        $review_text  = $settings['review_text'];
    ?>

        <div class="skin-care-dry-area ptb-100">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-7 col-md-12">
                        <div class="skin-care-dry-content">
                            <?php if( $settings['top_title'] != '' ) : ?>
                                <span>
                                    <i class="<?php echo esc_attr( $settings['top_icon'] ); ?>"></i>
                                    <?php echo esc_html( $settings['top_title'] ); ?>
                                </span>
                            <?php endif; ?>

                            <?php if( $settings['title'] != '' ) : ?>
                                <h3><?php echo wp_kses_post( $settings['title'] ); ?></h3>
                            <?php endif; ?>

                            <p><?php echo wp_kses_post( $settings['sec_desc'] ); ?></p>

                            <div class="row">
                                <div class="col-lg-6 col-md-6">
                                    <ul class="list">
                                        <?php foreach ( $left_items as $item ) : ?>
                                            <li>
                                                <?php if( $item['icon'] != '') : ?>
                                                    <i class="<?php echo esc_attr( $item['icon'] ); ?>"></i>
                                                <?php endif; ?>
                                                <?php echo esc_html( $item['fea_title'] ); ?>
                                            </li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                                <div class="col-lg-6 col-md-6">
                                    <ul class="list">
                                        <?php foreach ( $right_items as $item ) : ?>
                                            <li>
                                                <?php if( $item['icon'] != '') : ?>
                                                    <i class="<?php echo esc_attr( $item['icon'] ); ?>"></i>
                                                <?php endif; ?>

                                                <?php echo esc_html( $item['fea_title'] ); ?>
                                            </li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                            </div>
                            <ul class="dry-list">
                                <?php foreach ( $bottom_imgs as $item ) : ?>
                                    <?php if( $item['btm_img']['url'] != '' ): ?>
                                    <li>
                                        <img src="<?php echo esc_url( $item['btm_img']['url']); ?>" class="rounded-circle" alt="<?php echo esc_attr__('image','rola-toolkit');?> ">
                                    </li>
                                    <?php endif; ?>
                                <?php endforeach; ?>

                                <?php if( $settings['review_text'] != '' ) : ?>
                                <li class="title"><?php echo esc_html( $settings['review_text'] ); ?></li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </div>

                    <?php if( $settings['image']['url'] != '' ): ?>
                    <div class="col-lg-5 col-md-12">
                        <div class="skin-care-dry-image">
                            <img src="<?php echo esc_url( $settings['image']['url']); ?>" alt="<?php echo esc_attr__('image','rola-toolkit');?> ">
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <?php
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Rola_SkinCareDry_Area );