<?php
/**
 * Hospital Area Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Rola_Hospital_Area extends Widget_Base {

	public function get_name() {
        return 'Rola_Hospital';
    }

	public function get_title() {
        return esc_html__( 'Hospital Area', 'rola-toolkit' );
    }

	public function get_icon() {
        return 'eicon-info-box';
    }

	public function get_categories() {
        return [ 'rolacategory' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'rola_hospital_Area',
			[
				'label' => esc_html__( 'Hospital Area', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );
            $this->add_control(
                'top_title',
                [
                    'label'   => esc_html__( 'Top Title', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                ]
            );
            $this->add_control(
                'title',
                [
                    'label'   => esc_html__( 'Title', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXTAREA,
                ]
            );
            $this->add_control(
                'sec_desc',
                [
                    'label' => esc_html__( 'Description', 'rola-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                ]
            );

            $this->add_control(
                'button_text',
                [
                    'label' => __('Button Text', 'rola-toolkit'),
                    'type'  => Controls_Manager:: TEXT,
                ]
            );
            $this->add_control(
                'link_type',
                [
                    'label' => __( 'Link Type', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        '1'   => __( 'Link To Page', 'rola-toolkit' ),
                        '2'   => __( 'External Link', 'rola-toolkit' ),
                    ],
                ]
            );
            $this->add_control(
                'link_to_page',
                [
                    'label' => __( 'Link Page', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options'     => rola_toolkit_get_page_as_list(),
                    'condition'   => [
                        'link_type' => '1',
                    ]
                ]
            );
            $this->add_control(
                'external_link',
                [
                    'label' => __('External Link', 'rola-toolkit'),
                    'type'  => Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type' => '2',
                    ]
                ]
            );
        $this->end_controls_section();

        // Right Posts
        $this->start_controls_section(
			'rola_hos_right_Area',
			[
				'label' => esc_html__( 'Post Control', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );
            $this->add_control(
                'order',
                [
                    'label'   => __( 'Services Order By', 'rola-toolkit' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'DESC'      => __( 'DESC', 'rola-toolkit' ),
                        'ASC'       => __( 'ASC', 'rola-toolkit' ),
                    ],
                    'default' => 'DESC',
                ]
            );
            $this->add_control(
                'count',
                [
                    'label'   => __( 'Post Per Page', 'rola-toolkit' ),
                    'type'    => Controls_Manager::NUMBER,
                    'default' => 2,
                ]
            );
            $this->add_control(
                'excerpt_num',
                [
                    'label'   => __( 'Post Per Page', 'rola-toolkit' ),
                    'type'    => Controls_Manager::NUMBER,
                    'default' => 14,
                ]
            );
            $this->add_control(
                'cat_name',
                [
                    'label' => __( 'Choose Category', 'rola-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => rola_toolkit_get_page_services_cat_el(),
                ]
            );
        $this->end_controls_section();

        // Progress Chart
        $this->start_controls_section(
			'rola_hospital_chart_Area',
			[
				'label' => esc_html__( 'Chart Control', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );

            // Right Content
            $repeater_items = new Repeater();
            $repeater_items->add_control(
                'chart_title',
                [
                    'label'       => __(' Title', 'rola-toolkit'),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => __('Free Shipping', 'rola-toolkit'),
                    'label_block' => true,
                ]
            );
            $repeater_items->add_control(
                'chart_percentage',
                [
                    'label'       => __('Percentage', 'rola-toolkit'),
                    'type'        => Controls_Manager::NUMBER,
                    'default'     => 70,
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'rola_chart_items',
                [
                    'label'  => __( 'Add Chart Items', 'parco-toolkit' ),
                    'type'   => Controls_Manager::REPEATER,
                    'fields' => $repeater_items->get_controls(),
                ]
            );
        $this->end_controls_section();

        // Styling Control
        $this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'rola-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_control(
                'bg_color',
                [
                    'label'     => __( 'Background Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .hospital-area::before' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'top_title_color',
                [
                    'label'     => __( 'Top Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .hospital-content .sub-title' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'top_title_icolor',
                [
                    'label'     => __( 'Top Title Icon Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .hospital-content .sub-title i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'top_title_bgcolor',
                [
                    'label'     => __( 'Top Title Background Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .hospital-content .sub-title' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'top_title_typography',
                    'label'    => __( 'Top Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .hospital-content .sub-title',
                ]
            );

            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .hospital-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => esc_html__( 'Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .hospital-content h3',
                ]
            );

            $this->add_control(
                'desc_color',
                [
                    'label' => esc_html__( 'Description Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .hospital-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'desc_typography',
                    'label'    => esc_html__( 'Description Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .hospital-content p',
                ]
            );
            $this->add_control(
                'btn_color',
                [
                    'label' => esc_html__( 'Button Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .hospital-content .hospital-btn .default-btn' => 'color: {{VALUE}} !important',
                    ],
                ]
            );
            $this->add_control(
                'btn_bgcolor',
                [
                    'label' => esc_html__( 'Button Background Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .hospital-content .hospital-btn .default-btn' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => esc_html__( 'Button Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .hospital-content .hospital-btn .default-btn',
                ]
            );

            $this->add_control(
                'post_titlecolor',
                [
                    'label' => esc_html__( 'Post Title Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-hospital-card h3 a' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'post_title_typography',
                    'label'    => esc_html__( 'Post Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-hospital-card h3 a',
                ]
            );
            $this->add_control(
                'post_concolor',
                [
                    'label' => esc_html__( 'Post Excerpt Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-hospital-card p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'post_excerpt_typography',
                    'label'    => esc_html__( 'Post Excerpt Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-hospital-card p',
                ]
            );

            $this->add_control(
                'chart_circle_color',
                [
                    'label' => esc_html__( 'Circle Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-hospital-box .circlechart .circle-chart .circle-chart__circle' => 'stroke: {{VALUE}} !important',
                    ],
                ]
            );
            $this->add_control(
                'chart_percentage_color',
                [
                    'label' => esc_html__( 'Percentage Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-hospital-box .circlechart .circle-chart' => 'fill: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'chart_title_color',
                [
                    'label' => esc_html__( 'Chart Title Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-hospital-box span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'chart_title_typography',
                    'label'    => esc_html__( 'Chart Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-hospital-box span',
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {

        $settings     = $this->get_settings_for_display();
        $chart_items  = $settings['rola_chart_items'];

        // Button link
        $btn_text  = $settings['button_text'];

        $link_one = '';
        if( $settings['link_type'] == 1 ){
            $link_one = get_page_link( $settings['link_to_page'] ); 
        } else {
            $link_one = $settings['external_link'];
        } 
        
        // Services Query
        if( $settings['cat_name'] != '' ) {
            $args = array(
                'post_type'         => 'service',
                'posts_per_page'    => $settings['count'],
                'order'             => $settings['order'],
                'tax_query'         => array(
                    array(
                        'taxonomy'      => 'service_cat',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false,
                    )
                )
            );
        } else {
            $args = array(
                'post_type'           => 'service',
                'posts_per_page'      => $settings['count'],
                'order'               => $settings['order'],
            );
        }
        $services_array = new \WP_Query( $args );
        
        ?>

        <div class="hospital-area ptb-100">
            <div class="container">
                <div class="row align-items-center">
                    <?php if( $settings['top_title'] != '' || $settings['title'] != '' || $settings['sec_desc'] != '' || $btn_text != '') : ?>
                    <div class="col-lg-6 col-md-12">
                        <div class="hospital-content">
                            <?php if( $settings['top_title'] != '' ) : ?>
                                <span class="sub-title">
                                    <i class="flaticon-teeth"></i>
                                    <?php echo esc_html( $settings['top_title'] ); ?>
                                </span>
                            <?php endif; ?>

                            <?php if( $settings['title'] != '' ) : ?>
                                <h3><?php echo wp_kses_post( $settings['title'] ); ?></h3>
                            <?php endif; ?>

                            <p><?php echo wp_kses_post( $settings['sec_desc'] ); ?></p>

                            <?php if( $btn_text != '') : ?>
                                <div class="hospital-btn">
                                    <a href="<?php echo esc_url($link_one); ?>" class="default-btn"><?php echo esc_html( $btn_text ); ?></a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-12">
                    <?php else: ?>
                    <div class="col-lg-12 col-md-12">
                    <?php endif; ?>

                        <div class="hospital-right-content">
                            <div class="row">
                                <?php while( $services_array->have_posts() ): 
                                $services_array->the_post();
                                if ( class_exists('ACF') ) {
                                    if ( get_field('choose_link_type') == 1 ) {
                                        $post_link = get_the_permalink();
                                    } else {
                                        $post_link = get_field('external_link');
                                    }
                                    $icon = get_field('service_icon');
                                } else {
                                    $post_link = get_field('external_link');
                                    $icon      = '';
                                } ?>
                                <div class="col-lg-6 col-sm-6">
                                    <div class="single-hospital-card">
                                        <?php if($icon != '') : ?>
                                            <div class="icon">
                                                <i class="<?php echo esc_attr( $icon ); ?>"></i>
                                            </div>
                                        <?php endif; ?>
                                        <h3>
                                            <a href="<?php echo esc_url( $post_link ); ?>">
                                                <?php the_title(); ?>
                                            </a>
                                        </h3>
                                        <p><?php echo esc_html(wp_trim_words( get_the_excerpt(), $settings['excerpt_num'], '' )); ?></p>
                                    </div>
                                </div>
                                <?php endwhile;
                                wp_reset_postdata(); ?>
                            </div>

                            <div class="row justify-content-center">
                                <?php foreach ( $chart_items as $item ) : ?>
                                    <div class="col-lg-4 col-md-4 col-6 col-sm-4">
                                        <div class="single-hospital-box">
                                            <div class="circlechart" data-percentage="<?php echo esc_attr( $item['chart_percentage'] ); ?>"></div>
                                            <span><?php echo esc_html( $item['chart_title'] ); ?></span>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Rola_Hospital_Area );