<?php
/**
 * Eye Care Services Widget
 */

namespace Elementor;
class Rola_EyeCare_Services extends Widget_Base {

	public function get_name() {
        return 'Rola_EyeCareServices';
    }

	public function get_title() {
        return __( 'Eye Care Services', 'rola-toolkit' );
    }

	public function get_icon() {
        return 'eicon-tools';
    }

	public function get_categories() {
        return [ 'rolacategory' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'services_section',
			[
				'label' => __( 'Eye Care Services', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'bg_image',
                [
                    'label' => __( 'Background Image', 'rola-toolkit' ),
                    'type'  => Controls_Manager::MEDIA,
                ]
            );

            $this->add_control(
                'icon',
                [
                    'label'      => __( ' Icon', 'rola-toolkit' ),
                    'type' 	     => Controls_Manager::SELECT,
                    'options'    => rola_icons(),
                ]
            );
            $this->add_control(
                'top_title', [
                    'label'       => __( 'Top Title', 'rola-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                    'default'     => __( 'What Clients Say', 'rola-toolkit' ),
                ]
            );
            $this->add_control(
                'title', [
                    'label'       => __( 'Title', 'rola-toolkit' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'label_block' => true,
                    'default'     => __( 'What Clients Say', 'rola-toolkit' ),
                ]
            );
            $this->add_control(
                'heading_tag', [
                    'label'   => __( 'Title Heading Tag', 'rola-toolkit' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                    'default'     => 'h2',
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'order',
                [
                    'label'   => __( 'Services Order By', 'rola-toolkit' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'DESC'      => __( 'DESC', 'rola-toolkit' ),
                        'ASC'       => __( 'ASC', 'rola-toolkit' ),
                    ],
                    'default' => 'DESC',
                ]
            );

            $this->add_control(
                'count',
                [
                    'label'   => __( 'Post Per Page', 'rola-toolkit' ),
                    'type'    => Controls_Manager::NUMBER,
                    'default' => 6,
                ]
            );
            $this->add_control(
                'excerpt_num',
                [
                    'label'   => __( 'Excerpt', 'rola-toolkit' ),
                    'type'    => Controls_Manager::NUMBER,
                    'default' => 14,
                ]
            );

            $this->add_control(
                'cat_name',
                [
                    'label'   => __( 'Choose Category', 'rola-toolkit' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => rola_toolkit_get_page_services_cat_el(),
                ]
            );
            $this->add_control(
                'learn_text',
                [
                    'label' => __('Learn More Text', 'rola-toolkit'),
                    'type'  => Controls_Manager:: TEXT,
                ]
            );



            $this->add_control(
                'button_text',
                [
                    'label' => __('Button Text', 'rola-toolkit'),
                    'type'  => Controls_Manager:: TEXT,
                ]
            );
            $this->add_control(
                'link_type',
                [
                    'label' => __( 'Link Type', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        '1'   => __( 'Link To Page', 'rola-toolkit' ),
                        '2'   => __( 'External Link', 'rola-toolkit' ),
                    ],
                ]
            );
            $this->add_control(
                'link_to_page',
                [
                    'label' => __( 'Link Page', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options'     => rola_toolkit_get_page_as_list(),
                    'condition'   => [
                        'link_type' => '1',
                    ]
                ]
            );
            $this->add_control(
                'external_link',
                [
                    'label' => __('External Link', 'rola-toolkit'),
                    'type'  => Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type' => '2',
                    ]
                ]
            );
        $this->end_controls_section();
        
        // Style
        $this->start_controls_section(
			'service_style',
			[
				'label' => __( 'Style', 'rola-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
			]
        );
            $this->add_control(
                'bg_color',
                [
                    'label'     => __( 'Background Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-services-area::before' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'toptitle_color',
                [
                    'label'     => __( 'Top Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-services-area .section-title span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'toptitle_typography',
                    'label'    => __( 'Top Title Typography', 'rola-toolkit' ),
                     
                    'selector' => '{{WRAPPER}} .eye-care-services-area .section-title span',
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label'     => __( 'Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-services-area .section-title h2, .eye-care-services-area .section-title h1, .eye-care-services-area .section-title h3, .eye-care-services-area .section-title h4, .eye-care-services-area .section-title h5, .eye-care-services-area .section-title h6' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .eye-care-services-area .section-title h2, .eye-care-services-area .section-title h1, .eye-care-services-area .section-title h3, .eye-care-services-area .section-title h4, .eye-care-services-area .section-title h5, .eye-care-services-area .section-title h6',
                ]
            );

            $this->add_control(
                'cardbgcolor',
                [
                    'label'     => __( 'Card Background Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-services-card' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'icon_color',
                [
                    'label'     => __( 'Icon Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-services-card .icon i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'icon_bgcolor',
                [
                    'label'     => __( 'Icon Background Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-services-card .icon i' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'postti_color',
                [
                    'label'     => __( 'Post Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-services-card h3 a' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'post_t_typography',
                    'label'    => __( 'Post Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .eye-care-services-card h3 a',
                ]
            );
            $this->add_control(
                'ex_color',
                [
                    'label'     => __( 'Excerpt Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-services-card p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'ex_typography',
                    'label'    => __( 'Excerpt Typography', 'rola-toolkit' ),
                     
                    'selector' => '{{WRAPPER}} .eye-care-services-card p',
                ]
            );
            $this->add_control(
                'lmb_color',
                [
                    'label'     => __( 'Learn More Button Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-services-card .default-btn' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'lmb_bgcolor',
                [
                    'label'     => __( 'Learn More Button Background Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-services-card .default-btn' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'llmb_typography',
                    'label'    => __( 'Learn More Button Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .eye-care-services-card .default-btn',
                ]
            );
            $this->add_control(
                'sercolor',
                [
                    'label'     => __( 'Button Text Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-all-services-link a' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'bbbt_typography',
                    'label'    => __( 'Button Text Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .eye-care-all-services-link a',
                ]
            );
            $this->add_control(
                'numcolor',
                [
                    'label'     => __( 'Number Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-services-card .number' => 'color: {{VALUE}}',
                    ],
                ]
            );
           
        $this->end_controls_section();
    }

	protected function render() {
        $settings = $this->get_settings_for_display();

        // Button link
        $learn_text = $settings['learn_text'];
        $btn_text  = $settings['button_text'];

        $link_one = '';
        if( $settings['link_type'] == 1 ){
            $link_one = get_page_link($settings['link_to_page']); 
        } else {
            $link_one = $settings['external_link'];
        } 

        global $rola_opt;
        // Services Query
        if( $settings['cat_name'] != '' ) {
            $args = array(
                'post_type'         => 'service',
                'posts_per_page'    => $settings['count'],
                'order'             => $settings['order'],
                'tax_query'         => array(
                    array(
                        'taxonomy'      => 'service_cat',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false,
                    )
                )
            );
        } else {
            $args = array(
                'post_type'           => 'service',
                'posts_per_page'      => $settings['count'],
                'order'               => $settings['order'],
            );
        }
        $services_array = new \WP_Query( $args ); ?>

        <div class="eye-care-services-area pt-100 pb-100" style="background-image: url(<?php echo esc_url( $settings['bg_image']['url']); ?> )">
            <div class="container">
                <?php if( $settings['top_title'] != '' ||  $settings['title'] != '') : ?>
                <div class="section-title">
                    <?php if( $settings['top_title'] != '' ) : ?>
                        <span>
                            <?php if( $settings['icon'] != '' ) : ?>
                                <i class="<?php echo esc_attr( $settings['icon'] ); ?>"></i>
                            <?php endif; ?>
                            <?php echo esc_html( $settings['top_title'] ); ?>
                        </span>
                    <?php endif; ?>

                    <<?php echo esc_attr( $settings['heading_tag'] ); ?>><?php echo wp_kses_post( $settings['title'] ); ?></<?php echo esc_attr( $settings['heading_tag'] ); ?>>
                </div>
                <?php endif; ?>

                <div class="eye-care-services-slides owl-carousel owl-theme">
                    <?php $i = 1; while( $services_array->have_posts() ): 
                        $services_array->the_post();
                        if ( class_exists('ACF') ) {
                            if ( get_field('choose_link_type') == 1 ) {
                                $post_link = get_the_permalink();
                            } else {
                                $post_link = get_field('external_link');
                            }
                            $icon = get_field('service_icon');
                        } else {
                            $post_link = get_field('external_link');
                            $icon      = '';
                        }
                    ?>
                    <div class="eye-care-services-card">
                        <?php if($icon != '') : ?>
                            <div class="icon">
                                <i class="<?php echo esc_attr( $icon ); ?>"></i>
                            </div>
                        <?php endif; ?>
                        <h3>
                            <a href="<?php echo esc_url( $post_link ); ?>">
                                <?php the_title(); ?>
                            </a>
                        </h3>
                        <p><?php echo esc_html(wp_trim_words( get_the_excerpt(), $settings['excerpt_num'], '' )); ?></p>

                        <?php if( $learn_text != '' ) : ?>
                        <a href="<?php echo esc_url( $post_link ); ?>" class="default-btn"><?php echo esc_html( $learn_text ); ?> </a>
                        <?php endif; ?>
                        
                        <div class="number"><?php echo $i; ?></div>
                    </div>
                    <?php $i++; endwhile;
                    wp_reset_postdata(); ?>
                </div>

                <?php if( $btn_text != '' ) : ?>
                <div class="eye-care-all-services-link">
                    <a href="<?php echo esc_url($link_one); ?>"><?php echo esc_html( $btn_text ); ?></a>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <?php
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Rola_EyeCare_Services );