<?php
/**
 * Team Widget
 */

namespace Elementor;
class Rola_Doctor extends Widget_Base {

	public function get_name() {
        return 'Rola_Doctor';
    }

	public function get_title() {
        return __( 'Doctor', 'rola-toolkit' );
    }

	public function get_icon() {
        return 'eicon-tools';
    }

	public function get_categories() {
        return [ 'rolacategory' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'teams_section',
			[
				'label' => __( 'Doctor', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'choose_style',
                [
                    'label' => __( 'Choose Style', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'options' => [
                        '1'   => __( 'Style one', 'rola-toolkit' ),
                        '2'   => __( 'Style two', 'rola-toolkit' ),
                        '3'   => __( 'Style three', 'rola-toolkit' ),
                        '4'   => __( 'Style four', 'rola-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );

            $this->add_control(
                'columns',
                [
                    'label' => __( 'Choose Columns', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'options' => [
                        '2'   => __( '2', 'rola-toolkit' ),
                        '3'   => __( '3', 'rola-toolkit' ),
                        '4'   => __( '4', 'rola-toolkit' ),
                    ],
                    'default' => '3',
                    'condition' => [
                        'choose_style' => ['2','3'],
                    ]
                ]
            );
            $this->add_control(
                'order',
                [
                    'label'   => __( 'Order By', 'rola-toolkit' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'DESC'      => __( 'DESC', 'rola-toolkit' ),
                        'ASC'       => __( 'ASC', 'rola-toolkit' ),
                    ],
                    'default' => 'DESC',
                ]
            );

            $this->add_control(
                'count',
                [
                    'label'   => __( 'Post Per Page', 'rola-toolkit' ),
                    'type'    => Controls_Manager::NUMBER,
                    'default' => 6,
                ]
            );

            $this->add_control(
                'cat_name',
                [
                    'label' => __( 'Choose Category', 'rola-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => rola_toolkit_get_page_doctor_cat_el(),
                ]
            );

            $this->add_control(
                'show_social_list',
                [
                    'label'        => __( 'Social List Hide/Show?', 'rola-toolkit' ),
                    'type'         => Controls_Manager::SWITCHER,
                    'label_on'     => __( 'Show', 'rola-toolkit' ),
                    'label_off'    => __( 'Hide', 'rola-toolkit' ),
                    'return_value' => 'yes',
                    'default'      => 'yes',
                ]
            );

        $this->end_controls_section();
        
        // Style
        $this->start_controls_section(
			'team_wid_style',
			[
				'label' => __( 'Style', 'rola-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
			]
        );
            $this->add_control(
                'title_color',
                [
                    'label'     => __( 'Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-doctor-card .doctor-content h3 a, .single-doctor-box .doctor-content h3 a, .dental-tourism-dentist-card .dentist-content h3 a' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'rola-toolkit' ),
                    
                    'selector' => '{{WRAPPER}} .single-doctor-card .doctor-content h3 a, .single-doctor-box .doctor-content h3 a, .dental-tourism-dentist-card .dentist-content h3 a',
                ]
            );
            $this->add_control(
                'des_color',
                [
                    'label'     => __( 'Designation Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-doctor-card .doctor-content span, .single-doctor-box .doctor-content span, .dental-tourism-dentist-card .dentist-content span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'des_typography',
                    'label'    => __( 'Designation Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-doctor-card .doctor-content span, .single-doctor-box .doctor-content span, .dental-tourism-dentist-card .dentist-content span',
                ]
            );
            $this->add_control(
                'icon_color',
                [
                    'label'     => __( 'Social Icon Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dental-tourism-dentist-card .dentist-image .share-link li a i, .single-doctor-card .doctor-image .share-link a i, .single-doctor-box .doctor-content .share-link a i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'icon_border_color',
                [
                    'label'     => __( 'Social Icon Border Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dental-tourism-dentist-card .dentist-image .share-link li a i, .single-doctor-card .doctor-image .share-link a i, .single-doctor-box .doctor-content .share-link a i' => 'border-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'icon_bgcolor',
                [
                    'label'     => __( 'Social Icon Background Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-doctor-card .doctor-image .share-link a i, .dental-tourism-dentist-card .dentist-image .share-link li a i, .single-doctor-box .doctor-content .share-link a i' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {
        $settings = $this->get_settings_for_display();

        // Card Columns
        $columns = $settings['columns'];
        if ( $columns == '2' ) {
            $column = 'col-lg-6 col-md-6';
        } elseif ( $columns == '3' ) {
            $column = 'col-lg-4 col-md-4';
        } elseif ( $columns == '4' ) {
            $column = 'col-lg-3 col-md-4';
        }
        
        // Doctor Query
        if( $settings['cat_name'] != '' ) {
            $args = array(
                'post_type'         => 'doctor',
                'posts_per_page'    => $settings['count'],
                'order'             => $settings['order'],
                'tax_query'         => array(
                    array(
                        'taxonomy'      => 'doctor_cat',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false,
                    )
                )
            );
        } else {
            $args = array(
                'post_type'           => 'doctor',
                'posts_per_page'      => $settings['count'],
                'order'               => $settings['order'],
            );
        }
        $team_array = new \WP_Query( $args );
        ?>

        <?php if ( $settings['choose_style'] == '1' ) : ?>
            <div class="container">
                <div class="doctor-slides owl-carousel owl-theme">
                    <?php while( $team_array->have_posts() ): 
                    $team_array->the_post();

                    if ( class_exists('ACF') && get_field('choose_link_type') == 1 ) {
                        $post_link = get_the_permalink();
                    } else {
                        $post_link = get_field('external_link');
                    } 
                    // ACF Fields
                    if ( class_exists( 'ACF') ) {
                        $designation  = get_field('doctor_designation');
                    }else{
                        $designation  = '';
                    } ?>
                    <div class="single-doctor-card">
                        <div class="doctor-image">
                            <?php if( !empty( get_the_post_thumbnail_url() )) { ?>
                                <a href="<?php echo esc_url( $post_link ); ?>">
                                    <img src="<?php echo esc_url(get_the_post_thumbnail_url()); ?>" alt="<?php echo esc_attr__('image','rola-toolkit'); ?>">
                                </a>
                            <?php } ?>

                            <?php if ( $settings['show_social_list'] == 'yes' ) :
                                if( have_rows('choose_social_icons') ) : ?>
                                <div class="share-link">
                                    <?php while( have_rows('choose_social_icons') ): the_row(); ?>
                                        <a href="<?php echo esc_url( get_sub_field('link') ); ?>" target="_blank"><i class='<?php echo esc_attr( get_sub_field('choose_doctor_icon') ); ?>'></i>
                                        </a>
                                    <?php endwhile; ?>
                                </div>
                                <?php endif;
                            endif; ?>
                        </div>
                        <div class="doctor-content">
                            <h3><a href="<?php echo esc_url( $post_link ); ?>"><?php the_title(); ?></a></h3>
                            <span><?php echo esc_html( $designation ); ?></span>
                        </div>
                    </div>
                    <?php endwhile;
                    wp_reset_postdata(); ?>
                </div>
            </div>
        <?php elseif ( $settings['choose_style'] == '2' ) : ?>
            <div class="container">
                <div class="row justify-content-center">
                    <?php while( $team_array->have_posts() ): 
                        $team_array->the_post();

                        if ( class_exists('ACF') && get_field('choose_link_type') == 1 ) {
                            $post_link = get_the_permalink();
                        } else {
                            $post_link = get_field('external_link');
                        } 
                        // ACF Fields
                        if ( class_exists( 'ACF') ) {
                            $designation  = get_field('doctor_designation');
                        }else{
                            $designation  = '';
                        } ?>

                        <div class="<?php echo $column; ?>">
                            <div class="single-doctor-card">
                                <div class="doctor-image">
                                    <?php if( !empty( get_the_post_thumbnail_url() )) { ?>
                                        <a href="<?php echo esc_url( $post_link ); ?>">
                                            <img src="<?php the_post_thumbnail_url( 'full' ) ?>" alt="<?php echo esc_attr__('image','rola-toolkit'); ?>">
                                        </a>
                                    <?php } ?>

                                    <?php if ( $settings['show_social_list'] == 'yes' ) :
                                        if( have_rows('choose_social_icons') ) : ?>
                                        <div class="share-link">
                                            <?php while( have_rows('choose_social_icons') ): the_row(); ?>
                                                <a href="<?php echo esc_url( get_sub_field('link') ); ?>" target="_blank"><i class='<?php echo esc_attr( get_sub_field('choose_doctor_icon') ); ?>'></i>
                                                </a>
                                            <?php endwhile; ?>
                                        </div>
                                        <?php endif;
                                    endif; ?>
                                </div>
                                <div class="doctor-content">
                                    <h3><a href="<?php echo esc_url( $post_link ); ?>"><?php the_title(); ?></a></h3>
                                    <span><?php echo esc_html( $designation ); ?></span>
                                </div>
                            </div>
                        </div>
                    <?php endwhile;
                    wp_reset_postdata(); ?>
                </div>
            </div>
        <?php elseif ( $settings['choose_style'] == '3' ) : ?>
            <div class="container">
                <div class="row">
                    <?php while( $team_array->have_posts() ): 
                        $team_array->the_post();

                        if ( class_exists('ACF') && get_field('choose_link_type') == 1 ) {
                            $post_link = get_the_permalink();
                        } else {
                            $post_link = get_field('external_link');
                        } 
                        // ACF Fields
                        if ( class_exists( 'ACF') ) {
                            $designation  = get_field('doctor_designation');
                        }else{
                            $designation  = '';
                        } ?>

                        <div class="<?php echo $column; ?>">
                            <div class="single-doctor-box">
                                <?php if( !empty( get_the_post_thumbnail_url() )) { ?>
                                    <a href="<?php echo esc_url( $post_link ); ?>">
                                        <img src="<?php the_post_thumbnail_url( 'full' ) ?>" alt="<?php echo esc_attr__('image','rola-toolkit'); ?>">
                                    </a>
                                <?php } ?>

                                <div class="doctor-content">
                                    <h3><a href="<?php echo esc_url( $post_link ); ?>"><?php the_title(); ?></a></h3>
                                    <span><?php echo esc_html( $designation ); ?></span>

                                    <?php if ( $settings['show_social_list'] == 'yes' ) :
                                        if( have_rows('choose_social_icons') ) : ?>
                                        <div class="share-link">
                                            <?php while( have_rows('choose_social_icons') ): the_row(); ?>
                                                <a href="<?php echo esc_url( get_sub_field('link') ); ?>" target="_blank"><i class='<?php echo esc_attr( get_sub_field('choose_doctor_icon') ); ?>'></i>
                                                </a>
                                            <?php endwhile; ?>
                                        </div>
                                        <?php endif;
                                    endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endwhile;
                    wp_reset_postdata(); ?>
                </div>
            </div>
        <?php else: ?>
            <div class="container">
                <div class="dental-tourism-dentist-slides owl-carousel owl-theme">
                    <?php while( $team_array->have_posts() ): 
                    $team_array->the_post();

                    if ( class_exists('ACF') && get_field('choose_link_type') == 1 ) {
                        $post_link = get_the_permalink();
                    } else {
                        $post_link = get_field('external_link');
                    } 
                    // ACF Fields
                    if ( class_exists( 'ACF') ) {
                        $designation  = get_field('doctor_designation');
                    }else{
                        $designation  = '';
                    } ?>
                    <div class="dental-tourism-dentist-card">
                        <div class="dentist-image">
                            <?php if( !empty( get_the_post_thumbnail_url() )) { ?>
                                <a href="<?php echo esc_url( $post_link ); ?>">
                                    <img src="<?php the_post_thumbnail_url(  ) ?>" alt="<?php echo esc_attr__('image','rola-toolkit'); ?>">
                                </a>
                            <?php } ?>

                            <?php if ( $settings['show_social_list'] == 'yes' ) :
                                if( have_rows('choose_social_icons') ) : ?>
                                    <ul class="share-link">
                                    <?php while( have_rows('choose_social_icons') ): the_row(); ?>
                                        <li>
                                            <a href="<?php echo esc_url( get_sub_field('link') ); ?>" target="_blank"><i class='<?php echo esc_attr( get_sub_field('choose_doctor_icon') ); ?>'></i>
                                            </a>
                                        </li>
                                    <?php endwhile; ?>
                                    </ul>
                                <?php endif;
                            endif; ?>
                        </div>
                        <div class="dentist-content">
                            <h3><a href="<?php echo esc_url( $post_link ); ?>"><?php the_title(); ?></a></h3>
                            <span><?php echo esc_html( $designation ); ?></span>
                        </div>
                    </div>
                    <?php endwhile;
                    wp_reset_postdata(); ?>
                </div>
            </div>
        <?php endif; ?>

        <?php
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Rola_Doctor );