<?php
namespace Elementor;
class Rola_Banner_Five extends Widget_Base{
    public function get_name(){
        return "rolabannerfive";
    }
    public function get_title(){
        return "Banner Five";
    }
    public function get_icon(){
        return "eicon-banner";
    }
    public function get_categories(){
        return ['rolacategory'];
    }

    protected function register_controls(){
        // Section controls
        $this-> start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Content', 'rola-toolkit'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            $this->add_control(
                'header_size',
                [
                    'label' => __('Title Heading Tag', 'rola-toolkit'),
                    'type' => Controls_Manager::SELECT,
                        'options' => [
                            'h1' => 'H1',
                            'h2' => 'H2',
                            'h3' => 'H3',
                            'h4' => 'H4',
                            'h5' => 'H5',
                            'h6' => 'H6',
                        ],
                    'default'     => 'h1',
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'bg_image',
                [
                    'label' => __( 'Image', 'rola-toolkit' ),
                    'type'  => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'icon',
                [
                    'label'      => __( ' Icon', 'rola-toolkit' ),
                    'type' 	     => Controls_Manager::SELECT,
                    'options'    => rola_icons(),
                ]
            );
            $this->add_control(
                'sub_title',
                [
                    'label' => __( 'Sub Title', 'rola-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('Professional', 'rola-toolkit'),
                ]
            );
            $this->add_control(
                'banner_title',
                [
                    'label'       => __('Title', 'rola-toolkit'),
                    'type'        => Controls_Manager:: TEXTAREA,
                    'label_block' => true,
                ]
            );
           
            $this->add_control(
                'desc',
                [
                    'label'  => __('Description', 'rola-toolkit'),
                    'type'   => Controls_Manager:: TEXTAREA,
                ]
            );
            $this->add_control(
                'button_one_text',
                [
                    'label' => __('Button Text', 'rola-toolkit'),
                    'type'  => Controls_Manager:: TEXT,
                ]
            );
            $this->add_control(
                'link_type',
                [
                    'label' => __( 'Link Type', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        '1'   => __( 'Link To Page', 'rola-toolkit' ),
                        '2'   => __( 'External Link', 'rola-toolkit' ),
                    ],
                ]
            );
            $this->add_control(
                'link_to_page',
                [
                    'label' => __( 'Link Page', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options'     => rola_toolkit_get_page_as_list(),
                    'condition'   => [
                        'link_type' => '1',
                    ]
                ]
            );
            $this->add_control(
                'external_link',
                [
                    'label' => __('External Link', 'rola-toolkit'),
                    'type'  => Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type' => '2',
                    ]
                ]
            );
        $this-> end_controls_section();

        // End controls

        // Start style1 content controls
        $this-> start_controls_section(
            'content_style',
            [
                'label' => esc_html__('Content', 'rola-toolkit'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'top_title_color',
                [
                    'label' => esc_html__( 'Top Title Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dental-tourism-banner-content .sub-title' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'top_title_icolor',
                [
                    'label'     => __( 'Top Title Icon Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dental-tourism-banner-content .sub-title i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name' => 'typography_top_title',
                    'label' => __( 'Top Title Typography', 'rola-toolkit' ),
                    'selector' => ' {{WRAPPER}} .dental-tourism-banner-content .sub-title',
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dental-tourism-banner-content h1, .dental-tourism-banner-content h2, .dental-tourism-banner-content h3, .dental-tourism-banner-content h4, .dental-tourism-banner-content h5, .dental-tourism-banner-content h6' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name' => 'typography_title',
                    'label' => __( 'Title Typography', 'rola-toolkit' ),
                    'selector' => ' {{WRAPPER}} .dental-tourism-banner-content h1, .dental-tourism-banner-content h2, .dental-tourism-banner-content h3, .dental-tourism-banner-content h4, .dental-tourism-banner-content h5, .dental-tourism-banner-content h6',
                ]
            );
            $this->add_control(
                'desc_color',
                [
                    'label' => esc_html__( 'Description Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dental-tourism-banner-content p, .dental-tourism-banner-content ul li, .dental-tourism-banner-content ol li' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name' => 'typography_desc',
                    'label' => __( 'Description Typography', 'rola-toolkit' ),
                    'selector' => ' {{WRAPPER}} .dental-tourism-banner-content p, .dental-tourism-banner-content ul li, .dental-tourism-banner-content ol li',
                ]
            );
            $this->add_control(
                'btn_color',
                [
                    'label'     => esc_html__( 'Button Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .default-btn' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'btn_bg_color',
                [
                    'label'     => esc_html__( 'Button Background Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .default-btn' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'btn_hcolor',
                [
                    'label'     => esc_html__( 'Button Hover Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .default-btn:hover' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'btn_bg_hcolor',
                [
                    'label'     => esc_html__( 'Button Background Hover Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dental-tourism-banner-content .banner-btn .default-btn:hover, .default-btn:before' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name' => 'typography_btn',
                    'label' => __( 'Button Typography', 'rola-toolkit' ),
                    'selector' => ' {{WRAPPER}} .default-btn',
                ]
            );
        $this-> end_controls_section();
    }

    protected function render()
    {
        // Retrieve all controls value
        $settings = $this->get_settings_for_display();

        // Button link
        $btn1_text  = $settings['button_one_text'];

        $link_one = '';
        if( $settings['link_type'] == 1 ){
            $link_one = get_page_link($settings['link_to_page']); 
        } else {
            $link_one = $settings['external_link'];
        }
        ?>

        <div class="dental-tourism-banner-area" style="background-image: url(<?php echo esc_url( $settings['bg_image']['url']); ?> )">
            <div class="container-fluid">
                <div class="dental-tourism-banner-content">
                    <?php if( $settings['sub_title'] != '' ) : ?>
                        <span class="sub-title wow fadeInDown" data-wow-delay="0.5s">
                            <?php if( $settings['icon'] != '' ) : ?>
                                <i class="<?php echo esc_attr( $settings['icon'] ); ?>"></i>
                            <?php endif; ?>
                            <?php echo esc_html( $settings['sub_title'] ); ?>
                        </span>
                    <?php endif; ?>

                    <<?php echo esc_attr( $settings['header_size'] ); ?>  class="wow fadeInLeft" data-wow-delay="0.5s">
                        <?php echo wp_kses_post( $settings['banner_title'] ); ?>
                    </<?php echo esc_attr( $settings['header_size'] ); ?>>

                    <p class="wow fadeInLeft" data-wow-delay="0.5s"><?php echo wp_kses_post( $settings['desc'] ); ?></p>

                    <?php if( $btn1_text != '' ): ?>
                        <div class="banner-btn wow fadeInDown" data-wow-delay="0.5s">
                            <a href="<?php echo esc_url($link_one); ?>" class="default-btn"> <?php echo esc_html( $btn1_text ); ?></a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <?php
    }
}
Plugin::instance()->widgets_manager->register_widget_type( new Rola_Banner_Five );