<?php
    /**
     * ReduxFramework Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    // This is your option name where all the Redux data is stored.
    $opt_name = ROLA_FRAMEWORK_VAR;
    

    // This line is only for altering the demo. Can be easily removed.
    $opt_name = apply_filters( 'opt_name/opt_name', $opt_name );

    /*
     *
     * --> Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
     *
     */

    $sampleHTML = '';
    if ( file_exists( dirname( __FILE__ ) . '/info-html.html' ) ) {
        Redux_Functions::initWpFilesystem();

        global $wp_filesystem;

        $sampleHTML = $wp_filesystem->get_contents( dirname( __FILE__ ) . '/info-html.html' );
    }

    // Background Patterns Reader
    $sample_patterns_path = ReduxFramework::$_dir . '../sample/patterns/';
    $sample_patterns_url  = ReduxFramework::$_url . '../sample/patterns/';
    $sample_patterns      = array();
    
    if ( is_dir( $sample_patterns_path ) ) {

        if ( $sample_patterns_dir = opendir( $sample_patterns_path ) ) {
            $sample_patterns = array();

            while ( ( $sample_patterns_file = readdir( $sample_patterns_dir ) ) !== false ) {

                if ( stristr( $sample_patterns_file, '.png' ) !== false || stristr( $sample_patterns_file, '.jpg' ) !== false ) {
                    $name              = explode( '.', $sample_patterns_file );
                    $name              = str_replace( '.' . end( $name ), '', $sample_patterns_file );
                    $sample_patterns[] = array(
                        'alt' => $name,
                        'img' => $sample_patterns_url . $sample_patterns_file
                    );
                }
            }
        }
    }

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => __( 'Theme Options', 'rola-toolkit' ),
        'page_title'           => __( 'Theme Options', 'rola-toolkit' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => false,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-portfolio',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => false,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => null,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => 'rola_option',
        // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'red',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );


    // Panel Intro text -> before the form
    if ( ! isset( $args['global_variable'] ) || $args['global_variable'] !== false ) {
        if ( ! empty( $args['global_variable'] ) ) {
            $v = $args['global_variable'];
        } else {
            $v = str_replace( '-', '_', $args['opt_name'] );
        }
        $args['intro_text'] = sprintf( __( '<p></p>', 'rola-toolkit' ), $v );
    } else {
        $args['intro_text'] = __( '<p>This text is displayed above the options panel. It isn\'t required, but more info is always better! The intro_text field accepts all HTML.</p>', 'rola-toolkit' );
    }

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */


    /*
     * ---> START HELP TABS
     */

    $tabs = array(
        array(
            'id'      => 'redux-help-tab-1',
            'title'   => __( 'Theme Information 1', 'rola-toolkit' ),
            'content' => __( '<p>This is the tab content, HTML is allowed.</p>', 'rola-toolkit' )
        ),
        array(
            'id'      => 'redux-help-tab-2',
            'title'   => __( 'Theme Information 2', 'rola-toolkit' ),
            'content' => __( '<p>This is the tab content, HTML is allowed.</p>', 'rola-toolkit' )
        )
    );
    Redux::setHelpTab( $opt_name, $tabs );

    // Set the help sidebar
    $content = __( '<p>This is the sidebar content, HTML is allowed.</p>', 'rola-toolkit' );
    Redux::setHelpSidebar( $opt_name, $content );


    /*
     * <--- END HELP TABS
     */


    /*
     *
     * ---> START SECTIONS
     *
     */

    /*

        As of Redux 3.5+, there is an extensive API. This API can be used in a mix/match mode allowing for


     */

// -> START General Options
Redux::setSection( $opt_name, array(
    'title'            => __( 'General Options', 'rola-toolkit' ),
    'id'               => 'general_options',
    'customizer' => false,
    'icon'             => ' el el-home',
    'fields'     => array(
        array(
            'id'      => 'enable_preloader',
            'type'    => 'switch',
            'title'   => __( 'Pre-loader', 'rola-toolkit' ),
            'on'      => __( 'Enable', 'rola-toolkit' ),
            'off'     => __( 'Disable', 'rola-toolkit' ),
            'default' => false,
        ),
        array(
            'id'       => 'main_logo',
            'type'     => 'media',
            'url'      => true,
            'title'    => __( 'Site Main Logo', 'rola-toolkit' ),
        ),
        array(
            'title'     => __( 'Main Logo dimensions', 'rola-toolkit' ),
            'subtitle'  => __( 'Set a custom height width for your upload logo. Recommended size 150X50', 'rola-toolkit' ),
            'id'        => 'logo_dimensions',
            'type'      => 'dimensions',
            'units'     => array( 'em','px','%' ),
            'output'    => '.main-navbar .navbar h1 .navbar-brand img, .dental-tourism-navbar .main-navbar .navbar .navbar-brand img, .grin-care-navbar .main-navbar .navbar .navbar-brand img'
        ),
        array(
            'id'       => 'mobile_logo',
            'type'     => 'media',
            'url'      => true,
            'title'    => __( 'Logo For Mobile (optional)', 'rola-toolkit' ),
        ),
        array(
            'title'     => __( 'Mobile Logo dimensions', 'rola-toolkit' ),
            'subtitle'  => __( 'Set a custom height width for your upload logo. Recommended size 150X50', 'rola-toolkit' ),
            'id'        => 'mobile_logo_dimensions',
            'type'      => 'dimensions',
            'units'     => array( 'em','px','%' ),
            'output'    => '.main-responsive-nav .main-responsive-menu h1 a img'
        ),
        array(
            'id'        => 'disable_sticky_header',
            'type'      => 'switch',
            'title'     => __('Disable Sticky Header', 'rola-toolkit'),
            'desc'      => __('', 'rola-toolkit'),
            'default'   => '0'
        ),
        array(
            'id'        => 'enable_back_to_top',
            'type'      => 'switch',
            'title'     => __('Enable back-to-top Button', 'rola-toolkit'),
            'default'   => '1'
        ),
        array(
            'id'      => 'rola_enable_rtl',
            'type'    => 'select',
            'options' => array(
                'enable'        => 'Enable',
                'disable'       => 'Disable',
            ),
            'title'     => esc_html__( 'RTL', 'rola-toolkit' ),
            'default'   => 'disable',
        ),
    )
) );

// Page Banner Shapes
Redux::setSection( $opt_name, array(
    'title'             => __( 'Page Banner', 'rola-toolkit' ),
    'id'                => 'shape_images_options',
    'customizer'        => false,
    'icon'              => 'el el-website',
    'fields'     => array(
        array(
            'id'        => 'pagebanner_title_typo',
            'type'      => 'typography',
            'title'     => __( 'Title Typography', 'rola-toolkit' ),
            'output'    => '.page-banner-area h2'
        ),

        array(
            'id'        => 'pagebanner_breadcrumb_typo',
            'type'      => 'typography',
            'title'     => __( 'Breadcrumb Typography', 'rola-toolkit' ),
            'output'    => '.page-banner-content .pages-list li, .page-banner-content .pages-list li a, .page-banner-content .pages-list li::before',
        ),

        array(
            'id'       => 'page_shape1',
            'type'     => 'media',
            'url'      => true,
            'title'    => __( 'Shape 1', 'rola-toolkit' ),
        ),
        array(
            'id'       => 'page_shape2',
            'type'     => 'media',
            'url'      => true,
            'title'    => __( 'Shape 2', 'rola-toolkit' ),
        ),
    )
) );

// -> START Top Header
Redux::setSection( $opt_name, array(
    'title'            => __( 'Top Header', 'rola-toolkit' ),
    'id'               => 'top_header',
    'customizer'       => false,
    'icon'             => 'el el-website',
    'fields'     => array(
        array(
            'id'      => 'hide_top_header',
            'type'    => 'switch',
            'title'   => __( 'Top Header', 'rola-toolkit' ),
            'on'      => __( 'Show', 'rola-toolkit' ),
            'off'     => __( 'Hide', 'rola-toolkit' ),
            'default' => true,
        ),
        // Phone
        array(
            'id'       => 'top_header_num_icon',
            'type'     => 'text',
            'title'    => __('Top Header Phone Icon', 'rola-toolkit'),
            'required' => array('hide_top_header','equals',true),
            'default'  => 'bx bxs-phone'
        ),
        array(
            'id'       => 'top_header_num',
            'type'     => 'text',
            'title'    => __('Top Header Number', 'rola-toolkit'),
            'required' => array('hide_top_header','equals',true),
        ),
        array(
            'id'       => 'top_header_num_link',
            'type'     => 'text',
            'title'    => __('Top Header Number Link', 'rola-toolkit'),
            'required' => array('hide_top_header','equals',true),
        ),

        // Text
        array(
            'id'       => 'top_header_text',
            'type'     => 'text',
            'title'    => __('Top Header Text', 'rola-toolkit'),
            'required' => array('hide_top_header','equals',true),
        ),
        array(
            'id'       => 'top_header_text_icon',
            'type'     => 'text',
            'title'    => __('Top Header Address Icon', 'rola-toolkit'),
            'required' => array('hide_top_header','equals',true),
            'default'  => 'bx bxs-map'
        ),

        // Email
        array(
            'id'       => 'top_header_mail_icon',
            'type'     => 'text',
            'title'    => __('Top Header Mail Icon', 'rola-toolkit'),
            'required' => array('hide_top_header','equals',true),
            'default'  => 'bx bx-envelope-open'
        ),
        array(
            'id'       => 'top_header_mail',
            'type'     => 'text',
            'title'    => __('Top Header Email', 'rola-toolkit'),
            'required' => array('hide_top_header','equals',true),
        ),
        array(
            'id'       => 'top_header_mail_link',
            'type'     => 'text',
            'title'    => __('Top Header Email Link', 'rola-toolkit'),
            'required' => array('hide_top_header','equals',true),
        ),

        // Social
        array(
            'id'       => 'top_social_link',
            'type'     => 'checkbox',
            'title'    => __( 'Hide Social Link?', 'rola-toolkit' ),
            'required' => array('hide_top_header','equals',true),
        ),
        array(
            'id' => 'top_header_bg_color',
            'type' => 'color',
            'title' => __('Top Header Background Color', 'rola-toolkit'),
            'validate' => 'color',
            'output'      => array(
                'background-color' => '.top-header-area',
            ),
            'transparent' => true,
            'required' => array('hide_top_header','equals',true),
        ),
        array(
            'id' => 'top_header_text_color',
            'type' => 'color',
            'title' => __('Top Header Text Color', 'rola-toolkit'),
            'validate' => 'color',
            'output'      => array(
                'color' => '.top-header-information li, .top-header-information li a',
            ),
            'transparent' => false,
            'required' => array('hide_top_header','equals',true),
        ),
        array(
            'id' => 'top_header_text_hcolor',
            'type' => 'color',
            'title' => __('Top Header Text Hover Color', 'rola-toolkit'),
            'validate' => 'color',
            'output'      => array(
                'color' => '.top-header-information li a:hover',
            ),
            'transparent' => false,
            'required' => array('hide_top_header','equals',true),
        ),

        array(
            'id'          => 'th_icon_color',
            'type'        => 'color',
            'title'       => __('Icon Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color' => '.top-header-information li i, .top-header-optional li a i',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'th_icon_bgcolor',
            'type'        => 'color',
            'title'       => __('Icon Background Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'background-color' => ' .top-header-optional li a i',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'th_icon_hbgcolor',
            'type'        => 'color',
            'title'       => __('Icon Hover Background Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'background-color' => ' .top-header-optional li a i:hover',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'th_icon_hcolor',
            'type'        => 'color',
            'title'       => __('Icon Hover Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color' => ' .top-header-optional li a i:hover',
            ),
            'transparent' => false
        ),
    )
) );

Redux::setSection( $opt_name, array(
	'title'     => esc_html__( 'Top Header(Page 5)', 'vaximo-toolkit' ),
	'id'        => 'tp5_settings',
	'icon'      => '',
    'subsection' => true,
	'fields'    => array(

        array(
            'id' => 'top5_bg',
            'type' => 'color',
            'title' => __('Background Color', 'rola-toolkit'),
            'validate' => 'color',
            'output'      => array(
                'background-color' => '.dental-tourism-top-area',
            ),
            'transparent' => false
        ),
        array(
            'id' => 'toptext_color',
            'type' => 'color',
            'title' => __('Text Color', 'rola-toolkit'),
            'validate' => 'color',
            'output'      => array(
                'color' => '.top-dental-tourism-information li a, .top-dental-tourism-information li',
            ),
            'transparent' => false
        ),
        array(
            'id' => 'toptexth_color',
            'type' => 'color',
            'title' => __('Link Text Hover Color', 'rola-toolkit'),
            'validate' => 'color',
            'output'      => array(
                'color' => '.top-dental-tourism-information li a:hover',
            ),
            'transparent' => false
        ),
        array(
            'id' => 'th5_icon_color',
            'type' => 'color',
            'title' => __('Icon Color', 'rola-toolkit'),
            'validate' => 'color',
            'output'      => array(
                'color' => '.top-dental-tourism-information li i',
            ),
            'transparent' => false
        ),
        array(
            'id' => 'th5_si_color',
            'type' => 'color',
            'title' => __('Social Icon Color', 'rola-toolkit'),
            'validate' => 'color',
            'output'      => array(
                'color' => '.top-dental-tourism-optional li a i',
                'border-color' => '.top-dental-tourism-optional li a i',
            ),
            'transparent' => false
        ),
        array(
            'id' => 'th5_si_hcolor',
            'type' => 'color',
            'title' => __('Social Icon Hover Color', 'rola-toolkit'),
            'validate' => 'color',
            'output'   => array(
                'color'        => '.top-dental-tourism-optional li a i:hover',
                'border-color' => '.top-dental-tourism-optional li a i:hover',
            ),
            'transparent' => false
        ),
        
	)
));
Redux::setSection( $opt_name, array(
	'title'     => esc_html__( 'Top Header(Page 5)', 'vaximo-toolkit' ),
	'id'        => 'tp67_settings',
	'icon'      => '',
    'subsection' => true,
	'fields'    => array(

        array(
            'id' => 'top6_bg',
            'type' => 'color',
            'title' => __('Background Color', 'rola-toolkit'),
            'validate' => 'color',
            'output'      => array(
                'background-color' => '.top-area',
            ),
            'transparent' => false
        ),
        array(
            'id' => 'toptext56_color',
            'type' => 'color',
            'title' => __('Text Color', 'rola-toolkit'),
            'validate' => 'color',
            'output'      => array(
                'color' => '.top-information-wrap li a, .top-information-wrap li',
            ),
            'transparent' => false
        ),
        array(
            'id' => 'toptexth6_color',
            'type' => 'color',
            'title' => __('Link Text Hover Color', 'rola-toolkit'),
            'validate' => 'color',
            'output'      => array(
                'color' => '.top-information-wrap li a:hover',
            ),
            'transparent' => false
        ),
        array(
            'id' => 'th6_icon_color',
            'type' => 'color',
            'title' => __('Icon Color', 'rola-toolkit'),
            'validate' => 'color',
            'output'      => array(
                'color' => '.top-information-wrap li i',
            ),
            'transparent' => false
        ),
        array(
            'id' => 'th6_si_color',
            'type' => 'color',
            'title' => __('Social Icon Color', 'rola-toolkit'),
            'validate' => 'color',
            'output'      => array(
                'color' => '.top-optional-wrap li a i',
                'border-color' => '.top-optional-wrap li a i',
            ),
            'transparent' => false
        ),
        array(
            'id' => 'th6_si_hcolor',
            'type' => 'color',
            'title' => __('Social Icon Hover Color', 'rola-toolkit'),
            'validate' => 'color',
            'output'   => array(
                'color'        => '.top-optional-wrap li a i:hover',
                'border-color' => '.top-optional-wrap li a i:hover',
            ),
            'transparent' => false
        ),
        
	)
));

// -> START Header
Redux::setSection( $opt_name, array(
    'title'            => __( 'Header', 'rola-toolkit' ),
    'id'               => 'header',
    'customizer'       => false,
    'icon'             => 'el el-website',
    'fields'     => array(
        array(
            'id'        => 'enable_search',
            'type'      => 'switch',
            'title'     => __('Enable Search', 'rola-toolkit'),
            'default'   => '1'
        ),
        array(
			'id'        => 'search_placeholder_text',
            'type'      => 'text',
            'title'     => esc_html__('Search Placeholder Text', 'rola-toolkit'),
            'required'  => array('enable_search','equals','1'),
        ),

        // User button
        array(
            'id'        => 'enable_app_button',
            'type'      => 'switch',
            'title'     => __('Enable Appointment', 'rola-toolkit'),
            'default'   => '1',
        ),
        array(
            'id'       => 'app_btn_text',
            'type'     => 'text',
            'title'    => __('Appointment Button Text', 'rola-toolkit'),
            'required'  => array('enable_app_button','equals','1'),
        ),
        array(
            'id'    => 'header_btn_link_type',
            'type'  => 'select',
            'options' => array (
                'external_link'     => 'External Link',
                'internal_link'     => 'Internal Link',
            ),
            'title'     => esc_html__( 'Button Link Type', 'rola-toolkit' ),
            'default'   => 'internal_link',
            'required'  => array('enable_app_button','equals','1'),
        ),
        array(
			'id'        => 'header_btn_link_external',
            'type'      => 'text',
			'title'     => esc_html__('Link', 'rola-toolkit'),
            'required'  => array('header_btn_link_type','equals','external_link'),
        ),
        array(
			'id'        => 'header_btn_internal',
            'type'      => 'text',
			'title'     => esc_html__('Link', 'rola-toolkit'),
            'required'  => array('header_btn_link_type','equals','internal_link'),
            'desc'      => 'This link work from your site root directory',
        ),

        array(
            'id'          => 'hbtn_bg_color',
            'type'        => 'color',
            'title'       => __('Button Background Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'background-color' => '.navbar-area .default-btn',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'hbtn_color',
            'type'        => 'color',
            'title'       => __('Button Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color' => '.navbar-area .default-btn',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'h_btn_hbgcolor',
            'type'        => 'color',
            'title'       => __('Button Hover Background Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'background-color' => ' .default-btn:before',
            ),
            'transparent' => false
        ),

        // Navbar Style Two
        array(
            'id'       => 'nav_s2_bg',
            'type'     => 'media',
            'url'      => true,
            'title'    => __( 'Navbar Style Two Background Image', 'rola-toolkit' ),
        ),
    )
) );

// Social Profiles
Redux::setSection( $opt_name, array(
	'title' => __('Social Profiles', 'rola-toolkit'),
	'desc'  => 'Social profiles are used in different places inside the theme.',
	'icon'  => 'el-icon-user',
	'customizer' => false,
	'fields' => array(
        array(
            'id' => 'rola_social_target',
            'type' => 'select',
            'options' => array(
                '_blank'    => 'Load in a new window. ( _blank )',
                '_self'     => 'Load in the same frame as it was clicked. ( _self )',
                '_parent'   => 'Load in the parent frameset. ( _parent )',
                '_top'      => 'Load in the full body of the window ( _top )',
            ),
            'title'     => __( 'Social Link Target', 'rola-toolkit' ),
            'default'   => '_blank',
        ),
        
        array(
			'id'    => 'twitter_url',
            'type'  => 'text',
            'title' => __('Twitter URL', 'rola-toolkit'),
            'default'   => '#',
		),
		array(
			'id'    => 'facebook_url',
			'type'  => 'text',
            'title' => __('Facebook URL', 'rola-toolkit'),
            'default'   => '#',
		),
		array(
			'id'    => 'instagram_url',
			'type'  => 'text',
            'title' => __('Instagram URL', 'rola-toolkit'),
            'default'   => '#',
		),
		array(
			'id'    => 'linkedin_url',
			'type'  => 'text',
            'title' => __('Linkedin URL', 'rola-toolkit'),
            'default'   => '#',
		),
		array(
			'id'    => 'pinterest_url',
			'type'  => 'text',
			'title' => __('Pinterest URL', 'rola-toolkit')
		),
		array(
			'id'    => 'dribbble_url',
			'type'  => 'text',
			'title' => __('Dribbble URL', 'rola-toolkit')
		),
		array(
			'id'    => 'tumblr_url',
			'type'  => 'text',
			'title' => __('Tumblr URL', 'rola-toolkit')
		),
		array(
			'id'    => 'youtube_url',
			'type'  => 'text',
			'title' => __('Youtube URL', 'rola-toolkit')
		),
		array(
			'id'    => 'flickr_url',
			'type'  => 'text',
			'title' => __('Flickr URL', 'rola-toolkit')
		),
		array(
			'id'    => 'behance_url',
			'type'  => 'text',
			'title' => __('Behance URL', 'rola-toolkit'),
		),
		array(
			'id'    => 'github_url',
			'type'  => 'text',
			'title' => __('Github URL', 'rola-toolkit'),
		),
		array(
			'id'    => 'skype_url',
			'type'  => 'text',
			'title' => __('Skype URL', 'rola-toolkit'),
		),
		array(
			'id'    => 'rss_url',
			'type'  => 'text',
			'title' => __('RSS URL', 'rola-toolkit')
		),
	)
) );

// START Styling 
Redux::setSection( $opt_name, array(
    'title'            =>  __( 'Styling Options', 'rola-toolkit' ),
    'id'               => 'styling_options',
    'customizer'       => false,
    'icon'             => ' el el-magic',
    'fields'     => array(
        array(
            'id'          => 'primary_color',
            'type'        => 'color',
            'title'       => __('Primary Color', 'rola-toolkit'),
            'default'     => '#1DBFCC',
            'validate'    => 'color',
            'output'      => array(
                '--mainColor' => ':root',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'optional_color',
            'type'        => 'color',
            'title'       => __('Optional Color', 'rola-toolkit'),
            'default'     => '#06a3da',
            'validate'    => 'color',
            'output'      => array(
                '--optionalColor' => ':root',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'header_bg_color',
            'type'        => 'color',
            'title'       => __('Header Background Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'background-color' => '.main-navbar, .dental-tourism-navbar .main-navbar, .grin-care-navbar .main-navbar .navbar',
            ),
            'transparent' => true
        ),
        array(
            'id'          => 'nav_active_color',
            'type'        => 'color',
            'title'       => __('Menu Active/Hover Color', 'rola-toolkit'),
            'default'     => '#1DBFCC',
            'validate'    => 'color',
            'output'      => array(
                'color' => '.main-navbar .navbar .navbar-nav .nav-item:hover a, .main-navbar .navbar .navbar-nav .nav-item.active a, .main-navbar .navbar .navbar-nav .nav-item .dropdown-menu li.active a, .main-navbar .navbar .navbar-nav .nav-item .dropdown-menu li a:hover, .main-navbar .navbar .navbar-nav .nav-item .dropdown-menu li a:focus, .main-navbar .navbar .navbar-nav .nav-item .dropdown-menu li a.active, .grin-care-navbar .main-navbar .navbar .navbar-nav .nav-item.active a, .dental-tourism-navbar .main-navbar .navbar .navbar-nav .nav-item.active a, .grin-care-navbar .main-navbar .navbar .navbar-nav .nav-item:hover a, .dental-tourism-navbar .main-navbar .navbar .navbar-nav .nav-item:hover a',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'nav_item_color',
            'type'        => 'color',
            'title'       => __('Menu Item Color', 'rola-toolkit'),
            'default'     => '#002345',
            'validate'    => 'color',
            'output'      => array(
                'color' => '.main-navbar .navbar .navbar-nav .nav-item a, .dental-tourism-navbar .main-navbar .navbar .navbar-nav .nav-item a, .grin-care-navbar .main-navbar .navbar .navbar-nav .nav-item a',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'search_icon_color',
            'type'        => 'color',
            'title'       => __('Search Icon Color', 'rola-toolkit'),
            'default'     => '#002345',
            'validate'    => 'color',
            'output'      => array(
                'color' => '.main-navbar .navbar .others-options .option-item .search-box i',
            ),
            'transparent' => false
        ),
    )
) );

// Start Blog Area
Redux::setSection( $opt_name, array(
    'title'            => __( 'Blog', 'rola-toolkit' ),
    'id'               => 'rola_blog',
    'customizer' => false,
    'icon'             => 'el el-file-edit',
    'fields' => array(
        array(
			'id'    => 'rola_search_page',
            'type'  => 'switch',
            'title' => __('Enable Pages on Search Result Page', 'rola-toolkit'),
        ),
        array(
			'id'        => 'hide_blog_banner',
            'type'      => 'switch',
            'title'     => __('Hide Blog Search/Archive Banner', 'rola-toolkit'),
            'default'   => '0'
        ),
        array(
			'id'        => 'hide_breadcrumb',
            'type'      => 'switch',
			'title'     => __('Hide Blog Search/Archive Breadcrumb', 'rola-toolkit'),
            'default'   => '0',
            'required'  => array('hide_blog_banner','equals','0'),
        ),

        array(
            'id'   => 'rola_blog_sidebar',
            'type' => 'select',
            'options' => array(
                'rola_with_sidebar_left'         => 'With Sidebar(Left)',
                'rola_with_sidebar_right'        => 'With Sidebar(Right)',
                'rola_without_sidebar'           => 'Without Sidebar ( full width )',
                'rola_without_sidebar_center'    => 'Without Sidebar( center )',
            ),
            'title'     => __( 'Blog Sidebar', 'rola-toolkit' ),
            'default'   => 'rola_with_sidebar_right',
        ),
        array(
			'title'     => __( 'Post meta', 'rola-toolkit' ),
			'subtitle'  => __( 'Hide/Show post meta', 'rola-toolkit' ),
			'id'        => 'is_post_meta',
			'type'      => 'switch',
            'on'        => __( 'Hide', 'rola-toolkit' ),
            'off'       => __( 'Show', 'rola-toolkit' ),
            'default'   => '0',
        ),
        array(
			'title'     => __( 'Post Date', 'rola-toolkit' ),
			'subtitle'  => __( 'Hide/Show post date', 'rola-toolkit' ),
			'id'        => 'is_post_date',
			'type'      => 'switch',
            'on'        => __( 'Hide', 'rola-toolkit' ),
            'off'       => __( 'Show', 'rola-toolkit' ),
            'default'   => '1',
        ),
        array(
			'id'        => 'hide_read_more',
            'type'      => 'switch',
            'title'     => __('Hide Read More', 'rola-toolkit'),
            'on'        => __( 'Hide', 'rola-toolkit' ),
            'off'       => __( 'Show', 'rola-toolkit' ),
            'default'   => '0'
        ),
        array(
            'id'       => 'post_read_more',
            'type'     => 'text',
            'title'    => __( 'Posts Read More Button Text', 'rola-toolkit' ),
            'required' => array('hide_read_more','equals','0'),
        ),
        array(
			'id'        => 'hide_excerpt',
            'type'      => 'switch',
            'title'     => __('Hide Excerpt', 'rola-toolkit'),
            'on'        => __( 'Hide', 'rola-toolkit' ),
            'off'       => __( 'Show', 'rola-toolkit' ),
            'default'   => '0'
        ),


        // Section
        array(
            'id'       => 'post_toptitle',
            'type'     => 'text',
            'title'    => __( 'Posts Top Title Text', 'rola-toolkit' ),
        ),
        array(
            'id'       => 'post_sec_title',
            'type'     => 'textarea',
            'title'    => __( 'Post Section Title Text', 'rola-toolkit' ),
        ),

        // Form
        array(
            'id'       => 'form_comment_ph',
            'type'     => 'text',
            'title'    => __( 'Comment Placeholder Text', 'rola-toolkit' ),
            'default'   => __( 'Type Your Comments', 'rola-toolkit' ),
        ),
        array(
            'id'       => 'form_name_place',
            'type'     => 'text',
            'title'    => __( 'Name Placeholder Text', 'rola-toolkit' ),
            'default'   => __( 'Name', 'rola-toolkit' ),
        ),
        array(
            'id'       => 'form_email_place',
            'type'     => 'text',
            'title'    => __( 'Email Placeholder Text', 'rola-toolkit' ),
            'default'   => __( 'Email', 'rola-toolkit' ),
        ),
        array(
            'id'       => 'form_web_place',
            'type'     => 'text',
            'title'    => __( 'Website Placeholder Text', 'rola-toolkit' ),
            'default'   => __( 'Website', 'rola-toolkit' ),
        ),
    ) 
));

// WooCommerce Product
Redux::setSection( $opt_name, array(
    'title'         => __( 'WooCommerce Product', 'rola-toolkit' ),
    'desc'          => __( 'Manage product page settings.', 'rola-toolkit' ),
    'icon'          => 'el-icon-list-alt',
    'customizer'    => false,
    'fields' => array(
        array(
            'id'        => 'products_page_count',
            'desc'      => __( 'Number of products per page on product pages.', 'rola-toolkit' ),
            'type'      => 'text',
            'title'     => __( 'Products per page', 'rola-toolkit' ),
            'default'   => '6',
        ),
        array(
            'id'    => 'product_sidebar',
            'type'  => 'select',
            'options' => array(
                'rola_product_no_sidebar'       => 'None',
                'left-sidebar'  => 'Sidebar on the left',
                'right-sidebar' => 'Sidebar on the right',
            ),
            'title'     => __( 'Product Sidebar Position', 'rola-toolkit' ),
            'default'   => 'rola_product_no_sidebar',
        ),
        array(
            'desc'  => esc_html__( 'Enable or disable product quick view.', 'rola-toolkit' ),
            'id'    => 'rola_product_quick_view',
            'type'  => 'select',
            'options' => array(
                'enabled'   => 'Enabled',
                'disabled'  => 'Disabled',
            ),
            'title' => esc_html__( 'Product Quick View', 'rola-toolkit' ),
            'default' => 'enabled',
        ),

        /*
        array(
            'id'    => 'rola_related_product_count',
            'type'  => 'text',
            'title' => __( 'Product Details Related Product Count', 'rola-toolkit' ),
            'desc'  => __( 'e.g. 3', 'rola-toolkit' ),
            'default' => '3',
        ),
        */

        array(
            'id'        => 'enable_product_share',
            'type'      => 'switch',
            'title'     => esc_html__('Enable Product Social share', 'rola-toolkit'),
            'default'   => '0'
        ),
        
        array(
            'id'        => 'enable_social_share_title',
            'type'      => 'text',
            'title'     => esc_html__('Share Title', 'rola-toolkit'),
            'default'   => 'Share:',
            'required'  => array('enable_product_share','equals','1'),
        ),
        array(
            'id'        => 'enable_product_fb',
            'type'      => 'switch',
            'title'     => esc_html__('Share on Facebook', 'rola-toolkit'),
            'default'   => '0',
            'required'  => array('enable_product_share','equals','1'),
        ),

        array(
            'id'        => 'enable_product_tw',
            'type'      => 'switch',
            'title'     => esc_html__('Share on Twitter', 'rola-toolkit'),
            'default'   => '0',
            'required'  => array('enable_product_share','equals','1'),
        ),
        array(
            'id'        => 'enable_product_ld',
            'type'      => 'switch',
            'title'     => esc_html__('Share on Linkedin', 'rola-toolkit'),
            'default'   => '0',
            'required'  => array('enable_product_share','equals','1'),
        ),
        array(
            'id'        => 'enable_product_wp',
            'type'      => 'switch',
            'title'     => esc_html__('Share on Whatsapp', 'rola-toolkit'),
            'default'   => '0',
            'required'  => array('enable_product_share','equals','1'),
        ),
        array(
            'id'        => 'enable_product_email',
            'type'      => 'switch',
            'title'     => esc_html__('Share via Email', 'rola-toolkit'),
            'default'   => '0',
            'required'  => array('enable_product_share','equals','1'),
        ),
        array(
            'id'        => 'enable_product_cp',
            'type'      => 'switch',
            'title'     => esc_html__('Copy Link', 'rola-toolkit'),
            'default'   => '0',
            'required'  => array('enable_product_share','equals','1'),
        ),
    ),
));

// Custom Posts
Redux::setSection( $opt_name, array(
	'title'     => esc_html__( 'Custom Posts', 'rola-toolkit' ),
	'id'        => 'services_settings',
    'icon'      => 'el el-file-edit',
    'customizer' => false,
	'fields'    => array(
        array(
            'id'        => 'rola_slug_note',
            'type'      => 'info',
            'style'     => 'warning',
            'title'     => esc_html__( 'Slug Re-write:', 'rola-toolkit' ),
            'icon'      => 'dashicons dashicons-info',
            'desc'      => sprintf (
                '%1$s <a href="%2$s"> %3$s</a> %4$s',
                esc_html__( "These are the custom post's slugs offered by rola. You can customize the permalink structure (site_domain/post_type_slug/post_lug) by changing the slug from here. Don't forget to save the permalinks settings from", 'rola-toolkit' ),
                get_admin_url( null, 'options-permalink.php' ),
                esc_html__( 'Settings > Permalinks', 'rola-toolkit' ),
                esc_html__( 'after changing the slug value.', 'rola-toolkit' )
            )
        ),
        
        array(
            'id'       => 'service_permalink',
            'type'     => 'text',
            'title'    => __( 'Services Slug', 'rola-toolkit' ),
            'default'  => __('service-post', 'rola-toolkit'),
            'desc'     => '<p>After changing the permalink go to <strong style="color:#28a745;">Settings Permalinks</strong> and hit <strong style="color:#28a745;">Save Changes</strong> button.</p>',
        ),
        array(
            'id'       => 'dentist_permalink',
            'type'     => 'text',
            'title'    => __( 'Doctor Slug', 'rola-toolkit' ),
            'default'  => __('doctor-post', 'rola-toolkit'),
            'desc'     => '<p>After changing the permalink go to <strong style="color:#28a745;">Settings Permalinks</strong> and hit <strong style="color:#28a745;">Save Changes</strong> button.</p>',
        ),
        array(
            'id' => 'rola_service_sidebar',
            'type' => 'select',
            'options' => array(
                'rola_with_sidebar'              => 'With Sidebar',
                'rola_without_sidebar'           => 'Without Sidebar ( full width )',
                'rola_without_sidebar_center'    => 'Without Sidebar( center )',
            ),
            'title'     => __( 'Services Sidebar', 'rola-toolkit' ),
            'default'   => 'rola_with_sidebar',
        ),

        array(
            'id'       => 'service_search_placeholder',
            'type'     => 'text',
            'title'    => __( 'Service Search Placeholder', 'rola-toolkit' ),
            'default'  => __('Search...', 'rola-toolkit'),
        ),
        array(
            'id'       => 'service_title',
            'type'     => 'text',
            'title'    => __( 'Service Title', 'rola-toolkit' ),
            'default'  => __('Popular Services', 'rola-toolkit'),
        ),
        array(
            'title'     => esc_html__( 'Services Count', 'rola-toolkit' ),
            'id'        => 'services_post_count',
            'type'      => 'slider',
            'default'       => 6,
            'min'           => 1,
            'step'          => 1,
            'max'           => 50,
            'display_value' => 'label',
        ),

        array(
            'id' => 'rola_service_details_order',
            'type' => 'select',
            'options' => array(
                'rola_bottom'        => 'Content Show at Bottom, Sidebar at Top',
                'rola_top'           => 'Content Show at Top, Sidebar at Bottom',
                'rola_sidebar_hide'  => 'Sidebar Hide',
            ),
            'title'     => __( 'Services Details Content Order(in Mobile Device)', 'rola-toolkit' ),
            'default'   => 'rola_bottom',
        ),
	)
));

// START Footer Area
Redux::setSection( $opt_name, array(
    'title'            => __( 'Footer', 'rola-toolkit' ),
    'id'               => 'footer',
    'customizer'       => false,
    'icon'             => 'el el-edit',
    'fields' => array(
        array(
            'id'       => 'footer_img',
            'type'     => 'media',
            'url'      => true,
            'title'    => __( 'Footer Image', 'rola-toolkit' ),
        ),
        array(
            'id'       => 'copyright_text',
            'type'     => 'editor',
            'title'    => __('Footer copyright text', 'rola-toolkit'),
            'subtitle' => __('HTML and Shortcodes are allowed', 'rola-toolkit'),
            'desc'     => '',
            'args'     => array(
                'teeny' => true,
                'media_buttons' => false
            ),
        ),
        array(
            'id' => 'footer_bg',
            'type' => 'color',
            'title' => __('Footer Background Color', 'rola-toolkit'),
            'desc'     => __('Footer Background color will reflect when there is no background image','rola-toolkit'),
            'default' => '#002345',
            'validate' => 'color',
            'output'      => array(
                'background-color' => '.footer-area',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'footer_title_color',
            'type'        => 'color',
            'title'       => __('Footer Title Color', 'rola-toolkit'),
            'default'     => '#1dbfcc',
            'validate'    => 'color',
            'output'      => array(
                'color' => '.footer-area h1, .footer-area h2, .footer-area h3, .footer-area h4, .footer-area h5, .footer-area h6',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'footer_text_color',
            'type'        => 'color',
            'title'       => __('Footer Text Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color' => '.single-footer-widget ul li a, .footer-area .single-footer-widget p, .single-footer-widget .footer-contact-info li, .single-footer-widget .footer-contact-info li a, .copyright-area p, .single-footer-widget .footer-info h4, .single-footer-widget .footer-info span, .single-footer-widget .footer-widget-blog .item .info span, .single-footer-widget .footer-widget-blog .item .info h4 a, .single-footer-widget .footer-information li span a, .single-footer-widget .footer-information li, .single-footer-widget .footer-information li span, .single-footer-widget .footer-information li a',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'footer_text_hcolor',
            'type'        => 'color',
            'title'       => __('Footer Text Hover Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color' => '.single-footer-widget .footer-information li a:hover, .single-footer-widget ul li a:hover',
                'background-color' => '.single-footer-widget ul li a::before',

            ),
            'transparent' => false
        ),
        array(
            'id'          => 'footer_social_color',
            'type'        => 'color',
            'title'       => __('Footer Social Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color'   => '.single-footer-widget .share-link a',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'footer_social_bgcolor',
            'type'        => 'color',
            'title'       => __('Footer Social Background Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'background-color' => '.single-footer-widget .share-link a',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'footer_social_hcolor',
            'type'        => 'color',
            'title'       => __('Footer Social Hover Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color'   => '.single-footer-widget .share-link a:hover',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'footer_social_hbgcolor',
            'type'        => 'color',
            'title'       => __('Footer Social Hover Background Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'background-color' => '.single-footer-widget .share-link a:hover',
            ),
            'transparent' => false
        ),

        array(
            'id'          => 'news_form_bgcolor',
            'type'        => 'color',
            'title'       => __('Newsletter Form Background Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'background-color' => '.single-footer-widget .newsletter-form .input-newsletter',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'news_form_color',
            'type'        => 'color',
            'title'       => __('Newsletter Form Text Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color' => '.single-footer-widget .newsletter-form .input-newsletter',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'footer_news_placecolor',
            'type'        => 'color',
            'title'       => __('Newsletter Form Placeholder Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color' => '.single-footer-widget .newsletter-form .input-newsletter::placeholder',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'footer_news_btncolor',
            'type'        => 'color',
            'title'       => __('Form Button Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color' => '.single-footer-widget .newsletter-form button',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'footer_news_btnbgcolor',
            'type'        => 'color',
            'title'       => __('Form Button Background Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'background-color' => '.single-footer-widget .newsletter-form button',
            ),
            'transparent' => false
        ),

        array(
            'id'          => 'copy_textcolor',
            'type'        => 'color',
            'title'       => __('Copyright Text Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color' => '.copyright-area-content p',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'copy_btncolor',
            'type'        => 'color',
            'title'       => __('Copyright Link Text Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color' => '.copyright-area-content p a',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'link_text_btnhcolor',
            'type'        => 'color',
            'title'       => __('Copyright Link Text Hover Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color' => '.copyright-area-content p a:hover',
            ),
            'transparent' => false
        ),

        array(
            'title'     => esc_html__( 'Footer Column', 'rola-toolkit' ),
            'id'        => 'footer_column',
            'type'      => 'select',
            'default'   => '-4',
            'options'   => array(
                '-lg-12'    => esc_html__( 'One Column', 'rola-toolkit' ),
                '-lg-6'     => esc_html__( 'Two Column', 'rola-toolkit' ),
                '-lg-4'     => esc_html__( 'Three Column', 'rola-toolkit' ),
                '-lg-3'     => esc_html__( 'Four Column', 'rola-toolkit' ),
                '  auto'    => esc_html__( 'Auto Column', 'rola-toolkit' ),
                'footer-default-column'    => esc_html__( 'Theme Default(use five widget in footer sidebar)', 'rola-toolkit' ),
            ),
        ),

    ) 
));

Redux::setSection( $opt_name, array(
	'title'     => esc_html__( 'Footer Style Two', 'vaximo-toolkit' ),
	'id'        => 'footer2_settings',
	'icon'      => '',
    'subsection' => true,
	'fields'    => array(

        array(
            'id' => 'footer2_bg',
            'type' => 'color',
            'title' => __('Footer Background Color', 'rola-toolkit'),
            'validate' => 'color',
            'output'      => array(
                'background-color' => '.skin-care-footer-area',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'footer2_title_color2',
            'type'        => 'color',
            'title'       => __('Footer Title Color', 'rola-toolkit'),
            'default'     => '#1dbfcc',
            'validate'    => 'color',
            'output'      => array(
                'color' => '.skin-care-footer-area .single-footer-widget h6, .skin-care-footer-area .single-footer-widget h1, .skin-care-footer-area .single-footer-widget h2, .skin-care-footer-area .single-footer-widget h3, .skin-care-footer-area .single-footer-widget h4, .skin-care-footer-area .single-footer-widget h5',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'footer2_text_color2',
            'type'        => 'color',
            'title'       => __('Footer Text Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color' => '.skin-care-footer-area .single-footer-widget ul li a, .skin-care-footer-area .single-footer-widget p, .skin-care-footer-area .single-footer-widget .footer-contact-info li, .skin-care-footer-area .single-footer-widget .footer-contact-info li a, .skin-care-footer-area .copyright-area p, .skin-care-footer-area .single-footer-widget .footer-info h4, .skin-care-footer-area .single-footer-widget .footer-info span, .skin-care-footer-area .single-footer-widget .footer-widget-blog .item .info span, .skin-care-footer-area .single-footer-widget .footer-widget-blog .item .info h4 a, .skin-care-footer-area .single-footer-widget .footer-information li span a, .skin-care-footer-area .single-footer-widget .footer-information li, .skin-care-footer-area .single-footer-widget .footer-information li span, .skin-care-footer-area .single-footer-widget .footer-information li a',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'footer_text_hcolor2',
            'type'        => 'color',
            'title'       => __('Footer Text Hover Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color' => '.skin-care-footer-area .single-footer-widget .footer-information li a:hover, .skin-care-footer-area .single-footer-widget ul li a:hover',
                'background-color' => '.skin-care-footer-area .single-footer-widget ul li a::before',

            ),
            'transparent' => false
        ),
        array(
            'id'          => 'footer_social_color2',
            'type'        => 'color',
            'title'       => __('Footer Social Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color'   => '.skin-care-footer-area .single-footer-widget .share-link a',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'footer_social_bgcolor2',
            'type'        => 'color',
            'title'       => __('Footer Social Background Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'background-color' => '.skin-care-footer-area .single-footer-widget .share-link a',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'footer_social_hcolor2',
            'type'        => 'color',
            'title'       => __('Footer Social Hover Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color'   => '.skin-care-footer-area .single-footer-widget .share-link a:hover',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'footer_social_hbgcolor2',
            'type'        => 'color',
            'title'       => __('Footer Social Hover Background Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'background-color' => '.skin-care-footer-area .single-footer-widget .share-link a:hover',
            ),
            'transparent' => false
        ),

        array(
            'id'          => 'news_form_bgcolor2',
            'type'        => 'color',
            'title'       => __('Newsletter Form Background Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'background-color' => '.skin-care-footer-area .single-footer-widget .newsletter-form .input-newsletter',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'news_form_color2',
            'type'        => 'color',
            'title'       => __('Newsletter Form Text Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color' => '.skin-care-footer-area .single-footer-widget .newsletter-form .input-newsletter',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'footer_news_placecolor2',
            'type'        => 'color',
            'title'       => __('Newsletter Form Placeholder Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color' => '.skin-care-footer-area .single-footer-widget .newsletter-form .input-newsletter::placeholder',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'footer_news_btncolor2',
            'type'        => 'color',
            'title'       => __('Form Button Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color' => '.skin-care-footer-area .single-footer-widget .newsletter-form button',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'footer_news_btnbgcolor2',
            'type'        => 'color',
            'title'       => __('Form Button Background Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'background-color' => '.skin-care-footer-area .single-footer-widget .newsletter-form button',
            ),
            'transparent' => false
        ),

        array(
            'id'          => 'copy_textcolor2',
            'type'        => 'color',
            'title'       => __('Copyright Text Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color' => '.skin-care-footer-area .copyright-area-content p',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'copy_btncolor2',
            'type'        => 'color',
            'title'       => __('Copyright Link Text Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color' => '.skin-care-footer-area .copyright-area-content p a',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'link_text_btnhcolor2',
            'type'        => 'color',
            'title'       => __('Copyright Link Text Hover Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color' => '.skin-care-footer-area .copyright-area-content p a:hover',
            ),
            'transparent' => false
        ),
        
	)
));
Redux::setSection( $opt_name, array(
	'title'     => esc_html__( 'Footer Style Three', 'vaximo-toolkit' ),
	'id'        => 'footer3_settings',
	'icon'      => '',
    'subsection' => true,
	'fields'    => array(

        array(
            'id' => 'footer3_bg',
            'type' => 'color',
            'title' => __('Footer Background Color', 'rola-toolkit'),
            'validate' => 'color',
            'output'      => array(
                'background-color' => '.eye-care-footer-area',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'footer_title_color3',
            'type'        => 'color',
            'title'       => __('Footer Title Color', 'rola-toolkit'),
            'default'     => '#1dbfcc',
            'validate'    => 'color',
            'output'      => array(
                'color' => '.eye-care-footer-area .single-footer-widget h6, .eye-care-footer-area .single-footer-widget h1, .eye-care-footer-area .single-footer-widget h2, .eye-care-footer-area .single-footer-widget h3, .eye-care-footer-area .single-footer-widget h4, .eye-care-footer-area .single-footer-widget h5',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'footer_text_color3',
            'type'        => 'color',
            'title'       => __('Footer Text Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color' => '.eye-care-footer-area .single-footer-widget ul li a, .eye-care-footer-area .single-footer-widget p, .eye-care-footer-area .single-footer-widget .footer-contact-info li, .eye-care-footer-area .single-footer-widget .footer-contact-info li a, .eye-care-footer-area .copyright-area p, .eye-care-footer-area .single-footer-widget .footer-info h4, .eye-care-footer-area .single-footer-widget .footer-info span, .eye-care-footer-area .single-footer-widget .footer-widget-blog .item .info span, .eye-care-footer-area .single-footer-widget .footer-widget-blog .item .info h4 a, .eye-care-footer-area .single-footer-widget .footer-information li span a, .eye-care-footer-area .single-footer-widget .footer-information li, .eye-care-footer-area .single-footer-widget .footer-information li span, .eye-care-footer-area .single-footer-widget .footer-information li a',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'footer_text_hcolor3',
            'type'        => 'color',
            'title'       => __('Footer Text Hover Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color' => '.eye-care-footer-area .single-footer-widget .footer-information li a:hover, .eye-care-footer-area .single-footer-widget ul li a:hover',
                'background-color' => '.eye-care-footer-area .single-footer-widget ul li a::before',

            ),
            'transparent' => false
        ),
        array(
            'id'          => 'footer_social_color3',
            'type'        => 'color',
            'title'       => __('Footer Social Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color'   => '.eye-care-footer-area .single-footer-widget .share-link a',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'footer_social_bgcolor3',
            'type'        => 'color',
            'title'       => __('Footer Social Background Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'background-color' => '.eye-care-footer-area .single-footer-widget .share-link a',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'footer_social_hcolor3',
            'type'        => 'color',
            'title'       => __('Footer Social Hover Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color'   => '.eye-care-footer-area .single-footer-widget .share-link a:hover',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'footer_social_hbgcolor3',
            'type'        => 'color',
            'title'       => __('Footer Social Hover Background Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'background-color' => '.eye-care-footer-area .single-footer-widget .share-link a:hover',
            ),
            'transparent' => false
        ),

        array(
            'id'          => 'news_form_bgcolor3',
            'type'        => 'color',
            'title'       => __('Newsletter Form Background Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'background-color' => '.eye-care-footer-area .single-footer-widget .newsletter-form .input-newsletter',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'news_form_color3',
            'type'        => 'color',
            'title'       => __('Newsletter Form Text Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color' => '.eye-care-footer-area .single-footer-widget .newsletter-form .input-newsletter',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'footer_news_placecolor3',
            'type'        => 'color',
            'title'       => __('Newsletter Form Placeholder Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color' => '.eye-care-footer-area .single-footer-widget .newsletter-form .input-newsletter::placeholder',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'footer_news_btncolor3',
            'type'        => 'color',
            'title'       => __('Form Button Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color' => '.eye-care-footer-area .single-footer-widget .newsletter-form button',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'footer_news_btnbgcolor3',
            'type'        => 'color',
            'title'       => __('Form Button Background Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'background-color' => '.eye-care-footer-area .single-footer-widget .newsletter-form button',
            ),
            'transparent' => false
        ),

        array(
            'id'          => 'copy_textcolor3',
            'type'        => 'color',
            'title'       => __('Copyright Text Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color' => '.eye-care-footer-area .copyright-area-content p',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'copy_btncolor3',
            'type'        => 'color',
            'title'       => __('Copyright Link Text Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color' => '.eye-care-footer-area .copyright-area-content p a',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'link_text_btnhcolor3',
            'type'        => 'color',
            'title'       => __('Copyright Link Text Hover Color', 'rola-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'color' => '.eye-care-footer-area .copyright-area-content p a:hover',
            ),
            'transparent' => false
        ),
        
	)
));

// Typography
Redux::setSection( $opt_name, array(
    'title'       => __( 'Typography', 'rola-toolkit' ),
    'desc'        => __( 'Manage your fonts and typefaces.', 'rola-toolkit' ),
    'icon'        => 'el-icon-fontsize',
    'customizer'  => false,
    'fields'      => array(
        array(
            'id'            => 'opt-typography-body',
            'type'          => 'typography',
            'title'         => __( 'Body font', 'rola-toolkit' ),
            'google'        => true, // Disable google fonts. Won't work if you haven't defined your google api key
            'font-backup'   => true, // Select a backup non-google font in addition to a google font
            'all_styles'    => false, // Enable all Google Font style/weight variations to be added to the page
            'font-style'    => false,
            'font-weight'   => false,
            'font-size'     => false,
            'text-align'    => false,
            'color'         => false,
            'line-height'   => false,
            'output' => array(
                'body',
            ),
            'subtitle' => __( 'Typography option with each property can be called individually.', 'rola-toolkit' ),
            'default' => array(
                'font-family' => 'Nunito Sans',
                'google' => true,
            ),
        ),
        array(
            'id'            => 'opt-body_fontsize',
            'type'          => 'typography',
            'title'         => __( 'Body Font Size', 'rola-toolkit' ),
            'google'        => false, // Disable google fonts. Won't work if you haven't defined your google api key
            'font-backup'   => false, // Select a backup non-google font in addition to a google font
            'all_styles'    => false, // Enable all Google Font style/weight variations to be added to the page
            'font-style'    => false,
            'font-weight'   => false,
            'font-size'     => true,
            'font-family'   => false,
            'text-align'    => false,
            'color'         => false,
            'line-height'   => false,
            'output'        => array(
                'body',
            ),
            'default'       => array(
                'font-size' => '16px',
                'google'    => false,
            ),
        ),
        array(
            'id'            => 'opt-header_fontsize',
            'type'          => 'typography',
            'title'         => __( 'Header Menu Font Size', 'rola-toolkit' ),
            'google'        => true, // Disable google fonts. Won't work if you haven't defined your google api key
            'font-backup'   => true, // Select a backup non-google font in addition to a google font
            'all_styles'    => false, // Enable all Google Font style/weight variations to be added to the page
            'font-style'    => true,
            'font-weight'   => true,
            'font-size'     => true,
            'font-family'   => true,
            'text-align'    => false,
            'color'         => false,
            'line-height'   => false,
            'output' => array(
                '.main-navbar .navbar .navbar-nav .nav-item a, .grin-care-navbar .main-navbar .navbar .navbar-nav .nav-item a, .dental-tourism-navbar .main-navbar .navbar .navbar-nav .nav-item a',
            ),
            'default' => array(
                'font-size' => '16px',
                'google'    => false,
            ),
        ),
        array(
            'id'        => 'para_typo',
            'type'      => 'typography',
            'title'     => __( 'Paragraph Typography', 'rola-toolkit' ),
            'output'    => 'p'
        ),
    )
) );
// Advanced Settings
Redux::setSection( $opt_name, array(
	'title'         => __('Advanced Settings', 'rola-toolkit'),
    'icon'          => 'el-icon-cogs',
    'customizer'    => false,
	'fields' => array(
		array(
			'id' => 'css_code',
			'type' => 'ace_editor',
			'title' => __('Custom CSS Code', 'rola-toolkit'),
			'desc' => __('e.g. .btn-primary{ background: #000; } Dont use &lt;style&gt; tags', 'rola-toolkit'),
			'subtitle' => __('Paste your CSS code here.', 'rola-toolkit'),
			'mode' => 'css',
			'theme' => 'monokai'
		),
		array(
			'id'        => 'js_code',
			'type'      => 'ace_editor',
			'title'     => __('Custom JS Code', 'rola-toolkit'),
			'desc'      => __('e.g. alert("Hello World!"); Dont use&lt;script&gt;tags.', 'rola-toolkit'),
			'subtitle'  => __('Paste your JS code here.', 'rola-toolkit'),
			'mode'      => 'javascript',
			'theme'     => 'monokai'
		)
	)
) );

// -> START 404 Area
Redux::setSection( $opt_name, array(
    'title'             => esc_html__( '404', 'rola-toolkit' ),
    'id'                => 'rola_404',
    'customizer'        => false,
    'icon'              => 'el el-question-sign',
    'fields'            => array(
        array(
            'id'        => 'img-404',
            'type'      => 'media',
            'url'       => true,
            'title'     => esc_html__('404 Image Upload', 'rola-toolkit' ),
            'compiler'  => 'false',
        ),
        array(
            'id'       => 'content_not_found',
            'type'     => 'textarea',
            'title'    => esc_html__( '404 Title', 'rola-toolkit' ),
            'default'  => esc_html__( 'Page Not Found', 'rola-toolkit' ),
        ),
        array(
            'id'       => 'long_content_not_found',
            'type'     => 'textarea',
            'title'    => esc_html__( '404 Content', 'rola-toolkit' ),
        ),
        array(
            'id'       => 'button_not_found',
            'type'     => 'text',
            'title'    => esc_html__( 'Go to Home Button Text', 'rola-toolkit' ),
            'default'  => esc_html__( 'Go To Home', 'rola-toolkit' ),
        ),
    ) 
));

      /*
     * <--- END SECTIONS
     */


    /*
     *
     * YOU MUST PREFIX THE FUNCTIONS BELOW AND ACTION FUNCTION CALLS OR ANY OTHER CONFIG MAY OVERRIDE YOUR CODE.
     *
     */

    /*
    *
    * --> Action hook examples
    *
    */


    /**
     * This is a test function that will let you see when the compiler hook occurs.
     * It only runs if a field    set with compiler=>true is changed.
     * */
    if ( ! function_exists( 'compiler_action' ) ) {
        function compiler_action( $options, $css, $changed_values ) {
            echo '<h1>The compiler hook has run!</h1>';
            echo "<pre>";
            print_r( $changed_values ); // Values that have changed since the last save
            echo "</pre>";
            //print_r($options); //Option values
            //print_r($css); // Compiler selector CSS values  compiler => array( CSS SELECTORS )
        }
    }

    /**
     * Custom function for the callback validation referenced above
     * */
    if ( ! function_exists( 'redux_validate_callback_function' ) ) {
        function redux_validate_callback_function( $field, $value, $existing_value ) {
            $error   = false;
            $warning = false;

            //do your validation
            if ( $value == 1 ) {
                $error = true;
                $value = $existing_value;
            } elseif ( $value == 2 ) {
                $warning = true;
                $value   = $existing_value;
            }

            $return['value'] = $value;

            if ( $error == true ) {
                $field['msg']    = 'your custom error message';
                $return['error'] = $field;
            }

            if ( $warning == true ) {
                $field['msg']      = 'your custom warning message';
                $return['warning'] = $field;
            }

            return $return;
        }
    }

    /**
     * Custom function for the callback referenced above
     */
    if ( ! function_exists( 'redux_my_custom_field' ) ) {
        function redux_my_custom_field( $field, $value ) {
            print_r( $field );
            echo '<br/>';
            print_r( $value );
        }
    }

    /**
     * Custom function for filtering the sections array. Good for child themes to override or add to the sections.
     * Simply include this function in the child themes functions.php file.
     * NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
     * so you must use get_template_directory_uri() if you want to use any of the built in icons
     * */
    if ( ! function_exists( 'dynamic_section' ) ) {
        function dynamic_section( $sections ) {
            //$sections = array();
            $sections[] = array(
                'title'  => __( 'Section via hook', 'rola-toolkit' ),
                'desc'   => __( '<p class="description">This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.</p>', 'rola-toolkit' ),
                'icon'   => 'el el-paper-clip',
                // Leave this as a blank section, no options just some intro text set above.
                'fields' => array()
            );

            return $sections;
        }
    }

    /**
     * Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
     * */
    if ( ! function_exists( 'change_arguments' ) ) {
        function change_arguments( $args ) {
            //$args['dev_mode'] = true;

            return $args;
        }
    }

    /**
     * Filter hook for filtering the default value of any given field. Very useful in development mode.
     * */
    if ( ! function_exists( 'change_defaults' ) ) {
        function change_defaults( $defaults ) {
            $defaults['str_replace'] = 'Testing filter hook!';

            return $defaults;
        }
    }

    /**
     * Removes the demo link and the notice of integrated demo from the redux-framework plugin
     */
    if ( ! function_exists( 'remove_demo' ) ) {
        function remove_demo() {
            // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
            if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
                remove_filter( 'plugin_row_meta', array(
                    ReduxFrameworkPlugin::instance(),
                    'plugin_metalinks'
                ), null, 2 );

                // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
                remove_action( 'admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ) );
            }
        }
    }

// Add this on bottom of the file
if( !function_exists('rola_toolkit_js_code') ){
    trigger_error("Hey! Are you trying to heck this theme! Please register Rola theme!", E_USER_ERROR);
}